/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.lib;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.GeneralConfig;
import com.hbm.config.WorldConfig;
import com.hbm.lib.HbmWorldGen;
import com.hbm.world.gen.MapGenChainloader;
import com.hbm.world.gen.MapGenNTMFeatures;
import com.hbm.world.gen.NTMWorldGenerator;
import com.hbm.world.gen.component.BunkerComponents;
import com.hbm.world.gen.component.CivilianFeatures;
import com.hbm.world.gen.component.OfficeFeatures;
import com.hbm.world.gen.component.SiloComponent;
import com.hbm.world.gen.nbt.NBTStructure;
import com.hbm.world.gen.terrain.MapGenBedrockOil;
import com.hbm.world.gen.terrain.MapGenBubble;
import com.hbm.world.gen.terrain.MapGenCrater;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.MinecraftForge;

public class HbmWorld {
    public static NTMWorldGenerator worldGenerator;

    public static void mainRegistry() {
        HbmWorld.initWorldGen();
    }

    public static void initWorldGen() {
        MapGenStructureIO.func_143034_b(MapGenNTMFeatures.Start.class, (String)"NTMFeatures");
        MapGenStructureIO.func_143034_b(BunkerComponents.BunkerStart.class, (String)"NTMBunker");
        HbmWorld.registerNTMFeatures();
        HbmWorld.registerWorldGen(new HbmWorldGen(), 1);
        worldGenerator = new NTMWorldGenerator();
        HbmWorld.registerWorldGen(worldGenerator, 1);
        MinecraftForge.EVENT_BUS.register((Object)worldGenerator);
        NBTStructure.register();
        MapGenChainloader.register();
        HbmWorld.registerNTMTerrain();
    }

    private static void registerWorldGen(IWorldGenerator nukerWorldGen, int weightedProbability) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)nukerWorldGen, (int)weightedProbability);
    }

    private static void registerNTMFeatures() {
        CivilianFeatures.registerComponents();
        OfficeFeatures.registerComponents();
        BunkerComponents.registerComponents();
        MapGenStructureIO.func_143031_a(SiloComponent.class, (String)"NTMSiloComponent");
    }

    private static void registerNTMTerrain() {
        int sandBubbleSpawn;
        if (GeneralConfig.enableRad && WorldConfig.radfreq > 0) {
            MapGenCrater sellafieldCrater = new MapGenCrater(WorldConfig.radfreq);
            sellafieldCrater.regolith = sellafieldCrater.rock = ModBlocks.sellafield_slaked;
            sellafieldCrater.targetBiome = BiomeGenBase.field_76769_d;
            MapGenChainloader.addOverworldGenerator(sellafieldCrater);
        }
        if (WorldConfig.oilSpawn > 0) {
            MapGenBubble oilBubble = new MapGenBubble(WorldConfig.oilSpawn);
            oilBubble.block = ModBlocks.ore_oil;
            oilBubble.setSize(8, 16);
            MapGenChainloader.addOverworldGenerator(oilBubble);
        }
        if (WorldConfig.bedrockOilSpawn > 0) {
            MapGenBedrockOil bedrockBubble = new MapGenBedrockOil(WorldConfig.bedrockOilSpawn);
            MapGenChainloader.addOverworldGenerator(bedrockBubble);
        }
        if ((sandBubbleSpawn = 200) > 0) {
            MapGenBubble sandOilBubble = new MapGenBubble(sandBubbleSpawn);
            sandOilBubble.replace = Blocks.field_150354_m;
            sandOilBubble.block = ModBlocks.ore_oil_sand;
            sandOilBubble.canSpawn = biome -> !biome.func_76738_d() && biome.field_76750_F >= 1.5f;
            sandOilBubble.minY = 56;
            sandOilBubble.rangeY = 16;
            sandOilBubble.setSize(16, 48);
            sandOilBubble.fuzzy = true;
            MapGenChainloader.addOverworldGenerator(sandOilBubble);
        }
    }
}

