/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon.sedna.mags;

import com.hbm.inventory.fluid.FluidType;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.items.weapon.sedna.mags.IMagazine;
import com.hbm.particle.SpentCasing;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class MagazineLiquidEngine
implements IMagazine<FluidType> {
    public static final String KEY_MAG_COUNT = "magcount";
    public static final String KEY_MAG_PREV = "magprev";
    public static final String KEY_MAG_AFTER = "magafter";
    public int index;
    public int capacity;
    public FluidType[] acceptedTypes;

    public MagazineLiquidEngine(int index, int capacity, FluidType ... acceptedTypes) {
        this.index = index;
        this.capacity = capacity;
        this.acceptedTypes = acceptedTypes;
    }

    @Override
    public FluidType getType(ItemStack stack, IInventory inventory) {
        return this.acceptedTypes[0];
    }

    @Override
    public void setType(ItemStack stack, FluidType type) {
    }

    @Override
    public int getCapacity(ItemStack stack) {
        return this.capacity;
    }

    @Override
    public void useUpAmmo(ItemStack stack, IInventory inventory, int amount) {
        this.setAmount(stack, Math.max(this.getAmount(stack, inventory) - amount, 0));
    }

    @Override
    public int getAmount(ItemStack stack, IInventory inventory) {
        return MagazineLiquidEngine.getMagCount(stack, this.index);
    }

    @Override
    public void setAmount(ItemStack stack, int amount) {
        MagazineLiquidEngine.setMagCount(stack, this.index, amount);
    }

    @Override
    public boolean canReload(ItemStack stack, IInventory inventory) {
        return false;
    }

    @Override
    public void initNewType(ItemStack stack, IInventory inventory) {
    }

    @Override
    public void reloadAction(ItemStack stack, IInventory inventory) {
    }

    @Override
    public SpentCasing getCasing(ItemStack stack, IInventory inventory) {
        return null;
    }

    @Override
    public ItemStack getIconForHUD(ItemStack stack, EntityPlayer player) {
        return new ItemStack(ModItems.fluid_icon, 1, this.getType(stack, (IInventory)player.field_71071_by).getID());
    }

    @Override
    public String reportAmmoStateForHUD(ItemStack stack, EntityPlayer player) {
        return this.getAmount(stack, (IInventory)player.field_71071_by) + "/" + this.capacity + "mB";
    }

    @Override
    public void setAmountBeforeReload(ItemStack stack, int amount) {
        ItemGunBaseNT.setValueInt(stack, KEY_MAG_PREV + this.index, amount);
    }

    @Override
    public int getAmountBeforeReload(ItemStack stack) {
        return ItemGunBaseNT.getValueInt(stack, KEY_MAG_PREV + this.index);
    }

    @Override
    public void setAmountAfterReload(ItemStack stack, int amount) {
        ItemGunBaseNT.setValueInt(stack, KEY_MAG_AFTER + this.index, amount);
    }

    @Override
    public int getAmountAfterReload(ItemStack stack) {
        return ItemGunBaseNT.getValueInt(stack, KEY_MAG_AFTER + this.index);
    }

    public static int getMagCount(ItemStack stack, int index) {
        return ItemGunBaseNT.getValueInt(stack, KEY_MAG_COUNT + index);
    }

    public static void setMagCount(ItemStack stack, int index, int value) {
        ItemGunBaseNT.setValueInt(stack, KEY_MAG_COUNT + index, value);
    }
}

