/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.fluid.trait;

import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.fluid.trait.FluidTrait;
import com.hbm.util.BobMathUtil;
import java.io.IOException;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;

public class FT_Rocket
extends FluidTrait {
    private int isp;
    private long thrust;

    public FT_Rocket(int isp, long twr) {
        this.isp = isp;
        this.thrust = twr;
    }

    public int getISP() {
        return this.isp;
    }

    public long getThrust() {
        return this.thrust;
    }

    @Override
    public void addInfo(List<String> info) {
        super.addInfo(info);
        info.add(EnumChatFormatting.LIGHT_PURPLE + "[Rocket Grade]");
        if (this.isp > 0) {
            info.add(EnumChatFormatting.YELLOW + "Provides " + EnumChatFormatting.RED + "" + BobMathUtil.getShortNumber(this.isp) + " ISP " + EnumChatFormatting.YELLOW + "per bucket");
        }
        info.add(EnumChatFormatting.RED + "[Thrust power]");
        if (this.thrust > 0L) {
            info.add(EnumChatFormatting.YELLOW + "Provides " + EnumChatFormatting.RED + "" + BobMathUtil.getShortNumber(this.thrust) + " N " + EnumChatFormatting.YELLOW + "of thrust per bucket");
        }
    }

    @Override
    public void serializeJSON(JsonWriter writer) throws IOException {
        writer.name("isp").value((long)this.isp);
        writer.name("thrust").value(this.thrust);
    }

    @Override
    public void deserializeJSON(JsonObject obj) {
        this.isp = obj.get("isp").getAsInt();
        this.thrust = obj.get("thrust").getAsLong();
    }
}

