/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.config.GeneralConfig;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class RecipesCommon {
    public static ItemStack[] copyStackArray(ItemStack[] array) {
        if (array == null) {
            return null;
        }
        ItemStack[] clone = new ItemStack[array.length];
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            clone[i] = array[i].func_77946_l();
        }
        return clone;
    }

    public static ItemStack[] objectToStackArray(Object[] array) {
        if (array == null) {
            return null;
        }
        ItemStack[] clone = new ItemStack[array.length];
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] instanceof ItemStack)) continue;
            clone[i] = (ItemStack)array[i];
        }
        return clone;
    }

    public static class MetaBlock {
        public Block block;
        public int meta;

        public MetaBlock(Block block, int meta) {
            this.block = block;
            this.meta = meta;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Block.field_149771_c.func_148750_c((Object)this.block).hashCode();
            result = 31 * result + this.meta;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MetaBlock other = (MetaBlock)obj;
            if (this.block == null ? other.block != null : !this.block.equals(other.block)) {
                return false;
            }
            return this.meta == other.meta;
        }

        public MetaBlock(Block block) {
            this(block, 0);
        }

        @Deprecated
        public int getID() {
            return this.hashCode();
        }
    }

    public static class OreDictStack
    extends AStack {
        public String name;

        public OreDictStack(String name) {
            this.name = name;
            this.stacksize = 1;
        }

        public OreDictStack(String name, int stacksize) {
            this(name);
            this.stacksize = stacksize;
        }

        public List<ItemStack> toStacks() {
            return OreDictionary.getOres((String)this.name);
        }

        @Override
        public int compareTo(AStack stack) {
            if (stack instanceof OreDictStack) {
                OreDictStack comp = (OreDictStack)stack;
                return this.name.compareTo(comp.name);
            }
            if (stack instanceof ComparableStack) {
                return -1;
            }
            return 0;
        }

        @Override
        public AStack copy() {
            return new OreDictStack(this.name, this.stacksize);
        }

        public OreDictStack copy(int stacksize) {
            return new OreDictStack(this.name, stacksize);
        }

        @Override
        public boolean matchesRecipe(ItemStack stack, boolean ignoreSize) {
            if (stack == null) {
                return false;
            }
            if (!ignoreSize && stack.field_77994_a < this.stacksize) {
                return false;
            }
            int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
            if (ids == null || ids.length == 0) {
                return false;
            }
            for (int i = 0; i < ids.length; ++i) {
                if (!this.name.equals(OreDictionary.getOreName((int)ids[i]))) continue;
                return true;
            }
            return false;
        }

        @Override
        public List<ItemStack> extractForNEI() {
            ArrayList fromDict = OreDictionary.getOres((String)this.name);
            ArrayList<ItemStack> ores = new ArrayList<ItemStack>();
            for (ItemStack stack : fromDict) {
                ItemStack copy = stack.func_77946_l();
                copy.field_77994_a = this.stacksize;
                if (stack.func_77960_j() != Short.MAX_VALUE) {
                    ores.add(copy);
                    continue;
                }
                ores.addAll(MainRegistry.proxy.getSubItems(copy));
            }
            return ores;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + this.stacksize;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OreDictStack other = (OreDictStack)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.stacksize == other.stacksize;
        }
    }

    public static class ComparableNBTStack
    extends ComparableStack {
        NBTTagCompound nbt;

        public ComparableNBTStack(ItemStack stack) {
            super(stack);
        }

        public ComparableNBTStack(Item item) {
            super(item);
        }

        public ComparableNBTStack(Block item) {
            super(item);
        }

        public ComparableNBTStack(Block item, int stacksize) {
            super(item, stacksize);
        }

        public ComparableNBTStack(Block item, int stacksize, int meta) {
            super(item, stacksize, meta);
        }

        public ComparableNBTStack(Item item, int stacksize) {
            super(item, stacksize);
        }

        public ComparableNBTStack(Item item, int stacksize, int meta) {
            super(item, stacksize, meta);
        }

        public ComparableNBTStack addNBT(NBTTagCompound nbt) {
            this.nbt = nbt;
            return this;
        }

        @Override
        public ItemStack toStack() {
            ItemStack stack = super.toStack();
            stack.field_77990_d = this.nbt;
            return stack;
        }
    }

    public static class ComparableStack
    extends AStack {
        public Item item;
        public int meta;

        public ComparableStack(ItemStack stack) {
            block4: {
                if (stack == null) {
                    this.item = ModItems.nothing;
                    this.stacksize = 1;
                    return;
                }
                try {
                    this.item = stack.func_77973_b();
                    if (this.item == null) {
                        this.item = ModItems.nothing;
                    }
                    this.stacksize = stack.field_77994_a;
                    this.meta = stack.func_77960_j();
                }
                catch (Exception ex) {
                    this.item = ModItems.nothing;
                    if (GeneralConfig.enableSilentCompStackErrors) break block4;
                    ex.printStackTrace();
                }
            }
        }

        public ComparableStack makeSingular() {
            this.stacksize = 1;
            return this;
        }

        public ComparableStack(Item item) {
            this.item = item;
            if (this.item == null) {
                this.item = ModItems.nothing;
            }
            this.stacksize = 1;
            this.meta = 0;
        }

        public ComparableStack(Block item) {
            this.item = Item.func_150898_a((Block)item);
            this.stacksize = 1;
            this.meta = 0;
        }

        public ComparableStack(Block item, int stacksize) {
            this.item = Item.func_150898_a((Block)item);
            this.stacksize = stacksize;
            this.meta = 0;
        }

        public ComparableStack(Block item, int stacksize, int meta) {
            this.item = Item.func_150898_a((Block)item);
            this.stacksize = stacksize;
            this.meta = meta;
        }

        public ComparableStack(Item item, int stacksize) {
            this(item);
            this.stacksize = stacksize;
        }

        public ComparableStack(Item item, int stacksize, int meta) {
            this(item, stacksize);
            this.meta = meta;
        }

        public ComparableStack(Item item, int stacksize, Enum meta) {
            this(item, stacksize);
            this.meta = meta.ordinal();
        }

        public ItemStack toStack() {
            return new ItemStack(this.item == null ? ModItems.nothing : this.item, this.stacksize, this.meta);
        }

        public String[] getDictKeys() {
            int[] ids = OreDictionary.getOreIDs((ItemStack)this.toStack());
            if (ids == null || ids.length == 0) {
                return new String[0];
            }
            String[] entries = new String[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                entries[i] = OreDictionary.getOreName((int)ids[i]);
            }
            return entries;
        }

        public int hashCode() {
            String name;
            if (this.item == null) {
                if (!GeneralConfig.enableSilentCompStackErrors) {
                    MainRegistry.logger.error("ComparableStack has a null item! This is a serious issue!");
                    Thread.currentThread();
                    Thread.dumpStack();
                }
                this.item = ModItems.nothing;
            }
            if ((name = Item.field_150901_e.func_148750_c((Object)this.item)) == null) {
                if (!GeneralConfig.enableSilentCompStackErrors) {
                    MainRegistry.logger.error("ComparableStack holds an item that does not seem to be registered. How does that even happen? This error can be turned off with the config <enableSilentCompStackErrors>. Item name: " + this.item.func_77658_a());
                    Thread.currentThread();
                    Thread.dumpStack();
                }
                this.item = ModItems.nothing;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Item.field_150901_e.func_148750_c((Object)this.item).hashCode();
            result = 31 * result + this.meta;
            result = 31 * result + this.stacksize;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ComparableStack other = (ComparableStack)obj;
            if (this.item == null ? other.item != null : !this.item.equals(other.item)) {
                return false;
            }
            if (this.meta != Short.MAX_VALUE && other.meta != Short.MAX_VALUE && this.meta != other.meta) {
                return false;
            }
            return this.stacksize == other.stacksize;
        }

        @Override
        public int compareTo(AStack stack) {
            if (stack instanceof ComparableStack) {
                int thatID;
                ComparableStack comp = (ComparableStack)stack;
                int thisID = Item.func_150891_b((Item)this.item);
                if (thisID > (thatID = Item.func_150891_b((Item)comp.item))) {
                    return 1;
                }
                if (thatID > thisID) {
                    return -1;
                }
                if (this.meta > comp.meta) {
                    return 1;
                }
                if (comp.meta > this.meta) {
                    return -1;
                }
                return 0;
            }
            if (stack instanceof OreDictStack) {
                return 1;
            }
            return 0;
        }

        @Override
        public AStack copy() {
            return new ComparableStack(this.item, this.stacksize, this.meta);
        }

        public ComparableStack copy(int stacksize) {
            return new ComparableStack(this.item, stacksize, this.meta);
        }

        @Override
        public boolean matchesRecipe(ItemStack stack, boolean ignoreSize) {
            if (stack == null) {
                return false;
            }
            if (stack.func_77973_b() != this.item) {
                return false;
            }
            if (this.meta != Short.MAX_VALUE && stack.func_77960_j() != this.meta) {
                return false;
            }
            return ignoreSize || stack.field_77994_a >= this.stacksize;
        }

        @Override
        public List<ItemStack> extractForNEI() {
            return Arrays.asList(this.toStack());
        }
    }

    public static abstract class AStack
    implements Comparable<AStack> {
        public int stacksize;

        public boolean isApplicable(ItemStack stack) {
            return this.isApplicable(new ComparableStack(stack));
        }

        public boolean isApplicable(ComparableStack comp) {
            if (this instanceof ComparableStack) {
                return ((ComparableStack)this).equals(comp);
            }
            if (this instanceof OreDictStack) {
                ArrayList ores = OreDictionary.getOres((String)((OreDictStack)this).name);
                for (ItemStack stack : ores) {
                    if (stack.func_77973_b() != comp.item || stack.func_77960_j() != Short.MAX_VALUE && stack.func_77960_j() != comp.meta) continue;
                    return true;
                }
            }
            return false;
        }

        public abstract boolean matchesRecipe(ItemStack var1, boolean var2);

        public abstract AStack copy();

        public abstract List<ItemStack> extractForNEI();

        public ItemStack extractForCyclingDisplay(int cycle) {
            List<ItemStack> list = this.extractForNEI();
            cycle *= 50;
            if (list.isEmpty()) {
                return new ItemStack(ModItems.nothing);
            }
            return list.get((int)(System.currentTimeMillis() % (long)(cycle * list.size()) / (long)cycle));
        }
    }
}

