/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.GeneralConfig;
import com.hbm.config.MobConfig;
import com.hbm.config.WorldConfig;
import com.hbm.entity.mob.EntityFBI;
import com.hbm.entity.mob.EntityFBIDrone;
import com.hbm.entity.mob.EntityGhost;
import com.hbm.entity.mob.EntityMaskMan;
import com.hbm.entity.mob.EntityRADBeast;
import com.hbm.entity.projectile.EntityMeteor;
import com.hbm.extprop.HbmLivingProps;
import com.hbm.handler.ArmorModHandler;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import com.hbm.saveddata.TomSaveData;
import com.hbm.util.ContaminationUtil;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldProviderHell;
import net.minecraftforge.event.ForgeEventFactory;

public class BossSpawnHandler {
    private static final Random meteorRand = new Random();
    public static int meteorShower = 0;

    public static void rollTheDice(World world) {
        double spawnY;
        EntityPlayer player;
        TomSaveData data = TomSaveData.forWorld(world);
        if (MobConfig.enableMaskman && !data.impact && world.func_82737_E() % (long)MobConfig.maskmanDelay == 0L && world.field_73012_v.nextInt(MobConfig.maskmanChance) == 0 && !world.field_73010_i.isEmpty() && world.field_73011_w.func_76569_d()) {
            boolean acidizerStat;
            player = (EntityPlayer)world.field_73010_i.get(world.field_73012_v.nextInt(world.field_73010_i.size()));
            int id = Item.func_150891_b((Item)Item.func_150898_a((Block)ModBlocks.machine_crystallizer));
            StatBase statCraft = StatList.field_75928_D[id];
            StatBase statPlace = StatList.field_75929_E[id];
            if (!(player instanceof EntityPlayerMP)) {
                return;
            }
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            boolean bl = acidizerStat = !GeneralConfig.enableStatReRegistering || statCraft != null && playerMP.func_147099_x().func_77444_a(statCraft) > 0 || statPlace != null && playerMP.func_147099_x().func_77444_a(statPlace) > 0;
            if (acidizerStat && ContaminationUtil.getRads((Entity)player) >= (float)MobConfig.maskmanMinRad && ((double)world.func_72976_f((int)player.field_70165_t, (int)player.field_70161_v) > player.field_70163_u + 3.0 || !MobConfig.maskmanUnderground)) {
                player.func_146105_b(new ChatComponentText("The mask man is about to claim another victim.").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
                double spawnX = player.field_70165_t + world.field_73012_v.nextGaussian() * 20.0;
                double spawnZ = player.field_70161_v + world.field_73012_v.nextGaussian() * 20.0;
                double spawnY2 = world.func_72976_f((int)spawnX, (int)spawnZ);
                BossSpawnHandler.trySpawn(world, (float)spawnX, (float)spawnY2, (float)spawnZ, (EntityLiving)new EntityMaskMan(world));
            }
        }
        if (MobConfig.enableRaids && !data.impact && world.func_82737_E() % (long)MobConfig.raidDelay == 0L && world.field_73012_v.nextInt(MobConfig.raidChance) == 0 && !world.field_73010_i.isEmpty() && world.field_73011_w.func_76569_d()) {
            player = (EntityPlayer)world.field_73010_i.get(world.field_73012_v.nextInt(world.field_73010_i.size()));
            if (player.getEntityData().func_74775_l("PlayerPersisted").func_74763_f("fbiMark") < world.func_82737_E()) {
                int i;
                player.func_146105_b(new ChatComponentText("FBI, OPEN UP!").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
                Vec3 vec = Vec3.func_72443_a((double)MobConfig.raidAttackDistance, (double)0.0, (double)0.0);
                vec.func_72442_b((float)Math.PI * 2 * world.field_73012_v.nextFloat());
                for (i = 0; i < MobConfig.raidAmount; ++i) {
                    double spawnX = player.field_70165_t + vec.field_72450_a + world.field_73012_v.nextGaussian() * 5.0;
                    double spawnZ = player.field_70161_v + vec.field_72449_c + world.field_73012_v.nextGaussian() * 5.0;
                    spawnY = world.func_72976_f((int)spawnX, (int)spawnZ);
                    BossSpawnHandler.trySpawn(world, (float)spawnX, (float)spawnY, (float)spawnZ, (EntityLiving)new EntityFBI(world));
                }
                for (i = 0; i < MobConfig.raidDrones; ++i) {
                    double spawnX = player.field_70165_t + vec.field_72450_a + world.field_73012_v.nextGaussian() * 5.0;
                    double spawnZ = player.field_70161_v + vec.field_72449_c + world.field_73012_v.nextGaussian() * 5.0;
                    spawnY = world.func_72976_f((int)spawnX, (int)spawnZ);
                    BossSpawnHandler.trySpawn(world, (float)spawnX, (float)spawnY + 10.0f, (float)spawnZ, (EntityLiving)new EntityFBIDrone(world));
                }
            }
        }
        if (MobConfig.enableElementals && world.func_82737_E() % (long)MobConfig.elementalDelay == 0L && world.field_73012_v.nextInt(MobConfig.elementalChance) == 0 && !world.field_73010_i.isEmpty() && world.field_73011_w.func_76569_d()) {
            player = (EntityPlayer)world.field_73010_i.get(world.field_73012_v.nextInt(world.field_73010_i.size()));
            if (player.getEntityData().func_74775_l("PlayerPersisted").func_74767_n("radMark")) {
                player.func_146105_b(new ChatComponentText("You hear a faint clicking...").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)));
                player.getEntityData().func_74775_l("PlayerPersisted").func_74757_a("radMark", false);
                Vec3 vec = Vec3.func_72443_a((double)MobConfig.raidAttackDistance, (double)0.0, (double)0.0);
                for (int i = 0; i < MobConfig.elementalAmount; ++i) {
                    vec.func_72442_b((float)Math.PI * 2 * world.field_73012_v.nextFloat());
                    double spawnX = player.field_70165_t + vec.field_72450_a + world.field_73012_v.nextGaussian();
                    double spawnZ = player.field_70161_v + vec.field_72449_c + world.field_73012_v.nextGaussian();
                    spawnY = world.func_72976_f((int)spawnX, (int)spawnZ);
                    EntityRADBeast rad = new EntityRADBeast(world);
                    if (i == 0) {
                        rad.makeLeader();
                    }
                    BossSpawnHandler.trySpawn(world, (float)spawnX, (float)spawnY, (float)spawnZ, (EntityLiving)rad);
                }
            }
        }
        if (WorldConfig.enableMeteorStrikes && !world.field_72995_K) {
            BossSpawnHandler.meteorUpdate(world);
        }
        if (world.func_82737_E() % 20L == 0L && world.field_73012_v.nextInt(5) == 0 && !world.field_73010_i.isEmpty() && world.field_73011_w.func_76569_d() && HbmLivingProps.getDigamma((EntityLivingBase)(player = (EntityPlayer)world.field_73010_i.get(world.field_73012_v.nextInt(world.field_73010_i.size())))) > 0.0f) {
            Vec3 vec = Vec3.func_72443_a((double)75.0, (double)0.0, (double)0.0);
            vec.func_72442_b((float)Math.PI * 2 * world.field_73012_v.nextFloat());
            double spawnX = player.field_70165_t + vec.field_72450_a + world.field_73012_v.nextGaussian();
            double spawnZ = player.field_70161_v + vec.field_72449_c + world.field_73012_v.nextGaussian();
            double spawnY3 = world.func_72976_f((int)spawnX, (int)spawnZ);
            BossSpawnHandler.trySpawn(world, (float)spawnX, (float)spawnY3, (float)spawnZ, (EntityLiving)new EntityGhost(world));
        }
    }

    private static void trySpawn(World world, float x, float y, float z, EntityLiving e) {
        e.func_70012_b((double)x, (double)y, (double)z, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)e, (World)world, (float)x, (float)y, (float)z);
        if (canSpawn == Event.Result.ALLOW || canSpawn == Event.Result.DEFAULT) {
            world.func_72838_d((Entity)e);
            ForgeEventFactory.doSpecialSpawn((EntityLiving)e, (World)world, (float)x, (float)y, (float)z);
            e.func_110161_a(null);
        }
    }

    public static void markFBI(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            player.getEntityData().func_74775_l("PlayerPersisted").func_74772_a("fbiMark", player.field_70170_p.func_82737_E() + 24000L);
        }
    }

    private static void meteorUpdate(World world) {
        EntityPlayer p;
        if (!(meteorRand.nextInt(meteorShower > 0 ? WorldConfig.meteorShowerChance : WorldConfig.meteorStrikeChance) != 0 || world.field_73010_i.isEmpty() || (p = (EntityPlayer)world.field_73010_i.get(meteorRand.nextInt(world.field_73010_i.size()))) == null || p.field_70170_p.field_73011_w instanceof WorldProviderHell || p.field_70170_p.field_73011_w instanceof WorldProviderEnd)) {
            boolean repell = false;
            boolean strike = true;
            for (int i = 0; i < 4; ++i) {
                ItemStack armor = p.func_82169_q(i);
                if (armor == null || !ArmorModHandler.hasMods(armor)) continue;
                for (int j = 0; j < 8; ++j) {
                    ItemStack mod = ArmorModHandler.pryMods(armor)[j];
                    if (mod == null) continue;
                    if (mod.func_77973_b() == ModItems.protection_charm) {
                        repell = true;
                    }
                    if (mod.func_77973_b() != ModItems.meteor_charm) continue;
                    strike = false;
                }
            }
            if (strike) {
                BossSpawnHandler.spawnMeteorAtPlayer(p, repell, false);
            }
        }
        if (meteorShower > 0 && --meteorShower == 0 && GeneralConfig.enableDebugMode) {
            MainRegistry.logger.info("Ended meteor shower.");
        }
        if (meteorRand.nextInt(WorldConfig.meteorStrikeChance * 100) == 0 && WorldConfig.enableMeteorShowers) {
            meteorShower = (int)((double)WorldConfig.meteorShowerDuration * 0.75 + (double)WorldConfig.meteorShowerDuration * 0.25 * (double)meteorRand.nextFloat());
            if (GeneralConfig.enableDebugMode) {
                MainRegistry.logger.info("Started meteor shower! Duration: " + meteorShower);
            }
        }
    }

    public static void spawnMeteorAtPlayer(EntityPlayer player, boolean repell, boolean osmiridic) {
        Vec3 vec;
        EntityMeteor meteor = new EntityMeteor(player.field_70170_p);
        meteor.func_70080_a(player.field_70165_t + (double)meteorRand.nextInt(201) - 100.0, 384.0, player.field_70161_v + (double)meteorRand.nextInt(201) - 100.0, 0.0f, 0.0f);
        if (repell) {
            vec = Vec3.func_72443_a((double)(meteor.field_70165_t - player.field_70165_t), (double)0.0, (double)(meteor.field_70161_v - player.field_70161_v)).func_72432_b();
            double vel = meteorRand.nextDouble();
            vec.field_72450_a *= vel;
            vec.field_72449_c *= vel;
            meteor.safe = true;
        } else {
            vec = Vec3.func_72443_a((double)(meteorRand.nextDouble() - 0.5), (double)0.0, (double)0.0);
            vec.func_72442_b((float)(Math.PI * meteorRand.nextDouble()));
        }
        if (osmiridic) {
            EntityMeteor.osmiridium = true;
        }
        meteor.field_70159_w = vec.field_72450_a;
        meteor.field_70181_x = -2.5;
        meteor.field_70179_y = vec.field_72449_c;
        player.field_70170_p.func_72838_d((Entity)meteor);
    }
}

