/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.projectile;

import com.hbm.entity.projectile.EntityThrowableInterp;
import com.hbm.items.weapon.sedna.BulletConfig;
import com.hbm.items.weapon.sedna.factory.XFactoryTool;
import com.hbm.util.BobMathUtil;
import com.hbm.util.TrackerUtil;
import com.hbm.util.Vec3NT;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityBulletBaseMK4
extends EntityThrowableInterp
implements IEntityAdditionalSpawnData {
    public BulletConfig config;
    public double velocity;
    public double prevVelocity;
    public double accel;
    public float damage;
    public int ricochets = 0;
    public Entity lockonTarget = null;

    public EntityBulletBaseMK4(World world) {
        super(world);
        this.field_70155_l = 10.0;
        this.func_70105_a(0.5f, 0.5f);
        this.field_70178_ae = true;
    }

    public EntityBulletBaseMK4(World world, EntityLivingBase entity, BulletConfig config, float damage, float gunSpread, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        this(world);
        this.thrower = entity;
        this.setBulletConfig(config);
        this.damage = damage;
        this.func_70012_b(posX, posY, posZ, 0.0f, 0.0f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = motionX;
        this.field_70181_x = motionY;
        this.field_70179_y = motionZ;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.0f, this.config.spread + gunSpread);
    }

    public EntityBulletBaseMK4(EntityLivingBase entity, BulletConfig config, float baseDamage, float gunSpread, double sideOffset, double heightOffset, double frontOffset) {
        this(entity.field_70170_p);
        this.thrower = entity;
        this.setBulletConfig(config);
        this.damage = baseDamage * this.config.damageMult;
        this.func_70012_b(this.thrower.field_70165_t, this.thrower.field_70163_u + (double)this.thrower.func_70047_e(), this.thrower.field_70161_v, this.thrower.field_70177_z, this.thrower.field_70125_A);
        Vec3 offset = Vec3.func_72443_a((double)sideOffset, (double)heightOffset, (double)frontOffset);
        offset.func_72440_a(-this.field_70125_A / 180.0f * (float)Math.PI);
        offset.func_72442_b(-this.field_70177_z / 180.0f * (float)Math.PI);
        this.field_70165_t += offset.field_72450_a;
        this.field_70163_u += offset.field_72448_b;
        this.field_70161_v += offset.field_72449_c;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.0f, gunSpread);
    }

    public EntityBulletBaseMK4(World world, BulletConfig config, float baseDamage, float gunSpread, float yaw, float pitch) {
        this(world);
        this.setBulletConfig(config);
        this.damage = baseDamage * this.config.damageMult;
        this.field_70126_B = this.field_70177_z = yaw * 180.0f / (float)Math.PI;
        this.field_70127_C = this.field_70125_A = -pitch * 180.0f / (float)Math.PI;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.0f, gunSpread);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(3, (Object)0);
    }

    public void setBulletConfig(BulletConfig config) {
        this.config = config;
        this.field_70180_af.func_75692_b(3, (Object)config.id);
    }

    public BulletConfig getBulletConfig() {
        int id = this.field_70180_af.func_75679_c(3);
        if (id < 0 || id > BulletConfig.configs.size()) {
            return null;
        }
        return BulletConfig.configs.get(id);
    }

    @Override
    public void func_70071_h_() {
        if (this.config == null) {
            this.config = this.getBulletConfig();
        }
        if (this.config == null) {
            this.func_70106_y();
            return;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        super.func_70071_h_();
        double dX = this.field_70165_t - this.field_70169_q;
        double dY = this.field_70163_u - this.field_70167_r;
        double dZ = this.field_70161_v - this.field_70166_s;
        if (!this.inGround && this.lockonTarget != null && !this.lockonTarget.field_70128_L) {
            Vec3NT motion = new Vec3NT(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            double vel = motion.func_72433_c();
            Vec3NT delta = new Vec3NT(this.lockonTarget.field_70165_t - this.field_70165_t, this.lockonTarget.field_70163_u + (double)this.lockonTarget.field_70131_O / 2.0 - this.field_70163_u, this.lockonTarget.field_70161_v - this.field_70161_v);
            float turn = Math.min(0.005f * (float)this.field_70173_aa, 1.0f);
            Vec3NT newVec = new Vec3NT(BobMathUtil.interp(motion.field_72450_a, delta.field_72450_a, turn), BobMathUtil.interp(motion.field_72448_b, delta.field_72448_b, turn), BobMathUtil.interp(motion.field_72449_c, delta.field_72449_c, turn)).normalizeSelf().multiply(vel);
            this.field_70159_w = newVec.field_72450_a;
            this.field_70181_x = newVec.field_72448_b;
            this.field_70179_y = newVec.field_72449_c;
            EntityTrackerEntry entry = TrackerUtil.getTrackerEntry((WorldServer)this.field_70170_p, this.func_145782_y());
            entry.field_73127_g = MathHelper.func_76141_d((float)(this.field_70177_z * 256.0f / 360.0f)) + 10;
        }
        this.prevVelocity = this.velocity;
        this.velocity = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
        if (!(this.config == XFactoryTool.ct_hook && this.field_70170_p.field_72995_K || this.inGround || this.field_70122_E || !(this.velocity > 0.0))) {
            float hyp = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ));
            this.field_70177_z = (float)(Math.atan2(dX, dZ) * 180.0 / Math.PI);
            this.field_70125_A = (float)(Math.atan2(dY, hyp) * 180.0 / Math.PI);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa > this.config.expires) {
            this.func_70106_y();
        }
        if (this.config.onUpdate != null) {
            this.config.onUpdate.accept(this);
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_70170_p instanceof WorldServer) {
            TrackerUtil.sendTeleport((World)((WorldServer)this.field_70170_p), this);
        }
    }

    @Override
    protected void onImpact(MovingObjectPosition mop) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.config.onImpact != null) {
                this.config.onImpact.accept(this, mop);
            }
            if (this.field_70128_L || this.inGround) {
                return;
            }
            if (this.config.onRicochet != null) {
                this.config.onRicochet.accept(this, mop);
            }
            if (this.config.onEntityHit != null) {
                this.config.onEntityHit.accept(this, mop);
            }
        }
    }

    @Override
    protected double headingForceMult() {
        return 1.0;
    }

    @Override
    public double getGravityVelocity() {
        return this.config.gravity;
    }

    @Override
    protected double motionMult() {
        return (double)this.config.velocity + this.accel;
    }

    @Override
    protected float getAirDrag() {
        return 1.0f;
    }

    @Override
    protected float getWaterDrag() {
        return 1.0f;
    }

    @Override
    public boolean doesImpactEntities() {
        return this.config.impactsEntities;
    }

    @Override
    public boolean doesPenetrate() {
        return this.config.doesPenetrate;
    }

    @Override
    public boolean isSpectral() {
        return this.config.isSpectral;
    }

    @Override
    public int selfDamageDelay() {
        return this.config.selfDamageDelay;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeInt(this.thrower != null ? this.thrower.func_145782_y() : -1);
    }

    public void readSpawnData(ByteBuf buf) {
        Entity e = this.field_70170_p.func_73045_a(buf.readInt());
        if (e instanceof EntityLivingBase) {
            this.thrower = (EntityLivingBase)e;
        }
    }
}

