/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.orbit;

import api.hbm.tile.IPropulsion;
import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.BlockOrbitalStation;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.SolarSystem;
import com.hbm.dim.SolarSystemWorldSavedData;
import com.hbm.handler.ThreeInts;
import com.hbm.tileentity.machine.TileEntityOrbitalStation;
import com.hbm.util.BufferUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class OrbitalStation {
    public String name = "";
    public CelestialBody orbiting;
    public CelestialBody target;
    public StationState state = StationState.ORBIT;
    public int stateTimer;
    public int maxStateTimer = 100;
    public boolean hasStation = false;
    public int dX;
    public int dZ;
    public boolean hasEngines = true;
    public List<ThreeInts> errorsAt = new ArrayList<ThreeInts>();
    public int errorTimer;
    public float gravityMultiplier = 1.0f;
    private TileEntityOrbitalStation mainPort;
    private HashMap<ThreeInts, TileEntityOrbitalStation> ports = new HashMap();
    private int portIndex = 0;
    private HashSet<IPropulsion> engines = new HashSet();
    public static OrbitalStation clientStation = new OrbitalStation(CelestialBody.getBody(0));
    public static final int STATION_SIZE = 1024;
    public static final int BUFFER_SIZE = 256;
    public static final int WARNING_SIZE = 32;
    private static final ForgeDirection[] horDir = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};

    public OrbitalStation(CelestialBody orbiting) {
        this.orbiting = orbiting;
        this.target = orbiting;
    }

    public OrbitalStation(CelestialBody orbiting, int x, int z) {
        this(orbiting);
        this.dX = x;
        this.dZ = z;
    }

    public void travelTo(World world, CelestialBody target) {
        if (this.state != StationState.ORBIT) {
            return;
        }
        if (!this.canTravel(this.orbiting, target)) {
            return;
        }
        this.setState(StationState.LEAVING, this.getLeaveTime());
        this.target = target;
    }

    public void update(World world) {
        if (!world.field_72995_K) {
            if (this.state == StationState.LEAVING) {
                if (this.stateTimer > this.maxStateTimer) {
                    this.setState(StationState.TRANSFER, this.getTransferTime());
                }
            } else if (this.state == StationState.TRANSFER) {
                if (this.stateTimer > this.maxStateTimer) {
                    this.setState(StationState.ARRIVING, this.getArriveTime());
                    this.orbiting = this.target;
                }
            } else if (this.state == StationState.ARRIVING && this.stateTimer > this.maxStateTimer) {
                this.setState(StationState.ORBIT, 0);
            }
            SolarSystemWorldSavedData.get(world).func_76185_a();
            this.hasEngines = this.engines.size() > 0;
            --this.errorTimer;
            if (this.errorTimer <= 0) {
                this.errorsAt = new ArrayList<ThreeInts>();
                this.errorTimer = 0;
            }
        }
        ++this.stateTimer;
    }

    private boolean canTravel(CelestialBody from, CelestialBody to) {
        if (this.engines.size() == 0) {
            return false;
        }
        double deltaV = SolarSystem.getDeltaVBetween(from, to);
        int shipMass = 200000;
        float totalThrust = this.getTotalThrust();
        boolean canTravel = true;
        this.errorsAt = new ArrayList<ThreeInts>();
        for (IPropulsion engine : this.engines) {
            float massPortion;
            if (engine.canPerformBurn(Math.round((float)shipMass * (massPortion = engine.getThrust() / totalThrust)), deltaV)) continue;
            TileEntity te = engine.getTileEntity();
            canTravel = false;
            this.errorsAt.add(new ThreeInts(te.field_145851_c, te.field_145848_d, te.field_145849_e));
            this.errorTimer = 100;
        }
        return canTravel;
    }

    private float getTotalThrust() {
        float thrust = 0.0f;
        for (IPropulsion engine : this.engines) {
            thrust += engine.getThrust();
        }
        return thrust;
    }

    private int getLeaveTime() {
        int leaveTime = 20;
        for (IPropulsion engine : this.engines) {
            int time = engine.startBurn();
            if (time <= leaveTime) continue;
            leaveTime = time;
        }
        return leaveTime;
    }

    private int getArriveTime() {
        int arriveTime = 20;
        for (IPropulsion engine : this.engines) {
            int time = engine.endBurn();
            if (time <= arriveTime) continue;
            arriveTime = time;
        }
        return arriveTime;
    }

    private int getTransferTime() {
        if (this.mainPort == null) {
            return -1;
        }
        int size = this.calculateSize();
        double distance = SolarSystem.calculateDistanceBetweenTwoBodies(this.mainPort.func_145831_w(), this.orbiting, this.target);
        float thrust = this.getTotalThrust();
        return (int)(Math.log(1.0 + distance * (double)size / (double)thrust * 100.0) * 150.0);
    }

    private void setState(StationState state, int timeUntilNext) {
        this.state = state;
        this.stateTimer = 0;
        this.maxStateTimer = timeUntilNext;
    }

    public static void addPropulsion(IPropulsion propulsion) {
        TileEntity te = propulsion.getTileEntity();
        OrbitalStation station = OrbitalStation.getStationFromPosition(te.field_145851_c, te.field_145849_e);
        station.engines.add(propulsion);
    }

    public static void removePropulsion(IPropulsion propulsion) {
        TileEntity te = propulsion.getTileEntity();
        OrbitalStation station = OrbitalStation.getStationFromPosition(te.field_145851_c, te.field_145849_e);
        station.engines.remove(propulsion);
    }

    public void addPort(TileEntityOrbitalStation port) {
        this.ports.put(new ThreeInts(port.field_145851_c, port.field_145848_d, port.field_145849_e), port);
        if (port.func_145838_q() == ModBlocks.orbital_station) {
            this.mainPort = port;
        }
    }

    public void removePort(TileEntityOrbitalStation port) {
        this.ports.remove(new ThreeInts(port.field_145851_c, port.field_145848_d, port.field_145849_e));
    }

    public TileEntityOrbitalStation getPort() {
        if (this.ports.size() == 0) {
            return null;
        }
        int index = 0;
        for (TileEntityOrbitalStation port : this.ports.values()) {
            if (!port.hasDocked && !port.isReserved) {
                this.portIndex = index;
                return port;
            }
            ++index;
        }
        ++this.portIndex;
        if (this.portIndex >= this.ports.size()) {
            this.portIndex = 0;
        }
        return this.ports.values().toArray(new TileEntityOrbitalStation[this.ports.size()])[this.portIndex];
    }

    public static TileEntityOrbitalStation getPort(int x, int z) {
        return OrbitalStation.getStationFromPosition(x, z).getPort();
    }

    public int calculateSize() {
        int maxZ;
        int maxX;
        if (this.mainPort == null) {
            return 0;
        }
        World world = this.mainPort.func_145831_w();
        int minX = maxX = this.mainPort.field_145851_c;
        int minZ = maxZ = this.mainPort.field_145849_e;
        Stack<ThreeInts> stack = new Stack<ThreeInts>();
        stack.push(new ThreeInts(this.mainPort.field_145851_c, this.mainPort.field_145848_d, this.mainPort.field_145849_e));
        HashSet<ThreeInts> visited = new HashSet<ThreeInts>();
        while (!stack.isEmpty()) {
            ThreeInts pos = (ThreeInts)stack.pop();
            visited.add(pos);
            if (pos.x < minX) {
                minX = pos.x;
            }
            if (pos.x > maxX) {
                maxX = pos.x;
            }
            if (pos.z < minZ) {
                minZ = pos.z;
            }
            if (pos.z > maxZ) {
                maxZ = pos.z;
            }
            for (ForgeDirection dir : horDir) {
                ThreeInts nextPos = pos.getPositionAtOffset(dir);
                if (visited.contains(nextPos) || !this.isInStation(world, nextPos)) continue;
                stack.push(nextPos);
            }
        }
        return (maxX - minX + 1) * (maxZ - minZ + 1);
    }

    private boolean isInStation(World world, ThreeInts pos) {
        if (world.func_72976_f(pos.x, pos.z) > 1) {
            return true;
        }
        return Math.abs(pos.x - this.mainPort.field_145851_c) < 5 && Math.abs(pos.z - this.mainPort.field_145849_e) < 5;
    }

    public double getUnscaledProgress(float partialTicks) {
        if (this.state == StationState.ORBIT) {
            return 0.0;
        }
        return MathHelper.func_151237_a((double)(((double)this.stateTimer + (double)partialTicks) / (double)this.maxStateTimer), (double)0.0, (double)1.0);
    }

    public double getTransferProgress(float partialTicks) {
        if (this.state != StationState.TRANSFER) {
            return 0.0;
        }
        return this.easeInOutCirc(this.getUnscaledProgress(partialTicks));
    }

    private double easeInOutCirc(double t) {
        return t < 0.5 ? (1.0 - Math.sqrt(1.0 - Math.pow(2.0 * t, 3.0))) / 2.0 : (Math.sqrt(1.0 - Math.pow(-2.0 * t + 2.0, 3.0)) + 1.0) / 2.0;
    }

    public static OrbitalStation getStationFromPosition(int x, int z) {
        SolarSystemWorldSavedData data = SolarSystemWorldSavedData.get();
        OrbitalStation station = data.getStationFromPosition(x, z);
        if (station == null) {
            station = data.addStation(MathHelper.func_76141_d((float)((float)x / 1024.0f)), MathHelper.func_76141_d((float)((float)z / 1024.0f)), CelestialBody.getBody(0));
        }
        return station;
    }

    public static OrbitalStation getStation(int x, int z) {
        return OrbitalStation.getStationFromPosition(x * 1024, z * 1024);
    }

    public void serialize(ByteBuf buf) {
        buf.writeInt(this.orbiting.dimensionId);
        buf.writeInt(this.target.dimensionId);
        buf.writeInt(this.state.ordinal());
        buf.writeInt(this.stateTimer);
        buf.writeInt(this.maxStateTimer);
        buf.writeBoolean(this.hasEngines);
        buf.writeFloat(this.gravityMultiplier);
        BufferUtil.writeString(buf, this.name);
        buf.writeInt(this.errorsAt.size());
        for (ThreeInts error : this.errorsAt) {
            buf.writeInt(error.x);
            buf.writeInt(error.y);
            buf.writeInt(error.z);
        }
    }

    public static OrbitalStation deserialize(ByteBuf buf) {
        OrbitalStation station = new OrbitalStation(CelestialBody.getBody(buf.readInt()));
        station.target = CelestialBody.getBody(buf.readInt());
        station.state = StationState.values()[buf.readInt()];
        station.stateTimer = buf.readInt();
        station.maxStateTimer = buf.readInt();
        station.hasEngines = buf.readBoolean();
        station.gravityMultiplier = buf.readFloat();
        station.name = BufferUtil.readString(buf);
        station.errorsAt = new ArrayList<ThreeInts>();
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            int x = buf.readInt();
            int y = buf.readInt();
            int z = buf.readInt();
            station.errorsAt.add(new ThreeInts(x, y, z));
        }
        return station;
    }

    public static void spawn(World world, int x, int z) {
        int y = 127;
        if (world.func_147439_a(x, y, z) == ModBlocks.orbital_station) {
            return;
        }
        BlockOrbitalStation block = (BlockOrbitalStation)ModBlocks.orbital_station;
        BlockDummyable.safeRem = true;
        world.func_147465_d(x, y, z, (Block)block, 12, 3);
        block.fillSpace(world, x, y, z, ForgeDirection.NORTH, 0);
        BlockDummyable.safeRem = false;
    }

    public static void addStation(int x, int z, CelestialBody body) {
        SolarSystemWorldSavedData data = SolarSystemWorldSavedData.get();
        OrbitalStation station = data.getStationFromPosition(x * 1024, z * 1024);
        if (station == null) {
            station = data.addStation(x, z, body);
        }
        station.orbiting = station.target = body;
        station.hasStation = true;
    }

    public static enum StationState {
        ORBIT,
        LEAVING,
        TRANSFER,
        ARRIVING;

    }
}

