/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.eve;

import com.hbm.blocks.ModBlocks;
import com.hbm.dim.WorldChunkManagerCelestial;
import com.hbm.dim.WorldProviderCelestial;
import com.hbm.dim.eve.ChunkProviderEve;
import com.hbm.dim.eve.genlayer.GenLayerEveBiomes;
import com.hbm.dim.eve.genlayer.GenLayerEveRiverMix;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.main.MainRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerRiver;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;

public class WorldProviderEve
extends WorldProviderCelestial {
    private int chargetime;
    private float flashd;

    @Override
    public void func_76572_b() {
        this.field_76578_c = new WorldChunkManagerCelestial(WorldProviderEve.createBiomeGenerators(this.field_76579_a.func_72905_C()));
    }

    public String func_80007_l() {
        return "Eve";
    }

    public IChunkProvider func_76555_c() {
        return new ChunkProviderEve(this.field_76579_a, this.getSeed(), false);
    }

    @Override
    public void updateWeather() {
        super.updateWeather();
        if (!this.field_76579_a.field_72995_K) {
            if (this.chargetime <= 0 || this.chargetime <= 800) {
                ++this.chargetime;
            } else if (this.chargetime >= 800) {
                this.chargetime = 0;
            }
        } else if (this.chargetime >= 800) {
            this.flashd = 0.0f;
        } else if (this.chargetime >= 100) {
            if (this.flashd <= 1.0f) {
                MainRegistry.proxy.me().func_85030_a("hbm:misc.rumble", 10.0f, 1.0f);
            }
            this.flashd += 0.1f;
            this.flashd = Math.min(100.0f, this.flashd + 0.1f * (100.0f - this.flashd) * 0.15f);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74768_a("chargetime", this.chargetime);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.chargetime = nbt.func_74762_e("chargetime");
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.chargetime);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.chargetime = buf.readInt();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vec3 getSkyColor(Entity camera, float partialTicks) {
        Vec3 ohshit = super.getSkyColor(camera, partialTicks);
        float alpha = this.flashd <= 0.0f ? 0.0f : 1.0f - Math.min(1.0f, this.flashd / 100.0f);
        return Vec3.func_72443_a((double)(ohshit.field_72450_a + (double)alpha), (double)(ohshit.field_72448_b + (double)alpha), (double)(ohshit.field_72449_c + (double)alpha));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float par1) {
        float imsuper = super.getSunBrightness(par1);
        float alpha = this.flashd <= 0.0f ? 0.0f : 1.0f - Math.min(1.0f, this.flashd / 100.0f);
        return imsuper + alpha * 0.7f;
    }

    @Override
    public Block getStone() {
        return ModBlocks.eve_rock;
    }

    @Override
    public FluidStack getBedrockAcid() {
        return new FluidStack(Fluids.KMnO4, 500);
    }

    private static WorldChunkManagerCelestial.BiomeGenLayers createBiomeGenerators(long seed) {
        GenLayerEveBiomes genlayerBiomes = new GenLayerEveBiomes(seed);
        genlayerBiomes = new GenLayerZoom(1000L, (GenLayer)genlayerBiomes);
        genlayerBiomes = new GenLayerZoom(1001L, (GenLayer)genlayerBiomes);
        genlayerBiomes = new GenLayerZoom(1002L, (GenLayer)genlayerBiomes);
        genlayerBiomes = new GenLayerZoom(1003L, (GenLayer)genlayerBiomes);
        genlayerBiomes = new GenLayerZoom(1004L, (GenLayer)genlayerBiomes);
        genlayerBiomes = new GenLayerZoom(1005L, (GenLayer)genlayerBiomes);
        GenLayerZoom genlayerRiverZoom = new GenLayerZoom(1000L, (GenLayer)genlayerBiomes);
        GenLayerRiver genlayerRiver = new GenLayerRiver(1001L, (GenLayer)genlayerRiverZoom);
        GenLayerSmooth genlayersmooth = new GenLayerSmooth(1000L, (GenLayer)genlayerRiver);
        GenLayerSmooth genlayersmooth1 = new GenLayerSmooth(1000L, (GenLayer)genlayerBiomes);
        GenLayerEveRiverMix genlayerrivermix = new GenLayerEveRiverMix(100L, (GenLayer)genlayersmooth1, (GenLayer)genlayersmooth);
        GenLayerVoronoiZoom genlayervoronoizoom = new GenLayerVoronoiZoom(10L, (GenLayer)genlayerrivermix);
        return new WorldChunkManagerCelestial.BiomeGenLayers((GenLayer)genlayerrivermix, (GenLayer)genlayervoronoizoom, seed);
    }
}

