/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.dres;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockOre;
import com.hbm.config.GeneralConfig;
import com.hbm.config.SpaceConfig;
import com.hbm.config.WorldConfig;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.SolarSystem;
import com.hbm.dim.WorldProviderCelestial;
import com.hbm.dim.dres.biome.BiomeGenBaseDres;
import com.hbm.main.StructureManager;
import com.hbm.world.gen.component.Component;
import com.hbm.world.gen.nbt.JigsawPiece;
import com.hbm.world.gen.nbt.JigsawPool;
import com.hbm.world.gen.nbt.NBTStructure;
import com.hbm.world.gen.nbt.SpawnCondition;
import com.hbm.world.generator.DungeonToolbox;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.structure.StructureComponent;

public class WorldGeneratorDres
implements IWorldGenerator {
    public WorldGeneratorDres() {
        final HashMap<Block, StructureComponent.BlockSelector> tiles = new HashMap<Block, StructureComponent.BlockSelector>(){
            {
                this.put(ModBlocks.tile_lab, new Component.LabTiles(0.2f));
            }
        };
        NBTStructure.registerStructure(SpaceConfig.dresDimension, new SpawnCondition("dres_rbmk"){
            {
                super(name);
                this.spawnWeight = 8;
                this.minHeight = 40;
                this.maxHeight = 40;
                this.sizeLimit = 128;
                this.rangeLimit = 64;
                this.canSpawn = biome -> biome == BiomeGenBaseDres.dresPlains;
                this.startPool = "start";
                this.pools = new HashMap<String, JigsawPool>(){
                    {
                        this.put("start", new JigsawPool(){
                            {
                                this.add(new JigsawPiece("dres_core", StructureManager.dres_core){
                                    {
                                        this.blockTable = tiles;
                                    }
                                }, 1);
                            }
                        });
                        this.put("default", new JigsawPool(){
                            {
                                this.add(new JigsawPiece("dres_t", StructureManager.dres_t){
                                    {
                                        this.blockTable = tiles;
                                    }
                                }, 1);
                                this.add(new JigsawPiece("dres_airlock", StructureManager.dres_airlock){
                                    {
                                        this.blockTable = tiles;
                                    }
                                }, 1);
                                this.add(new JigsawPiece("dres_dome", StructureManager.dres_dome){
                                    {
                                        this.blockTable = tiles;
                                    }
                                }, 1);
                                this.add(new JigsawPiece("dres_pool", StructureManager.dres_pool){
                                    {
                                        this.blockTable = tiles;
                                    }
                                }, 1);
                                this.fallback = "inback";
                            }
                        });
                        this.put("outside", new JigsawPool(){
                            {
                                this.add(new JigsawPiece("dres_balcony", StructureManager.dres_balcony){
                                    {
                                        this.blockTable = tiles;
                                    }
                                }, 1);
                                this.add(new JigsawPiece("dres_pad", StructureManager.dres_pad){
                                    {
                                        this.blockTable = tiles;
                                    }
                                }, 1);
                                this.fallback = "outback";
                            }
                        });
                        this.put("reactor", new JigsawPool(){
                            {
                                this.add(new JigsawPiece("dres_hall_starbmk", StructureManager.dres_hall_starbmk){
                                    {
                                        this.blockTable = tiles;
                                    }
                                }, 5);
                                this.add(new JigsawPiece("dres_hall_breeder", StructureManager.dres_hall_breeder){
                                    {
                                        this.blockTable = tiles;
                                    }
                                }, 1);
                            }
                        });
                        this.put("inback", new JigsawPool(){
                            {
                                this.add(new JigsawPiece("dres_incap", StructureManager.dres_incap){
                                    {
                                        this.blockTable = tiles;
                                    }
                                }, 1);
                            }
                        });
                        this.put("outback", new JigsawPool(){
                            {
                                this.add(new JigsawPiece("dres_outcap", StructureManager.dres_outcap){
                                    {
                                        this.blockTable = tiles;
                                    }
                                }, 1);
                            }
                        });
                    }
                };
            }
        });
        NBTStructure.registerNullWeight(SpaceConfig.dresDimension, 16);
        BlockOre.addValidBody(ModBlocks.ore_shale, SolarSystem.Body.DRES);
        BlockOre.addValidBody(ModBlocks.ore_lanthanium, SolarSystem.Body.DRES);
        BlockOre.addValidBody(ModBlocks.ore_niobium, SolarSystem.Body.DRES);
        BlockOre.addValidBody(ModBlocks.ore_coltan, SolarSystem.Body.DRES);
        BlockOre.addValidBody(ModBlocks.ore_lanthanium, SolarSystem.Body.DRES);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g == SpaceConfig.dresDimension) {
            this.generateDres(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    private void generateDres(World world, Random rand, int i, int j) {
        int meta = CelestialBody.getMeta(world);
        Block stone = ((WorldProviderCelestial)world.field_73011_w).getStone();
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.cobaltSpawn, 4, 3, 22, ModBlocks.ore_cobalt, meta, stone);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.copperSpawn, 9, 4, 27, ModBlocks.ore_iron, meta, stone);
        DungeonToolbox.generateOre(world, rand, i, j, 12, 8, 1, 33, ModBlocks.ore_niobium, meta, stone);
        DungeonToolbox.generateOre(world, rand, i, j, GeneralConfig.coltanRate, 4, 15, 40, ModBlocks.ore_coltan, meta, stone);
        DungeonToolbox.generateOre(world, rand, i, j, 1, 6, 4, 64, ModBlocks.ore_lanthanium, meta, stone);
        DungeonToolbox.generateOre(world, rand, i, j, 1, 12, 8, 32, ModBlocks.ore_shale, meta, stone);
    }
}

