/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.commands;

import com.hbm.config.SpaceConfig;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.CelestialTeleporter;
import com.hbm.dim.SolarSystem;
import com.hbm.dim.SolarSystemWorldSavedData;
import com.hbm.dim.orbit.OrbitalStation;
import com.hbm.items.ItemVOTVdrive;
import com.hbm.items.ModItems;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class CommandStations
extends CommandBase {
    public String func_71517_b() {
        return "ntmstations";
    }

    public String func_71518_a(ICommandSender sender) {
        return String.format(Locale.US, "%s/%s launch %s- Spawns a station for the held drive.\n%s/%s tp %s- Teleport to held drive station.\n%s/%s list %s- Lists all active stations.\n%s/%s fetch <id|name> %s- Creates a drive programmed with a specific station ID or name.", EnumChatFormatting.GREEN, this.func_71517_b(), EnumChatFormatting.LIGHT_PURPLE, EnumChatFormatting.GREEN, this.func_71517_b(), EnumChatFormatting.LIGHT_PURPLE, EnumChatFormatting.GREEN, this.func_71517_b(), EnumChatFormatting.LIGHT_PURPLE, EnumChatFormatting.GREEN, this.func_71517_b(), EnumChatFormatting.LIGHT_PURPLE);
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (!(sender instanceof EntityPlayer)) {
            CommandStations.showMessage(sender, "commands.satellite.should_be_run_as_player", true);
            return;
        }
        if (args.length == 0) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP player = CommandStations.func_71521_c((ICommandSender)sender);
        SolarSystemWorldSavedData data = SolarSystemWorldSavedData.get(player.field_70170_p);
        switch (args[0]) {
            case "launch": {
                ItemVOTVdrive.Destination dest = CommandStations.getStationDestination(sender, player.func_70694_bm());
                if (dest == null) {
                    return;
                }
                OrbitalStation.addStation(dest.x, dest.z, CelestialBody.getBody(player.field_70170_p));
                CommandStations.showMessage(sender, "commands.station.launched", false);
                break;
            }
            case "tp": {
                ItemVOTVdrive.Destination destination = CommandStations.getStationDestination(sender, player.func_70694_bm());
                if (destination == null) {
                    return;
                }
                int dimensionId = destination.body.getDimensionId();
                int x = destination.x;
                int z = destination.z;
                if (dimensionId == SpaceConfig.orbitDimension) {
                    x = x * 1024 + 512;
                    z = z * 1024 + 512;
                }
                player.func_70078_a(null);
                if (player.field_71093_bK != dimensionId) {
                    if (dimensionId == SpaceConfig.orbitDimension) {
                        CelestialTeleporter.teleport((EntityPlayer)player, dimensionId, (double)x + 0.5, 130.0, (double)z + 0.5, false);
                    } else {
                        CelestialTeleporter.teleport((EntityPlayer)player, dimensionId, (double)x + 0.5, 300.0, (double)z + 0.5, true);
                    }
                } else if (dimensionId == SpaceConfig.orbitDimension) {
                    player.func_70634_a((double)x + 0.5, 130.0, (double)z + 0.5);
                } else {
                    int y = player.field_70170_p.func_72976_f(x, z);
                    player.func_70634_a((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
                }
                if (dimensionId == SpaceConfig.orbitDimension) {
                    WorldServer targetWorld = DimensionManager.getWorld((int)SpaceConfig.orbitDimension);
                    OrbitalStation.spawn((World)targetWorld, x, z);
                }
                CommandStations.showMessage(sender, "commands.station.teleported", false);
                break;
            }
            case "list": {
                boolean hasAnyStations = false;
                for (OrbitalStation station : data.getStations().values()) {
                    if (!station.hasStation) continue;
                    String messageText = "0x" + Integer.toHexString(new ChunkCoordIntPair(station.dX, station.dZ).hashCode()).toUpperCase();
                    if (station.name != "") {
                        messageText = messageText + " - " + station.name;
                    }
                    CommandStations.showMessage(sender, messageText, false);
                    hasAnyStations = true;
                }
                if (hasAnyStations) break;
                CommandStations.showMessage(sender, "commands.station.no_stations", true);
                break;
            }
            case "fetch": {
                if (args.length < 2 || args[1] == null || args[1] == "") {
                    CommandStations.showMessage(sender, "commands.station.invalid_station", true);
                    break;
                }
                boolean hasMatch = false;
                String toMatch = args[1];
                for (int i = 2; i < args.length; ++i) {
                    toMatch = toMatch + " " + args[i];
                }
                toMatch = toMatch.trim();
                for (OrbitalStation station : data.getStations().values()) {
                    String stationId = "0x" + Integer.toHexString(new ChunkCoordIntPair(station.dX, station.dZ).hashCode()).toUpperCase();
                    if (!station.name.trim().equalsIgnoreCase(toMatch) && !stationId.equalsIgnoreCase(toMatch)) continue;
                    ItemStack drive = new ItemStack((Item)ModItems.full_drive, 1, SolarSystem.Body.ORBIT.ordinal());
                    drive.field_77990_d = new NBTTagCompound();
                    drive.field_77990_d.func_74768_a("x", station.dX);
                    drive.field_77990_d.func_74768_a("z", station.dZ);
                    drive.field_77990_d.func_74757_a("Processed", true);
                    drive.field_77990_d.func_74778_a("stationName", station.name);
                    player.field_71071_by.func_70441_a(drive);
                    CommandStations.showMessage(sender, "commands.station.drive_created", false);
                    hasMatch = true;
                    break;
                }
                if (hasMatch) break;
                CommandStations.showMessage(sender, "commands.station.no_match", true);
            }
        }
    }

    private static void showMessage(ICommandSender sender, String error, boolean isError) {
        ChatComponentTranslation message = new ChatComponentTranslation(error, new Object[0]);
        message.func_150256_b().func_150238_a(isError ? EnumChatFormatting.RED : EnumChatFormatting.GREEN);
        sender.func_145747_a((IChatComponent)message);
    }

    private static ItemVOTVdrive.Destination getStationDestination(ICommandSender sender, ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemVOTVdrive)) {
            CommandStations.showMessage(sender, "commands.station.invalid_drive", true);
            return null;
        }
        ItemVOTVdrive.Destination destination = ItemVOTVdrive.getDestination(stack);
        return destination;
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (!(sender instanceof EntityPlayer)) {
            return Collections.emptyList();
        }
        if (args.length < 1) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return CommandStations.func_71530_a((String[])args, (String[])new String[]{"launch", "tp", "list", "fetch"});
        }
        return Collections.emptyList();
    }
}

