/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.trait.CBT_Atmosphere;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.TileEntityTowerSmall;
import com.hbm.util.BobMathUtil;
import com.hbm.util.i18n.I18nUtil;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineTowerSmall
extends BlockDummyable
implements ILookOverlay {
    public MachineTowerSmall(Material mat) {
        super(mat);
    }

    public TileEntity func_149915_a(World p_149915_1_, int meta) {
        if (meta >= 12) {
            return new TileEntityTowerSmall();
        }
        if (meta >= 8) {
            return new TileEntityProxyCombo(false, false, true);
        }
        return null;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{18, 0, 2, 2, 2, 2};
    }

    @Override
    public int getOffset() {
        return 2;
    }

    @Override
    public void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        super.fillSpace(world, x, y, z, dir, o);
        x += dir.offsetX * o;
        z += dir.offsetZ * o;
        for (int i = 2; i <= 6; ++i) {
            ForgeDirection dr2 = ForgeDirection.getOrientation((int)i);
            this.makeExtra(world, x + dr2.offsetX * 2, y, z + dr2.offsetZ * 2);
        }
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityTowerSmall)) {
            return;
        }
        TileEntityTowerSmall tower = (TileEntityTowerSmall)te;
        ArrayList<String> text = new ArrayList<String>();
        if (!tower.vacuumOptimised) {
            CBT_Atmosphere atmosphere = CelestialBody.getTrait(world, CBT_Atmosphere.class);
            if (CelestialBody.inOrbit(world) || atmosphere == null || atmosphere.getPressure() < 0.01) {
                text.add("&[" + (BobMathUtil.getBlink() ? 0xFF0000 : 0xFFFF00) + "&]! ! ! " + I18nUtil.resolveKey("atmosphere.noVacuum", new Object[0]) + " ! ! !");
            }
        }
        for (int i = 0; i < tower.tanks.length; ++i) {
            text.add((i < 1 ? EnumChatFormatting.GREEN + "-> " : EnumChatFormatting.RED + "<- ") + EnumChatFormatting.RESET + tower.tanks[i].getTankType().getLocalizedName() + ": " + tower.tanks[i].getFill() + "/" + tower.tanks[i].getMaxFill() + "mB");
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }
}

