/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.handler.MultiblockHandlerXR;
import com.hbm.items.ModItems;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.TileEntityDysonReceiver;
import com.hbm.util.BobMathUtil;
import com.hbm.util.i18n.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineDysonReceiver
extends BlockDummyable
implements ILookOverlay,
ITooltipProvider {
    public MachineDysonReceiver(Material mat) {
        super(mat);
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 12) {
            return new TileEntityDysonReceiver();
        }
        if (meta >= 6) {
            return new TileEntityProxyCombo(false, false, false);
        }
        return null;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            int[] pos = this.findCore(world, x, y, z);
            if (pos == null) {
                return false;
            }
            TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
            if (!(te instanceof TileEntityDysonReceiver)) {
                return false;
            }
            TileEntityDysonReceiver receiver = (TileEntityDysonReceiver)te;
            ItemStack heldStack = player.func_70694_bm();
            if (heldStack != null && heldStack.func_77973_b() == ModItems.sat_chip) {
                if (receiver.slots[0] != null) {
                    return false;
                }
                receiver.slots[0] = heldStack.func_77946_l();
                receiver.markChanged();
                heldStack.field_77994_a = 0;
                world.func_72908_a((double)x, (double)y, (double)z, "hbm:item.upgradePlug", 1.0f, 1.0f);
            } else if (heldStack == null && receiver.slots[0] != null && player.field_71071_by.func_70441_a(receiver.slots[0].func_77946_l())) {
                receiver.slots[0] = null;
                receiver.markChanged();
                world.func_72908_a((double)x, (double)y, (double)z, "hbm:item.upgradePlug", 1.0f, 1.0f);
            }
        }
        return true;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{2, 0, 4, 2, 2, 2};
    }

    @Override
    public int getOffset() {
        return 2;
    }

    @Override
    public void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        super.fillSpace(world, x, y, z, dir, o);
        MultiblockHandlerXR.fillSpace(world, x += dir.offsetX * o, y, z += dir.offsetZ * o, new int[]{1, 0, 8, -4, 1, 1}, (Block)this, dir);
        MultiblockHandlerXR.fillSpace(world, x, y, z, new int[]{4, 0, 4, 0, 1, 1}, (Block)this, dir);
        MultiblockHandlerXR.fillSpace(world, x, y + 10, z, new int[]{1, 0, 6, 6, 6, 6}, (Block)this, dir);
        MultiblockHandlerXR.fillSpace(world, x, y, z, new int[]{17, 0, 1, 1, 1, 1}, (Block)this, dir);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityDysonReceiver)) {
            return;
        }
        TileEntityDysonReceiver receiver = (TileEntityDysonReceiver)te;
        long energyOutput = 0L;
        if (receiver.isReceiving) {
            energyOutput = TileEntityDysonReceiver.getEnergyOutput(receiver.swarmCount) / (long)receiver.swarmConsumers * 20L;
        }
        ArrayList<String> text = new ArrayList<String>();
        if (receiver.swarmId > 0) {
            text.add("ID: " + receiver.swarmId);
            text.add("Swarm: " + receiver.swarmCount + " members");
            text.add("Consumers: " + receiver.swarmConsumers + " consumers");
            text.add("Power: " + BobMathUtil.getShortNumber(energyOutput) + "HE/s");
        } else {
            text.add("No Satellite ID-Chip installed!");
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        this.addStandardInfo(stack, player, list, ext);
    }
}

