/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import api.hbm.block.IToolable;
import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.tileentity.IPersistentNBT;
import com.hbm.tileentity.IRepairable;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.TileEntityCondenserPowered;
import com.hbm.util.BobMathUtil;
import com.hbm.util.i18n.I18nUtil;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineCondenserPowered
extends BlockDummyable
implements ILookOverlay,
IToolable {
    public MachineCondenserPowered(Material mat) {
        super(mat);
    }

    public TileEntity func_149915_a(World p_149915_1_, int meta) {
        if (meta >= 12) {
            return new TileEntityCondenserPowered();
        }
        if (meta >= 6) {
            return new TileEntityProxyCombo().power().fluid();
        }
        return null;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{2, 0, 1, 1, 3, 3};
    }

    @Override
    public int getOffset() {
        return 1;
    }

    @Override
    public void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        super.fillSpace(world, x, y, z, dir, o);
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        this.makeExtra(world, (x += dir.offsetX * o) + rot.offsetX * 3, y + 1, (z += dir.offsetZ * o) + rot.offsetZ * 3);
        this.makeExtra(world, x - rot.offsetX * 3, y + 1, z - rot.offsetZ * 3);
        this.makeExtra(world, x + dir.offsetX + rot.offsetX, y + 1, z + dir.offsetZ + rot.offsetZ);
        this.makeExtra(world, x + dir.offsetX - rot.offsetX, y + 1, z + dir.offsetZ - rot.offsetZ);
        this.makeExtra(world, x - dir.offsetX + rot.offsetX, y + 1, z - dir.offsetZ + rot.offsetZ);
        this.makeExtra(world, x - dir.offsetX - rot.offsetX, y + 1, z - dir.offsetZ - rot.offsetZ);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityCondenserPowered)) {
            return;
        }
        TileEntityCondenserPowered tower = (TileEntityCondenserPowered)te;
        if (tower.damaged) {
            IRepairable.addGenericOverlay(event, world, x, y, z, this);
            return;
        }
        ArrayList<String> text = new ArrayList<String>();
        text.add(BobMathUtil.getShortNumber(tower.power) + "HE / " + BobMathUtil.getShortNumber(TileEntityCondenserPowered.maxPower) + "HE");
        for (int i = 0; i < tower.tanks.length; ++i) {
            text.add((i < 1 ? EnumChatFormatting.GREEN + "-> " : EnumChatFormatting.RED + "<- ") + EnumChatFormatting.RESET + tower.tanks[i].getTankType().getLocalizedName() + ": " + String.format(Locale.US, "%,d", tower.tanks[i].getFill()) + "/" + String.format(Locale.US, "%,d", tower.tanks[i].getMaxFill()) + "mB");
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, int side, float fX, float fY, float fZ, IToolable.ToolType tool) {
        if (tool != IToolable.ToolType.TORCH) {
            return false;
        }
        return IRepairable.tryRepairMultiblock(world, x, y, z, this, player);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return IPersistentNBT.getDrops(world, x, y, z, (Block)this);
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity core = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(core instanceof TileEntityCondenserPowered)) {
            return;
        }
        TileEntityCondenserPowered tank = (TileEntityCondenserPowered)core;
        if (tank.lastExplosion == explosion) {
            return;
        }
        tank.lastExplosion = explosion;
        if (!tank.damaged) {
            tank.damaged = true;
            tank.func_70296_d();
        } else {
            world.func_147449_b(pos[0], pos[1], pos[2], Blocks.field_150350_a);
        }
    }
}

