/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.handler.atmosphere.IBlockSealable;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.machine.TileEntityFurnaceBrick;
import com.hbm.util.ItemStackUtil;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class MachineBrickFurnace
extends BlockContainer
implements IBlockSealable {
    private final Random rand = new Random();
    private final boolean isActive;
    private static boolean keepInventory;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconBottom;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFront;

    public MachineBrickFurnace(boolean blockState) {
        super(Material.field_151573_f);
        this.isActive = blockState;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconTop = iconRegister.func_94245_a("hbm:machine_furnace_brick_top");
        this.iconBottom = iconRegister.func_94245_a("hbm:machine_furnace_brick_bottom");
        this.iconFront = iconRegister.func_94245_a("hbm" + (this.isActive ? ":machine_furnace_brick_front_on" : ":machine_furnace_brick_front_off"));
        this.field_149761_L = iconRegister.func_94245_a("hbm:machine_furnace_brick_side");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return metadata == 0 && side == 3 ? this.iconFront : (side == metadata ? this.iconFront : (side == 1 ? this.iconTop : (side == 0 ? this.iconBottom : this.field_149761_L)));
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityFurnaceBrick();
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)ModBlocks.machine_furnace_brick_off);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.setDefaultDirection(world, x, y, z);
    }

    private void setDefaultDirection(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            Block nZ = world.func_147439_a(x, y, z - 1);
            Block pZ = world.func_147439_a(x, y, z + 1);
            Block nX = world.func_147439_a(x - 1, y, z);
            Block pX = world.func_147439_a(x + 1, y, z);
            int meta = 3;
            if (nZ.func_149730_j() && !pZ.func_149730_j()) {
                meta = 3;
            }
            if (pZ.func_149730_j() && !nZ.func_149730_j()) {
                meta = 2;
            }
            if (nX.func_149730_j() && !pX.func_149730_j()) {
                meta = 5;
            }
            if (pX.func_149730_j() && !nX.func_149730_j()) {
                meta = 4;
            }
            world.func_72921_c(x, y, z, meta, 2);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        int i = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (i == 0) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        if (i == 1) {
            world.func_72921_c(x, y, z, 5, 2);
        }
        if (i == 2) {
            world.func_72921_c(x, y, z, 3, 2);
        }
        if (i == 3) {
            world.func_72921_c(x, y, z, 4, 2);
        }
        if (itemStack.func_82837_s()) {
            ((TileEntityFurnaceBrick)world.func_147438_o(x, y, z)).setCustomName(itemStack.func_82833_r());
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            TileEntityFurnaceBrick entity = (TileEntityFurnaceBrick)world.func_147438_o(x, y, z);
            if (entity != null) {
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MainRegistry.instance, (int)0, (World)world, (int)x, (int)y, (int)z);
            }
            return true;
        }
        return false;
    }

    public static void updateBlockState(boolean isProcessing, World world, int x, int y, int z) {
        int i = world.func_72805_g(x, y, z);
        TileEntity entity = world.func_147438_o(x, y, z);
        keepInventory = true;
        if (isProcessing) {
            world.func_147449_b(x, y, z, ModBlocks.machine_furnace_brick_on);
        } else {
            world.func_147449_b(x, y, z, ModBlocks.machine_furnace_brick_off);
        }
        keepInventory = false;
        world.func_72921_c(x, y, z, i, 2);
        if (entity != null) {
            entity.func_145829_t();
            world.func_147455_a(x, y, z, entity);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        if (!keepInventory) {
            ItemStackUtil.spillItems(world, x, y, z, block, this.rand);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (this.isActive) {
            int meta = world.func_72805_g(x, y, z);
            float cX = (float)x + 0.5f;
            float cY = (float)y + rand.nextFloat() * 0.375f;
            float cZ = (float)z + 0.5f;
            float off = 0.52f;
            float var = rand.nextFloat() * 0.6f - 0.3f;
            rand.nextFloat();
            rand.nextFloat();
            if (meta == 4) {
                world.func_72869_a("smoke", (double)(cX - off), (double)cY, (double)(cZ + var), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(cX - off), (double)cY, (double)(cZ + var), 0.0, 0.0, 0.0);
            } else if (meta == 5) {
                world.func_72869_a("smoke", (double)(cX + off), (double)cY, (double)(cZ + var), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(cX + off), (double)cY, (double)(cZ + var), 0.0, 0.0, 0.0);
            } else if (meta == 2) {
                world.func_72869_a("smoke", (double)(cX + var), (double)cY, (double)(cZ - off), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(cX + var), (double)cY, (double)(cZ - off), 0.0, 0.0, 0.0);
            } else if (meta == 3) {
                world.func_72869_a("smoke", (double)(cX + var), (double)cY, (double)(cZ + off), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(cX + var), (double)cY, (double)(cZ + off), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean isSealed(World world, int x, int y, int z) {
        return false;
    }
}

