/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.util.InventoryAdaptor;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.IMEAdaptorIterator;
import appeng.util.inv.ItemSlot;
import appeng.util.item.AEItemStack;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import net.minecraft.item.ItemStack;

public class IMEAdaptor
extends InventoryAdaptor {
    final IMEInventory<IAEItemStack> target;
    final BaseActionSource src;
    int maxSlots = 0;

    public IMEAdaptor(IMEInventory<IAEItemStack> input, BaseActionSource src) {
        this.target = input;
        this.src = src;
    }

    @Override
    public Iterator<ItemSlot> iterator() {
        return new IMEAdaptorIterator(this, this.getList());
    }

    IItemList<IAEItemStack> getList() {
        return this.target.getAvailableItems(AEApi.instance().storage().createItemList());
    }

    @Override
    public ItemStack removeItems(int amount, ItemStack filter, IInventoryDestination destination) {
        return this.doRemoveItems(amount, filter, destination, Actionable.MODULATE);
    }

    public ItemStack doRemoveItems(int how_many, ItemStack Filter, IInventoryDestination destination, Actionable type) {
        IAEItemStack req = null;
        if (Filter == null) {
            IItemList<IAEItemStack> list = this.getList();
            if (!list.isEmpty()) {
                req = list.getFirstItem();
            }
        } else {
            req = AEItemStack.create(Filter);
        }
        IAEItemStack out = null;
        if (req != null) {
            req.setStackSize(how_many);
            out = this.target.extractItems(req, type, this.src);
        }
        if (out != null) {
            return out.getItemStack();
        }
        return null;
    }

    @Override
    public ItemStack simulateRemove(int amount, ItemStack filter, IInventoryDestination destination) {
        return this.doRemoveItems(amount, filter, destination, Actionable.SIMULATE);
    }

    @Override
    public ItemStack removeSimilarItems(int how_many, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        if (filter == null) {
            return this.doRemoveItems(how_many, null, destination, Actionable.MODULATE);
        }
        return this.doRemoveItemsFuzzy(how_many, filter, destination, Actionable.MODULATE, fuzzyMode);
    }

    public ItemStack doRemoveItemsFuzzy(int how_many, ItemStack Filter, IInventoryDestination destination, Actionable type, FuzzyMode fuzzyMode) {
        AEItemStack reqFilter = AEItemStack.create(Filter);
        if (reqFilter == null) {
            return null;
        }
        IAEItemStack out = null;
        for (IAEItemStack req : ImmutableList.copyOf(this.getList().findFuzzy(reqFilter, fuzzyMode))) {
            if (req == null) continue;
            req.setStackSize(how_many);
            out = this.target.extractItems(req, type, this.src);
            if (out == null) continue;
            return out.getItemStack();
        }
        return null;
    }

    @Override
    public ItemStack simulateSimilarRemove(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        if (filter == null) {
            return this.doRemoveItems(amount, null, destination, Actionable.SIMULATE);
        }
        return this.doRemoveItemsFuzzy(amount, filter, destination, Actionable.SIMULATE, fuzzyMode);
    }

    @Override
    public ItemStack addItems(ItemStack toBeAdded) {
        IAEItemStack out;
        AEItemStack in = AEItemStack.create(toBeAdded);
        if (in != null && (out = this.target.injectItems(in, Actionable.MODULATE, this.src)) != null) {
            return out.getItemStack();
        }
        return null;
    }

    @Override
    public ItemStack simulateAdd(ItemStack toBeSimulated) {
        IAEItemStack out;
        AEItemStack in = AEItemStack.create(toBeSimulated);
        if (in != null && (out = this.target.injectItems(in, Actionable.SIMULATE, this.src)) != null) {
            return out.getItemStack();
        }
        return null;
    }

    @Override
    public boolean containsItems() {
        return !this.getList().isEmpty();
    }
}

