/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.datagen;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.common.loot.HexLootHandler;
import at.petrak.hexcasting.forge.loot.ForgeHexAmethystLootMod;
import at.petrak.hexcasting.forge.loot.ForgeHexCypherLootMod;
import at.petrak.hexcasting.forge.loot.ForgeHexLoreLootMod;
import at.petrak.hexcasting.forge.loot.ForgeHexScrollLootMod;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;

public class ForgeHexLootModGen
extends GlobalLootModifierProvider {
    public static final ResourceLocation RANDOM_SCROLL_TABLE = HexAPI.modLoc("random_scroll");
    public static final ResourceLocation RANDOM_CYPHER_TABLE = HexAPI.modLoc("random_cypher");

    public ForgeHexLootModGen(PackOutput output) {
        super(output, "hexcasting");
    }

    protected void start() {
        String name;
        for (HexLootHandler.ScrollInjection injection : HexLootHandler.DEFAULT_SCROLL_INJECTS) {
            name = "scroll/%s/%s".formatted(injection.injectee().m_135827_(), injection.injectee().m_135815_());
            this.add(name, (IGlobalLootModifier)new ForgeHexScrollLootMod(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)injection.injectee()).m_6409_()}, injection.countRange()));
        }
        for (HexLootHandler.ScrollInjection injection : HexLootHandler.DEFAULT_LORE_INJECTS) {
            name = "lore/%s/%s".formatted(injection.m_135827_(), injection.m_135815_());
            this.add(name, (IGlobalLootModifier)new ForgeHexLoreLootMod(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)injection).m_6409_()}, 0.4));
        }
        for (HexLootHandler.ScrollInjection injection : HexLootHandler.DEFAULT_CYPHER_INJECTS) {
            name = "cypher/%s/%s".formatted(injection.m_135827_(), injection.m_135815_());
            this.add(name, (IGlobalLootModifier)new ForgeHexCypherLootMod(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)injection).m_6409_()}, 0.4));
        }
        this.add("scroll/hexcasting/random_scroll", (IGlobalLootModifier)new ForgeHexScrollLootMod(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)RANDOM_SCROLL_TABLE).m_6409_()}, -1));
        this.add("cypher/hexcasting/random_cypher", (IGlobalLootModifier)new ForgeHexCypherLootMod(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)RANDOM_CYPHER_TABLE).m_6409_()}, 1.0));
        this.add("amethyst_cluster", (IGlobalLootModifier)new ForgeHexAmethystLootMod(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)Blocks.f_152492_.m_60589_()).m_6409_()}, -0.5));
    }
}

