/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items.storage;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.item.IotaHolderItem;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.client.gui.PatternTooltipComponent;
import at.petrak.hexcasting.common.casting.PatternRegistryManifest;
import at.petrak.hexcasting.common.entities.EntityWallScroll;
import at.petrak.hexcasting.common.misc.PatternTooltip;
import at.petrak.hexcasting.interop.inline.InlinePatternData;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class ItemScroll
extends Item
implements IotaHolderItem {
    public static final String TAG_OP_ID = "op_id";
    public static final String TAG_PATTERN = "pattern";
    public static final String TAG_NEEDS_PURCHASE = "needs_purchase";
    public static final ResourceLocation ANCIENT_PREDICATE = HexAPI.modLoc("ancient");
    public final int blockSize;

    public ItemScroll(Item.Properties pProperties, int blockSize) {
        super(pProperties);
        this.blockSize = blockSize;
    }

    public static ItemStack withPerWorldPattern(ItemStack stack, String op_id) {
        Item item = stack.m_41720_();
        if (item instanceof ItemScroll) {
            NBTHelper.putString(stack, TAG_OP_ID, op_id);
        }
        return stack;
    }

    @Override
    @Nullable
    public CompoundTag readIotaTag(ItemStack stack) {
        CompoundTag pattern = NBTHelper.getCompound(stack, TAG_PATTERN);
        if (pattern == null) {
            return null;
        }
        CompoundTag out = new CompoundTag();
        out.m_128359_("hexcasting:type", "hexcasting:pattern");
        out.m_128365_("hexcasting:data", (Tag)pattern);
        return out;
    }

    @Override
    public boolean writeable(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canWrite(ItemStack stack, Iota datum) {
        return datum instanceof PatternIota || datum == null;
    }

    @Override
    public void writeDatum(ItemStack stack, Iota datum) {
        if (this.canWrite(stack, datum)) {
            if (datum instanceof PatternIota) {
                PatternIota pat = (PatternIota)datum;
                NBTHelper.putCompound(stack, TAG_PATTERN, pat.getPattern().serializeToNBT());
            } else if (datum == null) {
                NBTHelper.remove(stack, TAG_PATTERN);
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockPos posClicked = ctx.m_8083_();
        Direction direction = ctx.m_43719_();
        BlockPos posInFront = posClicked.m_121945_(direction);
        Player player = ctx.m_43723_();
        ItemStack itemstack = ctx.m_43722_();
        if (player != null && !this.mayPlace(player, direction, itemstack, posInFront)) {
            return InteractionResult.FAIL;
        }
        Level level = ctx.m_43725_();
        ItemStack scrollStack = itemstack.m_41777_();
        scrollStack.m_41764_(1);
        EntityWallScroll scrollEntity = new EntityWallScroll(level, posInFront, direction, scrollStack, false, this.blockSize);
        CompoundTag stackTag = itemstack.m_41783_();
        if (stackTag != null) {
            EntityType.m_20620_((Level)level, (Player)player, (Entity)scrollEntity, (CompoundTag)stackTag);
        }
        if (scrollEntity.m_7088_()) {
            if (!level.f_46443_) {
                scrollEntity.m_7084_();
                level.m_142346_((Entity)player, GameEvent.f_157810_, posClicked);
                level.m_7967_((Entity)scrollEntity);
            }
            itemstack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.CONSUME;
    }

    protected boolean mayPlace(Player pPlayer, Direction pDirection, ItemStack pHangingEntityStack, BlockPos pPos) {
        return !pDirection.m_122434_().m_122478_() && pPlayer.m_36204_(pPos, pDirection, pHangingEntityStack);
    }

    public Component m_7626_(ItemStack pStack) {
        String descID = this.m_5671_(pStack);
        String ancientId = NBTHelper.getString(pStack, TAG_OP_ID);
        if (ancientId != null) {
            return Component.m_237110_((String)(descID + ".of"), (Object[])new Object[]{Component.m_237115_((String)("hexcasting.action." + ResourceLocation.m_135820_((String)ancientId)))});
        }
        if (NBTHelper.hasCompound(pStack, TAG_PATTERN)) {
            CompoundTag compound = NBTHelper.getCompound(pStack, TAG_PATTERN);
            MutableComponent patternLabel = Component.m_237113_((String)"");
            if (compound != null) {
                HexPattern pattern = HexPattern.fromNBT(compound);
                patternLabel = Component.m_237113_((String)": ").m_7220_(new InlinePatternData(pattern).asText(false));
            }
            return Component.m_237115_((String)descID).m_7220_((Component)patternLabel);
        }
        return Component.m_237115_((String)(descID + ".empty"));
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (NBTHelper.getBoolean(pStack, TAG_NEEDS_PURCHASE)) {
            NBTHelper.remove(pStack, TAG_NEEDS_PURCHASE);
        }
        if (NBTHelper.hasString(pStack, TAG_OP_ID) && !NBTHelper.hasCompound(pStack, TAG_PATTERN) && pEntity.m_20194_() != null) {
            ResourceLocation opID = ResourceLocation.m_135820_((String)NBTHelper.getString(pStack, TAG_OP_ID));
            if (opID == null) {
                NBTHelper.remove(pStack, TAG_OP_ID);
                return;
            }
            ResourceKey patternKey = ResourceKey.m_135785_((ResourceKey)IXplatAbstractions.INSTANCE.getActionRegistry().m_123023_(), (ResourceLocation)opID);
            HexPattern pat = PatternRegistryManifest.getCanonicalStrokesPerWorld((ResourceKey<ActionRegistryEntry>)patternKey, pEntity.m_20194_().m_129783_());
            NBTHelper.put(pStack, TAG_PATTERN, (Tag)pat.serializeToNBT());
        }
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (NBTHelper.getBoolean(pStack, TAG_NEEDS_PURCHASE)) {
            MutableComponent needsPurchase = Component.m_237115_((String)"hexcasting.tooltip.scroll.needs_purchase");
            pTooltipComponents.add((Component)needsPurchase.m_130940_(ChatFormatting.GRAY));
        } else if (NBTHelper.hasString(pStack, TAG_OP_ID) && !NBTHelper.hasCompound(pStack, TAG_PATTERN)) {
            MutableComponent notLoaded = Component.m_237115_((String)"hexcasting.tooltip.scroll.pattern_not_loaded");
            pTooltipComponents.add((Component)notLoaded.m_130940_(ChatFormatting.GRAY));
        }
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        CompoundTag compound = NBTHelper.getCompound(stack, TAG_PATTERN);
        if (compound != null && !NBTHelper.getBoolean(stack, TAG_NEEDS_PURCHASE)) {
            HexPattern pattern = HexPattern.fromNBT(compound);
            return Optional.of(new PatternTooltip(pattern, NBTHelper.hasString(stack, TAG_OP_ID) ? PatternTooltipComponent.ANCIENT_BG : PatternTooltipComponent.PRISTINE_BG));
        }
        return Optional.empty();
    }
}

