/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.network.messages.base;

import com.google.common.base.MoreObjects;
import com.seibel.distanthorizons.core.network.messages.AbstractNetworkMessage;
import io.netty.buffer.ByteBuf;

public class LevelInitMessage
extends AbstractNetworkMessage {
    public static final int MAX_LENGTH = 150;
    public static final String PART_ALLOWED_CHARS_REGEX = "a-zA-Z0-9-_";
    public static final String VALIDATION_REGEX = String.format("^(?=.{1,%s}$)([%s]+@)?[%s]+(:[%s]+)?$", 150, "a-zA-Z0-9-_", "a-zA-Z0-9-_", "a-zA-Z0-9-_");
    public String levelKey;
    public long serverTime;

    public LevelInitMessage() {
    }

    public LevelInitMessage(String levelKey) {
        this.levelKey = levelKey;
        this.serverTime = System.currentTimeMillis();
    }

    @Override
    public void encode(ByteBuf out) {
        this.writeString(this.levelKey, out);
        out.writeLong(this.serverTime);
    }

    @Override
    public void decode(ByteBuf in) {
        this.levelKey = this.readString(in);
        this.serverTime = in.readLong();
    }

    @Override
    public MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("levelKey", (Object)this.levelKey).add("serverTime", this.serverTime);
    }
}

