/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.renderer.image;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;
import org.tlauncher.renderer.image.ImageWrap;
import org.tlauncher.util.TypeLocator;

public class BufferedImageWrap
implements ImageWrap,
TypeLocator {
    private static Method uploadTexture;
    private static Method allocateTexture;
    private final BufferedImage bufferedImage;

    public BufferedImageWrap(InputStream inputStream) {
        this.bufferedImage = ImageIO.read(inputStream);
    }

    public BufferedImageWrap(int width, int height) {
        this.bufferedImage = new BufferedImage(width, height, 2);
    }

    public BufferedImageWrap(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
    }

    @Override
    public int getWidth() {
        return this.bufferedImage.getWidth();
    }

    @Override
    public int getHeight() {
        return this.bufferedImage.getHeight();
    }

    @Override
    public int getRGB(int x, int y) {
        return this.bufferedImage.getRGB(x, y);
    }

    @Override
    public void setRGB(int x, int y, int color) {
        this.bufferedImage.setRGB(x, y, color);
    }

    @Override
    public void allocateTexture(int textureId) {
        if (allocateTexture == null) {
            allocateTexture = this.findMethod(new TypeLocator.ClassNames("net.minecraft.client.renderer.texture.TextureUtil", "cdt", "bml", "cuj"), new TypeLocator.MethodData("allocateTexture", Integer.TYPE, Integer.TYPE, Integer.TYPE), new TypeLocator.MethodData("a", Integer.TYPE, Integer.TYPE, Integer.TYPE));
        }
        allocateTexture.invoke(null, textureId, this.getWidth(), this.getHeight());
    }

    @Override
    public void uploadTexture(int textureId) {
        int[] dynamicTextureData = new int[this.getWidth() * this.getHeight()];
        this.bufferedImage.getRGB(0, 0, this.bufferedImage.getWidth(), this.bufferedImage.getHeight(), dynamicTextureData, 0, this.bufferedImage.getWidth());
        if (uploadTexture == null) {
            uploadTexture = this.findMethod(new TypeLocator.ClassNames("net.minecraft.client.renderer.texture.TextureUtil", "cdt", "bml", "cuj"), new TypeLocator.MethodData("uploadTexture", Integer.TYPE, int[].class, Integer.TYPE, Integer.TYPE), new TypeLocator.MethodData("a", Integer.TYPE, int[].class, Integer.TYPE, Integer.TYPE));
        }
        uploadTexture.invoke(null, textureId, dynamicTextureData, this.getWidth(), this.getHeight());
    }

    @Override
    public void close() {
    }
}

