/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.entities;

import com.google.common.collect.Lists;
import ganymedes01.etfuturum.api.BeePlantRegistry;
import ganymedes01.etfuturum.blocks.BlockBeeHive;
import ganymedes01.etfuturum.blocks.BlockMagma;
import ganymedes01.etfuturum.client.particle.CustomParticles;
import ganymedes01.etfuturum.core.utils.EntityVectorUtils;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.core.utils.helpers.BlockPos;
import ganymedes01.etfuturum.entities.INoGravityEntity;
import ganymedes01.etfuturum.entities.ai.FlyMoveHelper;
import ganymedes01.etfuturum.entities.ai.FlyingPathNavigator;
import ganymedes01.etfuturum.entities.attributes.EtFuturumEntityAttributes;
import ganymedes01.etfuturum.tileentities.TileEntityBeeHive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockWall;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityBee
extends EntityAnimal
implements INoGravityEntity {
    private static final int DATA_FLAGS_ID = 13;
    private static final int ANGER_TIME = 14;
    private static final int NO_GRAVITY = 15;
    private UUID lastHurtBy;
    private float rollAmount;
    private float rollAmountO;
    private int timeSinceSting;
    private int ticksWithoutNectarSinceExitingHive;
    private int stayOutOfHiveCountdown;
    private int numCropsGrownSincePollination;
    private int remainingCooldownBeforeLocatingNewHive = 0;
    private int remainingCooldownBeforeLocatingNewFlower = 0;
    private BlockPos savedFlowerPos = null;
    private BlockPos hivePos = null;
    private PollinateGoal pollinateGoal;
    private FindBeehiveGoal findBeehiveGoal;
    private FindFlowerGoal findFlowerGoal;
    private int underWaterTicks;
    private float moveVertical;

    public EntityBee(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 0.7f);
        this.field_70699_by = new FlyingPathNavigator((EntityLiving)this, worldIn){

            @Override
            public boolean func_75483_a(int p_75483_1_, int p_75483_2_, int p_75483_3_, int p_75483_4_, int p_75483_5_, int p_75483_6_, Vec3 p_75483_7_, double p_75483_8_, double p_75483_10_) {
                int k1 = p_75483_1_ - p_75483_4_ / 2;
                int l1 = p_75483_3_ - p_75483_6_ / 2;
                if (this.func_75496_b(k1, p_75483_2_, l1, p_75483_4_, p_75483_5_, p_75483_6_, p_75483_7_, p_75483_8_, p_75483_10_)) {
                    for (int i2 = k1; i2 < k1 + p_75483_4_; ++i2) {
                        for (int j2 = l1; j2 < l1 + p_75483_6_; ++j2) {
                            Block block;
                            double d2 = (double)i2 + 0.5 - p_75483_7_.field_72450_a;
                            double d3 = (double)j2 + 0.5 - p_75483_7_.field_72449_c;
                            if (!(d2 * p_75483_8_ + d3 * p_75483_10_ >= 0.0) || !(block = this.field_75513_b.func_147439_a(i2, p_75483_2_ - 1, j2)).isAir((IBlockAccess)this.field_75513_b, i2, p_75483_2_ - 1, j2)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }

            @Override
            public void func_75501_e() {
                if (!EntityBee.this.pollinateGoal.isRunning()) {
                    super.func_75501_e();
                }
            }
        };
        this.field_70749_g = new BeeLookController(this);
        this.field_70765_h = new FlyMoveHelper((EntityLiving)this, 10, true);
        this.addTasks();
        this.func_70661_as().func_75498_b(false);
        this.func_70661_as().func_75490_c(true);
        this.func_70661_as().func_75495_e(false);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(13, (Object)0);
        this.func_70096_w().func_75682_a(14, (Object)0);
        this.func_70096_w().func_75682_a(15, (Object)1);
    }

    public float func_70783_a(int x, int y, int z) {
        Block block = this.field_70170_p.func_147439_a(x, y, z);
        if (block.func_149688_o() == Material.field_151579_a) {
            return 10.0f;
        }
        if (block.func_149688_o().func_76224_d() || block instanceof BlockFire || block instanceof BlockCocoa || block instanceof BlockFence || block instanceof BlockWall || block instanceof BlockMagma) {
            return -1.0f;
        }
        return 0.0f;
    }

    protected boolean func_70650_aV() {
        return true;
    }

    protected void addTasks() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new StingGoal((EntityCreature)this, EntityLivingBase.class, 1.4, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EnterBeehiveGoal());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new TemptBeeWithFlowerGoal((EntityCreature)this, 1.25, false));
        this.pollinateGoal = new PollinateGoal();
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.pollinateGoal);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new UpdateBeehiveGoal());
        this.findBeehiveGoal = new FindBeehiveGoal();
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.findBeehiveGoal);
        this.findFlowerGoal = new FindFlowerGoal();
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.findFlowerGoal);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new FindPollinationTargetGoal());
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new WanderGoal());
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AngerGoal(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new AttackPlayerGoal(this));
        this.func_70661_as().func_75491_a(true);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("HasNoGravity", this.hasNoGravity());
        if (this.hasHive()) {
            compound.func_74782_a("HivePos", (NBTBase)BlockPos.writeToNBT(this.getHivePos()));
        }
        if (this.hasFlower()) {
            compound.func_74782_a("FlowerPos", (NBTBase)BlockPos.writeToNBT(this.getFlowerPos()));
        }
        compound.func_74757_a("HasNectar", this.hasNectar());
        compound.func_74757_a("HasStung", this.hasStung());
        compound.func_74768_a("TicksSincePollination", this.ticksWithoutNectarSinceExitingHive);
        compound.func_74768_a("CannotEnterHiveTicks", this.stayOutOfHiveCountdown);
        compound.func_74768_a("CropsGrownSincePollination", this.numCropsGrownSincePollination);
        compound.func_74768_a("Anger", this.getAnger());
        if (this.lastHurtBy != null) {
            compound.func_74778_a("HurtBy", this.lastHurtBy.toString());
        } else {
            compound.func_74778_a("HurtBy", "");
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.hivePos = null;
        if (compound.func_74764_b("HivePos")) {
            this.hivePos = BlockPos.readFromNBT(compound.func_74775_l("HivePos"));
        }
        this.savedFlowerPos = null;
        if (compound.func_74764_b("FlowerPos")) {
            this.setFlowerPos(BlockPos.readFromNBT(compound.func_74775_l("FlowerPos")));
        }
        super.func_70037_a(compound);
        this.setNoGravity(compound.func_74767_n("HasNoGravity"));
        this.setHasNectar(compound.func_74767_n("HasNectar"));
        this.setHasStung(compound.func_74767_n("HasStung"));
        this.setAnger(compound.func_74762_e("Anger"));
        this.ticksWithoutNectarSinceExitingHive = compound.func_74762_e("TicksSincePollination");
        this.stayOutOfHiveCountdown = compound.func_74762_e("CannotEnterHiveTicks");
        this.numCropsGrownSincePollination = compound.func_74762_e("CropsGrownSincePollination");
        String s = compound.func_74779_i("HurtBy");
        if (!s.isEmpty()) {
            this.lastHurtBy = UUID.fromString(s);
            EntityPlayer playerentity = null;
            for (EntityPlayer player : this.field_70170_p.field_73010_i) {
                if (!this.lastHurtBy.equals(player.func_110124_au())) continue;
                playerentity = player;
                break;
            }
            this.func_70604_c((EntityLivingBase)playerentity);
            if (playerentity != null) {
                this.field_70717_bb = playerentity;
                this.field_70718_bc = this.field_70700_bx;
            }
        }
    }

    public void func_70612_e(float moveForward, float moveStrafing) {
        double d0;
        if (this.func_70090_H()) {
            d0 = this.field_70163_u;
            this.func_70060_a(moveForward, moveStrafing, this.func_70650_aV() ? 0.04f : 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
            if (!this.hasNoGravity()) {
                this.field_70181_x -= 0.02;
            }
            if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f - this.field_70163_u + d0, this.field_70179_y)) {
                this.field_70181_x = 0.3f;
            }
        } else if (this.func_70058_J()) {
            d0 = this.field_70163_u;
            this.func_70060_a(moveForward, moveStrafing, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
            if (!this.hasNoGravity()) {
                this.field_70181_x -= 0.02;
            }
            if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f - this.field_70163_u + d0, this.field_70179_y)) {
                this.field_70181_x = 0.3f;
            }
        } else {
            float f2 = 0.91f;
            if (this.field_70122_E) {
                f2 = this.field_70170_p.func_147439_a((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v)).field_149765_K * 0.91f;
            }
            float f3 = 0.16277136f / (f2 * f2 * f2);
            float f4 = this.field_70122_E ? this.func_70689_ay() * f3 : this.field_70747_aH;
            this.func_70060_a(moveForward, moveStrafing, f4);
            f2 = 0.91f;
            if (this.field_70122_E) {
                f2 = this.field_70170_p.func_147439_a((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v)).field_149765_K * 0.91f;
            }
            if (this.func_70617_f_()) {
                float f5 = 0.15f;
                this.field_70159_w = MathHelper.func_151237_a((double)this.field_70159_w, (double)(-f5), (double)f5);
                this.field_70179_y = MathHelper.func_151237_a((double)this.field_70179_y, (double)(-f5), (double)f5);
                this.field_70143_R = 0.0f;
                if (this.field_70181_x < -0.15) {
                    this.field_70181_x = -0.15;
                }
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (this.field_70123_F && this.func_70617_f_()) {
                this.field_70181_x = 0.2;
            }
            if (!(!this.field_70170_p.field_72995_K || this.field_70170_p.func_72899_e((int)this.field_70165_t, 0, (int)this.field_70161_v) && this.field_70170_p.func_72938_d((int)((int)this.field_70165_t), (int)((int)this.field_70161_v)).field_76636_d)) {
                this.field_70181_x = this.field_70163_u > 0.0 ? -0.1 : 0.0;
            } else if (!this.hasNoGravity()) {
                this.field_70181_x -= 0.08;
            }
            this.field_70181_x *= this.moveVertical != 0.0f ? 0.98 : 0.5;
            this.field_70159_w *= (double)f2;
            this.field_70179_y *= (double)f2;
        }
        this.field_70722_aY = this.field_70721_aZ;
        d0 = this.field_70165_t - this.field_70169_q;
        double d1 = this.field_70161_v - this.field_70166_s;
        float f6 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1)) * 4.0f;
        if (f6 > 1.0f) {
            f6 = 1.0f;
        }
        this.field_70721_aZ += (f6 - this.field_70721_aZ) * 0.4f;
        this.field_70754_ba += this.field_70721_aZ;
    }

    @Override
    public void setMoveVertical(float moveVertical) {
        this.moveVertical = moveVertical;
    }

    public void func_70060_a(float moveForward, float moveStrafing, float varFloat) {
        if (this.moveVertical != 0.0f) {
            float f3 = moveForward * moveForward + this.moveVertical * this.moveVertical + moveStrafing * moveStrafing;
            if (f3 >= 1.0E-4f) {
                if ((f3 = MathHelper.func_76129_c((float)f3)) < 1.0f) {
                    f3 = 1.0f;
                }
                f3 = varFloat / f3;
                this.moveVertical *= f3;
                float f4 = MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f));
                float f5 = MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f));
                this.field_70159_w += (double)((moveForward *= f3) * f5 - (moveStrafing *= f3) * f4);
                this.field_70181_x += (double)this.moveVertical;
                this.field_70179_y += (double)(moveStrafing * f5 + moveForward * f4);
            }
        } else {
            super.func_70060_a(moveForward, moveStrafing, varFloat);
        }
    }

    public void func_70653_a(Entity p_70653_1_, float p_70653_2_, double p_70653_3_, double p_70653_5_) {
        if (this.field_70146_Z.nextDouble() >= this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e()) {
            this.field_70160_al = true;
            float f1 = MathHelper.func_76133_a((double)(p_70653_3_ * p_70653_3_ + p_70653_5_ * p_70653_5_));
            float f2 = 0.4f;
            this.field_70159_w /= 2.0;
            this.field_70179_y /= 2.0;
            this.field_70159_w -= p_70653_3_ / (double)f1 * (double)f2;
            this.field_70179_y -= p_70653_5_ / (double)f1 * (double)f2;
            if (!this.hasNoGravity()) {
                this.field_70181_x /= 2.0;
                this.field_70181_x += (double)f2;
                if (this.field_70181_x > (double)0.4f) {
                    this.field_70181_x = 0.4f;
                }
            } else {
                this.field_70181_x += 0.1;
            }
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a((DamageSource)new EntityDamageSource("sting", (Entity)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            if (entityIn instanceof EntityLivingBase) {
                int i = 0;
                if (this.field_70170_p.field_73013_u == EnumDifficulty.NORMAL) {
                    i = 10;
                } else if (this.field_70170_p.field_73013_u == EnumDifficulty.HARD) {
                    i = 18;
                }
                if (i > 0) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, i * 20, 0));
                }
            }
            this.setHasStung(true);
            this.func_70624_b(null);
            this.func_85030_a("minecraft_1.21:entity.bee.sting", 1.0f, 1.0f);
        }
        return flag;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.hasNectar() && this.getCropsGrownSincePollination() < 10 && this.field_70146_Z.nextFloat() < 0.05f) {
            for (int i = 0; i < this.field_70146_Z.nextInt(2) + 1; ++i) {
                this.addParticle(this.field_70170_p, this.field_70165_t - (double)0.3f, this.field_70165_t + (double)0.3f, this.field_70161_v - (double)0.3f, this.field_70161_v + (double)0.3f, this.field_70163_u + (double)(this.field_70131_O * 0.5f));
            }
        }
        this.updateBodyPitch();
    }

    private void addParticle(World worldIn, double p_226397_2_, double p_226397_4_, double p_226397_6_, double p_226397_8_, double posY) {
        CustomParticles.spawnBeeNectarParticle(worldIn, Utils.lerp(worldIn.field_73012_v.nextDouble(), p_226397_2_, p_226397_4_), posY, Utils.lerp(worldIn.field_73012_v.nextDouble(), p_226397_6_, p_226397_8_));
    }

    private boolean isBreedingFlower(Block block, int meta) {
        return BeePlantRegistry.isFlower(block, meta);
    }

    public static boolean isValidFlower(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block instanceof BlockDoublePlant && meta > 8) {
            return BeePlantRegistry.isFlower(world.func_147439_a(x, y - 1, z), world.func_72805_g(x, y - 1, z));
        }
        return BeePlantRegistry.isFlower(block, meta);
    }

    public BlockPos getFlowerPos() {
        return this.savedFlowerPos;
    }

    public boolean hasFlower() {
        return this.savedFlowerPos != null;
    }

    public void setFlowerPos(BlockPos pos) {
        this.savedFlowerPos = pos;
    }

    private boolean failedPollinatingTooLong() {
        return this.ticksWithoutNectarSinceExitingHive > 3600;
    }

    private boolean canEnterHive() {
        if (this.stayOutOfHiveCountdown <= 0 && !this.pollinateGoal.isRunning() && !this.hasStung()) {
            boolean flag = this.failedPollinatingTooLong() || this.field_70170_p.func_72896_J() || !this.field_70170_p.func_72935_r() || this.hasNectar();
            return flag && !this.isHiveNearFire();
        }
        return false;
    }

    public void setStayOutOfHiveCountdown(int p_226450_1_) {
        this.stayOutOfHiveCountdown = p_226450_1_;
    }

    public float getBodyPitch(float p_226455_1_) {
        return Utils.lerp(p_226455_1_, this.rollAmountO, this.rollAmount);
    }

    private void updateBodyPitch() {
        this.rollAmountO = this.rollAmount;
        this.rollAmount = this.isNearTarget() ? Math.min(1.0f, this.rollAmount + 0.2f) : Math.max(0.0f, this.rollAmount - 0.24f);
    }

    public void func_70604_c(EntityLivingBase livingBase) {
        super.func_70604_c(livingBase);
        if (livingBase != null) {
            this.lastHurtBy = livingBase.func_110124_au();
        }
    }

    protected void func_70629_bd() {
        this.underWaterTicks = this.func_70090_H() ? ++this.underWaterTicks : 0;
        if (this.underWaterTicks > 20) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.hasStung()) {
            ++this.timeSinceSting;
            if (this.timeSinceSting % 5 == 0 && this.field_70146_Z.nextInt(MathHelper.func_76125_a((int)(1200 - this.timeSinceSting), (int)1, (int)1200)) == 0) {
                this.func_70097_a(DamageSource.field_76377_j, this.func_110143_aJ());
            }
        }
        if (this.isAngry()) {
            int i = this.getAnger();
            this.setAnger(i - 1);
            if (i == 0 && this.func_70638_az() != null) {
                this.setBeeAttacker((Entity)this.func_70638_az());
            }
        }
        if (!this.hasNectar()) {
            ++this.ticksWithoutNectarSinceExitingHive;
        }
    }

    public void resetTicksWithoutNectar() {
        this.ticksWithoutNectarSinceExitingHive = 0;
    }

    private boolean isHiveNearFire() {
        if (this.hivePos == null) {
            return false;
        }
        TileEntity tileentity = this.hivePos.getTileEntity(this.field_70170_p);
        return tileentity instanceof TileEntityBeeHive && ((TileEntityBeeHive)tileentity).isNearFire();
    }

    public boolean isAngry() {
        return this.getAnger() > 0;
    }

    private int getAnger() {
        return this.func_70096_w().func_75679_c(14);
    }

    private void setAnger(int angerTime) {
        this.func_70096_w().func_75692_b(14, (Object)angerTime);
    }

    private boolean doesHiveHaveSpace(BlockPos pos) {
        TileEntity tileentity = pos.getTileEntity(this.field_70170_p);
        if (tileentity instanceof TileEntityBeeHive) {
            return !((TileEntityBeeHive)tileentity).isFullOfBees();
        }
        return false;
    }

    public boolean hasHive() {
        return this.hivePos != null;
    }

    public BlockPos getHivePos() {
        return this.hivePos;
    }

    private int getCropsGrownSincePollination() {
        return this.numCropsGrownSincePollination;
    }

    private void resetCropCounter() {
        this.numCropsGrownSincePollination = 0;
    }

    private void addCropCounter() {
        ++this.numCropsGrownSincePollination;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.stayOutOfHiveCountdown > 0) {
                --this.stayOutOfHiveCountdown;
            }
            if (this.remainingCooldownBeforeLocatingNewHive > 0) {
                --this.remainingCooldownBeforeLocatingNewHive;
            }
            if (this.remainingCooldownBeforeLocatingNewFlower > 0) {
                --this.remainingCooldownBeforeLocatingNewFlower;
            }
        }
    }

    private boolean isHiveValid() {
        if (!this.hasHive()) {
            return false;
        }
        return this.hivePos.getTileEntity(this.field_70170_p) instanceof TileEntityBeeHive;
    }

    public boolean hasNectar() {
        return this.getBeeFlag(8);
    }

    private void setHasNectar(boolean p_226447_1_) {
        if (p_226447_1_) {
            this.resetTicksWithoutNectar();
        }
        this.setBeeFlag(8, p_226447_1_);
    }

    public boolean hasStung() {
        return this.getBeeFlag(4);
    }

    private void setHasStung(boolean p_226449_1_) {
        this.setBeeFlag(4, p_226449_1_);
    }

    private boolean isNearTarget() {
        return this.getBeeFlag(2);
    }

    private void setNearTarget(boolean p_226452_1_) {
        this.setBeeFlag(2, p_226452_1_);
    }

    private boolean isTooFar(BlockPos pos) {
        return !this.isWithinDistance(pos, 48);
    }

    private void setBeeFlag(int flagId, boolean p_226404_2_) {
        if (p_226404_2_) {
            this.func_70096_w().func_75692_b(13, (Object)((byte)(this.func_70096_w().func_75683_a(13) | flagId)));
        } else {
            this.func_70096_w().func_75692_b(13, (Object)((byte)(this.func_70096_w().func_75683_a(13) & ~flagId)));
        }
    }

    private boolean getBeeFlag(int flagId) {
        return (this.func_70096_w().func_75683_a(13) & flagId) != 0;
    }

    public boolean isPollinating() {
        return this.getBeeFlag(1);
    }

    public void setPollinating(boolean isPollinating) {
        this.setBeeFlag(1, isPollinating);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(EtFuturumEntityAttributes.flyingSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(EtFuturumEntityAttributes.flyingSpeed).func_111128_a((double)0.6f);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    public boolean func_70877_b(ItemStack stack) {
        return this.isBreedingFlower(Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77960_j());
    }

    protected void func_145780_a(int x, int y, int z, Block blockIn) {
    }

    public int func_70627_aG() {
        return 0;
    }

    public void func_70642_aH() {
    }

    protected String func_70639_aQ() {
        return null;
    }

    protected String func_70621_aR() {
        return "minecraft_1.21:entity.bee.hurt";
    }

    protected String func_70673_aS() {
        return "minecraft_1.21:entity.bee.death";
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public EntityBee createChild(EntityAgeable entity) {
        return new EntityBee(entity.field_70170_p);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    protected void func_70069_a(float distance) {
    }

    protected void func_70064_a(double distanceFallenThisTick, boolean isOnGround) {
    }

    public void onHoneyDelivered() {
        this.setHasNectar(false);
        this.resetCropCounter();
    }

    public boolean setBeeAttacker(Entity attacker) {
        this.setAnger(400 + this.field_70146_Z.nextInt(400));
        if (attacker instanceof EntityLivingBase) {
            this.func_70604_c((EntityLivingBase)attacker);
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_85032_ar()) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (!(this.field_70170_p.field_72995_K || !(entity instanceof EntityLivingBase) || entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d || !this.func_70685_l(entity))) {
            this.pollinateGoal.cancel();
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(32.0, 32.0, 32.0));
            for (Entity entity1 : list) {
                if (!(entity1 instanceof EntityBee)) continue;
                ((EntityBee)entity1).setBeeAttacker(entity);
            }
        }
        return super.func_70097_a(source, amount);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    private boolean isWithinDistance(BlockPos pos, int distance) {
        return Utils.getVec3FromEntity((Entity)this, 1.0f).func_72445_d((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) <= (double)(distance * distance);
    }

    @Override
    public void setNoGravity(boolean noGravity) {
        this.func_70096_w().func_75692_b(15, (Object)(noGravity ? (byte)1 : 0));
    }

    @Override
    public boolean hasNoGravity() {
        return this.func_70096_w().func_75683_a(15) == 1;
    }

    private void startMovingTo(BlockPos pos) {
        Vec3 vec3d1;
        Vec3 vec3d = pos.newVec3();
        int i = 0;
        BlockPos blockpos = new BlockPos((Entity)this);
        int j = (int)vec3d.field_72448_b - blockpos.getY();
        if (j > 2) {
            i = 4;
        } else if (j < -2) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        int i1 = blockpos.manhattanDistance(pos);
        if (i1 < 15) {
            k = i1 / 2;
            l = i1 / 2;
        }
        if ((vec3d1 = EntityVectorUtils.func_226344_b_((EntityCreature)this, k, l, i, vec3d, 0.3141592741012573)) != null) {
            this.func_70661_as().func_75492_a(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, 1.0);
        }
    }

    private List<BlockPos> getBlocksInRange(Predicate<BlockPos> predicate, int range, boolean shuffle) {
        BlockPos beePos = new BlockPos((Entity)this);
        ArrayList posList = Lists.newArrayList();
        for (int x1 = -range; x1 <= range; ++x1) {
            for (int y1 = -range; y1 <= range; ++y1) {
                for (int z1 = -range; z1 <= range; ++z1) {
                    BlockPos pos2 = beePos.add(x1, y1, z1);
                    if (!predicate.test(pos2)) continue;
                    posList.add(pos2);
                }
            }
        }
        if (shuffle) {
            Collections.shuffle(posList);
        } else {
            posList.sort(Comparator.comparingDouble(pos -> pos.getSquaredDistance(beePos)));
        }
        return posList;
    }

    public class FindBeehiveGoal
    extends PassiveGoal {
        private int ticks;
        private final List<BlockPos> possibleHives;
        private PathEntity path;

        FindBeehiveGoal() {
            this.ticks = EntityBee.this.field_70170_p.field_73012_v.nextInt(10);
            this.possibleHives = Lists.newArrayList();
            this.path = null;
            this.func_75248_a(0);
        }

        @Override
        public boolean canBeeStart() {
            return EntityBee.this.hivePos != null && !EntityBee.this.func_110175_bO() && EntityBee.this.canEnterHive() && !this.isCloseEnough(EntityBee.this.hivePos) && EntityBee.this.getHivePos().getBlock(EntityBee.this.field_70170_p) instanceof BlockBeeHive;
        }

        @Override
        public boolean canBeeContinue() {
            return this.canBeeStart();
        }

        public void func_75249_e() {
            this.ticks = 0;
            super.func_75249_e();
        }

        public void func_75251_c() {
            this.ticks = 0;
            EntityBee.this.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            if (EntityBee.this.hivePos != null) {
                ++this.ticks;
                if (this.ticks > 600) {
                    this.makeChosenHivePossibleHive();
                } else if (EntityBee.this.func_70661_as().func_75500_f()) {
                    if (!EntityBee.this.isWithinDistance(EntityBee.this.hivePos, 16)) {
                        if (EntityBee.this.isTooFar(EntityBee.this.hivePos)) {
                            this.reset();
                        } else {
                            EntityBee.this.startMovingTo(EntityBee.this.hivePos);
                        }
                    } else {
                        boolean flag = this.startMovingToFar(EntityBee.this.hivePos);
                        if (!flag) {
                            this.makeChosenHivePossibleHive();
                        } else if (this.path != null && EntityBee.this.func_70661_as().func_75505_d().func_75876_a(this.path)) {
                            this.reset();
                        } else {
                            this.path = EntityBee.this.func_70661_as().func_75505_d();
                        }
                    }
                }
            }
        }

        private boolean startMovingToFar(BlockPos pos) {
            EntityBee.this.func_70661_as().func_75492_a((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 1.0);
            return EntityBee.this.func_70661_as().func_75505_d() != null;
        }

        private boolean isPossibleHive(BlockPos pos) {
            return this.possibleHives.contains(pos);
        }

        private void addPossibleHives(BlockPos pos) {
            this.possibleHives.add(pos);
            while (this.possibleHives.size() > 3) {
                this.possibleHives.remove(0);
            }
        }

        private void clearPossibleHives() {
            this.possibleHives.clear();
        }

        private void makeChosenHivePossibleHive() {
            if (EntityBee.this.hivePos != null) {
                this.addPossibleHives(EntityBee.this.hivePos);
            }
            this.reset();
        }

        private void reset() {
            EntityBee.this.hivePos = null;
            EntityBee.this.remainingCooldownBeforeLocatingNewHive = 200;
        }

        private boolean isCloseEnough(BlockPos pos) {
            if (EntityBee.this.isWithinDistance(pos, 2)) {
                return true;
            }
            PathEntity path = EntityBee.this.func_70661_as().func_75505_d();
            return path != null && path.func_75880_b(Vec3.func_72443_a((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())) && path.func_75879_b();
        }
    }

    class PollinateGoal
    extends PassiveGoal {
        private int pollinationTicks;
        private int lastPollinationTick;
        private boolean running;
        private Vec3 nextTarget;
        private int ticks;

        PollinateGoal() {
            this.pollinationTicks = 0;
            this.lastPollinationTick = 0;
            this.ticks = 0;
            this.func_75248_a(0);
        }

        @Override
        public boolean canBeeStart() {
            if (EntityBee.this.remainingCooldownBeforeLocatingNewFlower > 0) {
                return false;
            }
            if (EntityBee.this.hasNectar()) {
                return false;
            }
            if (EntityBee.this.field_70170_p.func_72896_J()) {
                return false;
            }
            if (EntityBee.this.field_70146_Z.nextFloat() < 0.7f) {
                return false;
            }
            Optional<BlockPos> optional = this.getFlower();
            if (optional.isPresent()) {
                EntityBee.this.savedFlowerPos = optional.get();
                EntityBee.this.func_70661_as().func_75492_a((double)EntityBee.this.savedFlowerPos.getX() + 0.5, (double)EntityBee.this.savedFlowerPos.getY() + 0.5, (double)EntityBee.this.savedFlowerPos.getZ() + 0.5, (double)1.2f);
                return true;
            }
            return false;
        }

        @Override
        public boolean canBeeContinue() {
            if (!this.running) {
                return false;
            }
            if (!EntityBee.this.hasFlower()) {
                return false;
            }
            if (EntityBee.this.field_70170_p.func_72896_J()) {
                return false;
            }
            if (this.completedPollination()) {
                return EntityBee.this.field_70146_Z.nextFloat() < 0.2f;
            }
            if (EntityBee.this.field_70173_aa % 20 == 0 && !EntityBee.isValidFlower(EntityBee.this.field_70170_p, EntityBee.this.savedFlowerPos.getX(), EntityBee.this.savedFlowerPos.getY(), EntityBee.this.savedFlowerPos.getZ())) {
                EntityBee.this.savedFlowerPos = null;
                return false;
            }
            return true;
        }

        private boolean completedPollination() {
            return this.pollinationTicks > 400;
        }

        private boolean isRunning() {
            return this.running;
        }

        private void cancel() {
            this.running = false;
        }

        public void func_75249_e() {
            this.pollinationTicks = 0;
            this.ticks = 0;
            this.lastPollinationTick = 0;
            this.running = true;
            EntityBee.this.resetTicksWithoutNectar();
        }

        public void func_75251_c() {
            if (this.completedPollination()) {
                EntityBee.this.setHasNectar(true);
            }
            this.running = false;
            EntityBee.this.func_70661_as().func_75499_g();
            EntityBee.this.remainingCooldownBeforeLocatingNewFlower = 200;
        }

        public void func_75246_d() {
            BlockPos beePos = new BlockPos((Entity)EntityBee.this);
            ++this.ticks;
            if (this.ticks > 600) {
                EntityBee.this.savedFlowerPos = null;
            } else {
                Vec3 vec3d = EntityBee.this.savedFlowerPos.add(0.5, 0.6f, 0.5).newVec3();
                if (vec3d.func_72445_d(EntityBee.this.field_70165_t, EntityBee.this.field_70163_u, EntityBee.this.field_70161_v) > 1.0) {
                    this.nextTarget = vec3d;
                    this.moveToNextTarget();
                } else {
                    if (this.nextTarget == null) {
                        this.nextTarget = vec3d;
                    }
                    boolean flag = beePos.getSquaredDistance(this.nextTarget) <= 0.1;
                    boolean flag1 = true;
                    if (!flag && this.ticks > 600) {
                        EntityBee.this.savedFlowerPos = null;
                    } else {
                        if (flag) {
                            boolean flag2;
                            boolean bl = flag2 = EntityBee.this.field_70146_Z.nextInt(100) == 0;
                            if (flag2) {
                                this.nextTarget = Vec3.func_72443_a((double)(vec3d.field_72450_a + (double)this.getRandomOffset()), (double)vec3d.field_72448_b, (double)(vec3d.field_72449_c + (double)this.getRandomOffset()));
                                EntityBee.this.func_70661_as().func_75499_g();
                            } else {
                                flag1 = false;
                            }
                        }
                        if (flag1) {
                            this.moveToNextTarget();
                        }
                        ++this.pollinationTicks;
                        if (EntityBee.this.field_70146_Z.nextFloat() < 0.05f && this.pollinationTicks > this.lastPollinationTick + 60) {
                            this.lastPollinationTick = this.pollinationTicks;
                            EntityBee.this.func_85030_a("minecraft_1.21:entity.bee.pollinate", 1.0f, 1.0f);
                        }
                    }
                }
            }
        }

        private void moveToNextTarget() {
            EntityBee.this.func_70605_aq().func_75642_a(this.nextTarget.field_72450_a, this.nextTarget.field_72448_b, this.nextTarget.field_72449_c, (double)0.35f);
        }

        private float getRandomOffset() {
            return (EntityBee.this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.33333334f;
        }

        private Optional<BlockPos> getFlower() {
            return this.findFlower(5);
        }

        private Optional<BlockPos> findFlower(int distance) {
            List list = EntityBee.this.getBlocksInRange(pos -> EntityBee.isValidFlower(EntityBee.this.field_70170_p, pos.getX(), pos.getY(), pos.getZ()), distance, true);
            return list.isEmpty() || list.get(0) == null ? Optional.empty() : Optional.of((BlockPos)list.get(0));
        }
    }

    class BeeLookController
    extends EntityLookHelper {
        BeeLookController(EntityBee beeIn) {
            super((EntityLiving)beeIn);
        }

        public void func_75649_a() {
            if (!EntityBee.this.isAngry()) {
                super.func_75649_a();
            }
        }
    }

    class StingGoal
    extends EntityAIAttackOnCollide {
        StingGoal(EntityCreature creatureIn, Class<? extends Entity> classIn, double speedIn, boolean useLongMemory) {
            super(creatureIn, classIn, speedIn, useLongMemory);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && EntityBee.this.isAngry() && !EntityBee.this.hasStung();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && EntityBee.this.isAngry() && !EntityBee.this.hasStung();
        }
    }

    class EnterBeehiveGoal
    extends PassiveGoal {
        private EnterBeehiveGoal() {
        }

        @Override
        public boolean canBeeStart() {
            TileEntity tileentity;
            if (EntityBee.this.hasHive() && EntityBee.this.canEnterHive() && EntityBee.this.hivePos.isWithinDistance(new BlockPos((Entity)EntityBee.this), 2.0) && (tileentity = EntityBee.this.getHivePos().getTileEntity(EntityBee.this.field_70170_p)) instanceof TileEntityBeeHive) {
                TileEntityBeeHive beehivetileentity = (TileEntityBeeHive)tileentity;
                if (!beehivetileentity.isFullOfBees()) {
                    return true;
                }
                EntityBee.this.hivePos = null;
            }
            return false;
        }

        @Override
        public boolean canBeeContinue() {
            return false;
        }

        public void func_75249_e() {
            TileEntity tileentity = EntityBee.this.getHivePos().getTileEntity(EntityBee.this.field_70170_p);
            if (tileentity instanceof TileEntityBeeHive) {
                TileEntityBeeHive beehivetileentity = (TileEntityBeeHive)tileentity;
                beehivetileentity.tryEnterHive((Entity)EntityBee.this, EntityBee.this.hasNectar());
            }
        }
    }

    class TemptBeeWithFlowerGoal
    extends EntityAITempt {
        public TemptBeeWithFlowerGoal(EntityCreature p_i45316_1_, double p_i45316_2_, boolean p_i45316_5_) {
            super(p_i45316_1_, p_i45316_2_, null, p_i45316_5_);
        }

        public boolean func_75250_a() {
            if (this.field_75290_i > 0) {
                --this.field_75290_i;
                return false;
            }
            this.field_75289_h = this.field_75284_a.field_70170_p.func_72890_a((Entity)this.field_75284_a, EntityBee.this.func_110148_a(EtFuturumEntityAttributes.flyingSpeed).func_111126_e());
            if (this.field_75289_h == null) {
                return false;
            }
            ItemStack itemstack = this.field_75289_h.func_71045_bC();
            return itemstack != null && EntityBee.this.isBreedingFlower(Block.func_149634_a((Item)itemstack.func_77973_b()), itemstack.func_77960_j());
        }
    }

    class UpdateBeehiveGoal
    extends PassiveGoal {
        private UpdateBeehiveGoal() {
        }

        @Override
        public boolean canBeeStart() {
            return EntityBee.this.remainingCooldownBeforeLocatingNewHive == 0 && !EntityBee.this.hasHive() && EntityBee.this.canEnterHive();
        }

        @Override
        public boolean canBeeContinue() {
            return false;
        }

        public void func_75249_e() {
            EntityBee.this.remainingCooldownBeforeLocatingNewHive = 200;
            List list = EntityBee.this.getBlocksInRange(x$0 -> EntityBee.this.doesHiveHaveSpace(x$0), 20, false);
            if (!list.isEmpty()) {
                for (BlockPos blockpos : list) {
                    if (EntityBee.this.findBeehiveGoal.isPossibleHive(blockpos)) continue;
                    EntityBee.this.hivePos = blockpos;
                    return;
                }
                EntityBee.this.findBeehiveGoal.clearPossibleHives();
                EntityBee.this.hivePos = (BlockPos)list.get(0);
            }
        }
    }

    public class FindFlowerGoal
    extends PassiveGoal {
        private int ticks;

        FindFlowerGoal() {
            this.ticks = EntityBee.this.field_70170_p.field_73012_v.nextInt(10);
            this.func_75248_a(0);
        }

        @Override
        public boolean canBeeStart() {
            return EntityBee.this.savedFlowerPos != null && !EntityBee.this.func_110175_bO() && this.shouldMoveToFlower() && EntityBee.isValidFlower(EntityBee.this.field_70170_p, EntityBee.this.savedFlowerPos.getX(), EntityBee.this.savedFlowerPos.getY(), EntityBee.this.savedFlowerPos.getZ()) && !EntityBee.this.isWithinDistance(EntityBee.this.savedFlowerPos, 2);
        }

        @Override
        public boolean canBeeContinue() {
            return this.canBeeStart();
        }

        public void func_75249_e() {
            this.ticks = 0;
            super.func_75249_e();
        }

        public void func_75251_c() {
            this.ticks = 0;
            EntityBee.this.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            if (EntityBee.this.savedFlowerPos != null) {
                ++this.ticks;
                if (this.ticks > 600) {
                    EntityBee.this.savedFlowerPos = null;
                } else if (EntityBee.this.func_70661_as().func_75500_f()) {
                    if (EntityBee.this.isTooFar(EntityBee.this.savedFlowerPos)) {
                        EntityBee.this.savedFlowerPos = null;
                    } else {
                        EntityBee.this.startMovingTo(EntityBee.this.savedFlowerPos);
                    }
                }
            }
        }

        private boolean shouldMoveToFlower() {
            return EntityBee.this.ticksWithoutNectarSinceExitingHive > 2400;
        }
    }

    class FindPollinationTargetGoal
    extends PassiveGoal {
        private FindPollinationTargetGoal() {
        }

        @Override
        public boolean canBeeStart() {
            if (EntityBee.this.getCropsGrownSincePollination() >= 10) {
                return false;
            }
            if (EntityBee.this.field_70146_Z.nextFloat() < 0.3f) {
                return false;
            }
            return EntityBee.this.hasNectar() && EntityBee.this.isHiveValid();
        }

        @Override
        public boolean canBeeContinue() {
            return this.canBeeStart();
        }

        public void func_75246_d() {
            if (EntityBee.this.field_70146_Z.nextInt(30) == 0) {
                for (int i = 1; i <= 2; ++i) {
                    int x = (int)EntityBee.this.field_70165_t;
                    int y = (int)EntityBee.this.field_70163_u - i;
                    int z = (int)EntityBee.this.field_70161_v;
                    Block block = EntityBee.this.field_70170_p.func_147439_a(x, y, z);
                    if (!BeePlantRegistry.isCrop(block) || !((IGrowable)block).func_149851_a(EntityBee.this.field_70170_p, x, y, z, false) || !((IGrowable)block).func_149852_a(EntityBee.this.field_70170_p, EntityBee.this.field_70170_p.field_73012_v, x, y, z)) continue;
                    EntityBee.this.field_70170_p.func_72921_c(x, y, z, EntityBee.this.field_70170_p.func_72805_g(x, y, z) + 1, 2);
                    EntityBee.this.addCropCounter();
                }
            }
        }
    }

    class WanderGoal
    extends EntityAIBase {
        WanderGoal() {
            this.func_75248_a(0);
        }

        public boolean func_75250_a() {
            return EntityBee.this.func_70661_as().func_75500_f() && EntityBee.this.field_70146_Z.nextInt(10) == 0;
        }

        public boolean func_75253_b() {
            return !EntityBee.this.func_70661_as().func_75500_f();
        }

        public void func_75249_e() {
            Vec3 vec3d = this.getRandomLocation();
            if (vec3d != null) {
                EntityBee.this.func_70661_as().func_75484_a(EntityBee.this.func_70661_as().func_75488_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c), 1.0);
            }
        }

        @Nullable
        private Vec3 getRandomLocation() {
            Vec3 vec3d;
            if (EntityBee.this.isHiveValid() && !EntityBee.this.isWithinDistance(EntityBee.this.hivePos, 40)) {
                Vec3 vec3d1 = EntityBee.this.hivePos.newVec3();
                vec3d = vec3d1.func_72444_a(Utils.getVec3FromEntity((Entity)EntityBee.this, 1.0f)).func_72432_b();
            } else {
                vec3d = EntityBee.this.func_70676_i(0.0f);
            }
            Vec3 vec3d2 = EntityVectorUtils.findAirTarget((EntityCreature)EntityBee.this, 8, 7, vec3d, 1.5707964f, 2, 1);
            return vec3d2 != null ? vec3d2 : EntityVectorUtils.findGroundTarget((EntityCreature)EntityBee.this, 8, 4, -2, vec3d, 1.5707963705062866);
        }
    }

    class AngerGoal
    extends EntityAIHurtByTarget {
        AngerGoal(EntityBee beeIn) {
            super((EntityCreature)beeIn, true);
        }

        protected boolean func_75296_a(EntityLivingBase targetIn, boolean p_75296_2_) {
            if (targetIn != null && this.field_75299_d.func_70685_l((Entity)targetIn) && (!(targetIn instanceof EntityPlayer) || !((EntityPlayer)targetIn).field_71075_bZ.field_75098_d) && ((EntityBee)this.field_75299_d).setBeeAttacker((Entity)targetIn)) {
                this.field_75299_d.func_70624_b(targetIn);
                return true;
            }
            return false;
        }
    }

    static class AttackPlayerGoal
    extends EntityAINearestAttackableTarget {
        AttackPlayerGoal(EntityBee beeIn) {
            super((EntityCreature)beeIn, EntityPlayer.class, 10, true);
        }

        public boolean func_75250_a() {
            return this.canSting() && super.func_75250_a();
        }

        public boolean func_75253_b() {
            boolean flag = this.canSting();
            if (flag && this.field_75299_d.func_70638_az() != null) {
                return super.func_75253_b();
            }
            this.field_75309_a = null;
            return false;
        }

        private boolean canSting() {
            EntityBee beeentity = (EntityBee)this.field_75299_d;
            return beeentity.isAngry() && !beeentity.hasStung();
        }
    }

    abstract class PassiveGoal
    extends EntityAIBase {
        private PassiveGoal() {
        }

        public abstract boolean canBeeStart();

        public abstract boolean canBeeContinue();

        public boolean func_75250_a() {
            return this.canBeeStart() && !EntityBee.this.isAngry();
        }

        public boolean func_75253_b() {
            return this.canBeeContinue() && !EntityBee.this.isAngry();
        }
    }
}

