/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.utils;

import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.core.utils.helpers.BlockPos;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.util.Vec3;

public class EntityVectorUtils {
    private static ToDoubleFunction<BlockPos> getDoubleFunc(EntityCreature entity) {
        return pos -> entity.func_70783_a(pos.getX(), pos.getY(), pos.getZ());
    }

    @Nullable
    public static Vec3 findRandomTarget(EntityCreature entitycreatureIn, int xz, int y) {
        return EntityVectorUtils.func_226339_a_(entitycreatureIn, xz, y, 0, null, true, 1.5707963705062866, EntityVectorUtils.getDoubleFunc(entitycreatureIn), false, 0, 0, true);
    }

    @Nullable
    public static Vec3 findGroundTarget(EntityCreature p_226338_0_, int p_226338_1_, int p_226338_2_, int p_226338_3_, Vec3 p_226338_4_, double p_226338_5_) {
        return EntityVectorUtils.func_226339_a_(p_226338_0_, p_226338_1_, p_226338_2_, p_226338_3_, p_226338_4_, true, p_226338_5_, EntityVectorUtils.getDoubleFunc(p_226338_0_), true, 0, 0, false);
    }

    @Nullable
    public static Vec3 getLandPos(EntityCreature creature, int maxXZ, int maxY) {
        return EntityVectorUtils.func_221024_a(creature, maxXZ, maxY, EntityVectorUtils.getDoubleFunc(creature));
    }

    @Nullable
    public static Vec3 func_221024_a(EntityCreature p_221024_0_, int p_221024_1_, int p_221024_2_, ToDoubleFunction<BlockPos> p_221024_3_) {
        return EntityVectorUtils.func_226339_a_(p_221024_0_, p_221024_1_, p_221024_2_, 0, null, false, 0.0, p_221024_3_, true, 0, 0, true);
    }

    @Nullable
    public static Vec3 findAirTarget(EntityCreature p_226340_0_, int p_226340_1_, int p_226340_2_, Vec3 p_226340_3_, float p_226340_4_, int p_226340_5_, int p_226340_6_) {
        return EntityVectorUtils.func_226339_a_(p_226340_0_, p_226340_1_, p_226340_2_, 0, p_226340_3_, false, p_226340_4_, EntityVectorUtils.getDoubleFunc(p_226340_0_), true, p_226340_5_, p_226340_6_, true);
    }

    @Nullable
    public static Vec3 findRandomTargetBlockTowards(EntityCreature entitycreatureIn, int xz, int y, Vec3 targetVec3) {
        Vec3 vec3d = targetVec3.func_72444_a(Utils.getVec3FromEntity((Entity)entitycreatureIn, 1.0f));
        return EntityVectorUtils.func_226339_a_(entitycreatureIn, xz, y, 0, vec3d, true, 1.5707963705062866, EntityVectorUtils.getDoubleFunc(entitycreatureIn), false, 0, 0, true);
    }

    @Nullable
    public static Vec3 findRandomTargetTowardsScaled(EntityCreature p_203155_0_, int xz, int p_203155_2_, Vec3 p_203155_3_, double p_203155_4_) {
        Vec3 vec3d = p_203155_3_.func_72444_a(Utils.getVec3FromEntity((Entity)p_203155_0_, 1.0f));
        return EntityVectorUtils.func_226339_a_(p_203155_0_, xz, p_203155_2_, 0, vec3d, true, p_203155_4_, EntityVectorUtils.getDoubleFunc(p_203155_0_), false, 0, 0, true);
    }

    @Nullable
    public static Vec3 func_226344_b_(EntityCreature p_226344_0_, int p_226344_1_, int p_226344_2_, int p_226344_3_, Vec3 p_226344_4_, double p_226344_5_) {
        Vec3 vec3d = p_226344_4_.func_72444_a(Utils.getVec3FromEntity((Entity)p_226344_0_, 1.0f));
        return EntityVectorUtils.func_226339_a_(p_226344_0_, p_226344_1_, p_226344_2_, p_226344_3_, vec3d, false, p_226344_5_, EntityVectorUtils.getDoubleFunc(p_226344_0_), true, 0, 0, false);
    }

    @Nullable
    public static Vec3 findRandomTargetBlockAwayFrom(EntityCreature entitycreatureIn, int xz, int y, Vec3 targetVec3) {
        Vec3 vec3d = Utils.getVec3FromEntity((Entity)entitycreatureIn, 1.0f).func_72444_a(targetVec3);
        return EntityVectorUtils.func_226339_a_(entitycreatureIn, xz, y, 0, vec3d, true, 1.5707963705062866, EntityVectorUtils.getDoubleFunc(entitycreatureIn), false, 0, 0, true);
    }

    @Nullable
    public static Vec3 func_223548_b(EntityCreature p_223548_0_, int p_223548_1_, int p_223548_2_, Vec3 p_223548_3_) {
        Vec3 vec3d = Utils.getVec3FromEntity((Entity)p_223548_0_, 1.0f).func_72444_a(p_223548_3_);
        return EntityVectorUtils.func_226339_a_(p_223548_0_, p_223548_1_, p_223548_2_, 0, vec3d, false, 1.5707963705062866, EntityVectorUtils.getDoubleFunc(p_223548_0_), true, 0, 0, true);
    }

    @Nullable
    private static Vec3 func_226339_a_(EntityCreature p_226339_0_, int p_226339_1_, int p_226339_2_, int p_226339_3_, Vec3 p_226339_4_, boolean p_226339_5_, double p_226339_6_, ToDoubleFunction<BlockPos> p_226339_8_, boolean p_226339_9_, int p_226339_10_, int p_226339_11_, boolean p_226339_12_) {
        boolean flag;
        Random random = p_226339_0_.func_70681_au();
        if (p_226339_0_.func_110175_bO()) {
            double distCompare = (double)(p_226339_0_.func_110174_bM() + (float)p_226339_1_) + 1.0;
            Vec3 vec = Vec3.func_72443_a((double)p_226339_0_.func_110172_bL().field_71574_a, (double)p_226339_0_.func_110172_bL().field_71572_b, (double)p_226339_0_.func_110172_bL().field_71573_c);
            flag = Utils.getVec3FromEntity((Entity)p_226339_0_, 1.0f).func_72436_e(vec) < distCompare * distCompare;
        } else {
            flag = false;
        }
        boolean flag1 = false;
        double d0 = Double.NEGATIVE_INFINITY;
        BlockPos blockpos = new BlockPos((Entity)p_226339_0_);
        for (int i = 0; i < 10; ++i) {
            double d1;
            BlockPos blockpos3;
            BlockPos blockpos1 = EntityVectorUtils.func_226343_a_(random, p_226339_1_, p_226339_2_, p_226339_3_, p_226339_4_, p_226339_6_);
            if (blockpos1 == null) continue;
            int j = blockpos1.getX();
            int k = blockpos1.getY();
            int l = blockpos1.getZ();
            if (p_226339_0_.func_110175_bO() && p_226339_1_ > 1) {
                BlockPos blockpos2 = new BlockPos(p_226339_0_.func_110172_bL());
                j = p_226339_0_.field_70165_t > (double)blockpos2.getX() ? (j -= random.nextInt(p_226339_1_ / 2)) : (j += random.nextInt(p_226339_1_ / 2));
                l = p_226339_0_.field_70161_v > (double)blockpos2.getZ() ? (l -= random.nextInt(p_226339_1_ / 2)) : (l += random.nextInt(p_226339_1_ / 2));
            }
            if ((blockpos3 = new BlockPos((double)j + p_226339_0_.field_70165_t, (double)k + p_226339_0_.field_70163_u, (double)l + p_226339_0_.field_70161_v)).getY() < 0 || blockpos3.getY() > p_226339_0_.field_70170_p.func_72800_K() || flag && !p_226339_0_.func_110176_b(blockpos3.getX(), blockpos3.getY(), blockpos3.getZ()) || p_226339_12_ && !(EntityVectorUtils.getDoubleFunc(p_226339_0_).applyAsDouble(blockpos3) > 0.0)) continue;
            if (p_226339_9_) {
                blockpos3 = EntityVectorUtils.func_226342_a_(blockpos3, random.nextInt(p_226339_10_ + 1) + p_226339_11_, p_226339_0_.field_70170_p.func_72800_K(), p_226341_1_ -> p_226341_1_.getBlock(p_226339_0_.field_70170_p).func_149688_o().func_76220_a());
            }
            if (!p_226339_5_ && blockpos3.getBlock(p_226339_0_.field_70170_p).func_149688_o() == Material.field_151586_h || !((d1 = p_226339_8_.applyAsDouble(blockpos3)) > d0)) continue;
            d0 = d1;
            blockpos = blockpos3;
            flag1 = true;
        }
        return flag1 ? blockpos.newVec3() : null;
    }

    @Nullable
    private static BlockPos func_226343_a_(Random p_226343_0_, int p_226343_1_, int p_226343_2_, int p_226343_3_, Vec3 p_226343_4_, double p_226343_5_) {
        if (p_226343_4_ != null && !(p_226343_5_ >= Math.PI)) {
            double d3 = Utils.atan2(p_226343_4_.field_72449_c, p_226343_4_.field_72450_a) - 1.5707963705062866;
            double d4 = d3 + (double)(2.0f * p_226343_0_.nextFloat() - 1.0f) * p_226343_5_;
            double d0 = Math.sqrt(p_226343_0_.nextDouble()) * (double)Utils.SQRT_2 * (double)p_226343_1_;
            double d1 = -d0 * Math.sin(d4);
            double d2 = d0 * Math.cos(d4);
            if (!(Math.abs(d1) > (double)p_226343_1_) && !(Math.abs(d2) > (double)p_226343_1_)) {
                int l = p_226343_0_.nextInt(2 * p_226343_2_ + 1) - p_226343_2_ + p_226343_3_;
                return new BlockPos(d1, (double)l, d2);
            }
            return null;
        }
        int i = p_226343_0_.nextInt(2 * p_226343_1_ + 1) - p_226343_1_;
        int j = p_226343_0_.nextInt(2 * p_226343_2_ + 1) - p_226343_2_ + p_226343_3_;
        int k = p_226343_0_.nextInt(2 * p_226343_1_ + 1) - p_226343_1_;
        return new BlockPos(i, j, k);
    }

    static BlockPos func_226342_a_(BlockPos p_226342_0_, int p_226342_1_, int p_226342_2_, Predicate<BlockPos> p_226342_3_) {
        BlockPos blockpos2;
        if (p_226342_1_ < 0) {
            throw new IllegalArgumentException("aboveSolidAmount was " + p_226342_1_ + ", expected >= 0");
        }
        if (!p_226342_3_.test(p_226342_0_)) {
            return p_226342_0_;
        }
        BlockPos blockpos = p_226342_0_.up();
        while (blockpos.getY() < p_226342_2_ && p_226342_3_.test(blockpos)) {
            blockpos = blockpos.up();
        }
        BlockPos blockpos1 = blockpos;
        while (blockpos1.getY() < p_226342_2_ && blockpos1.getY() - blockpos.getY() < p_226342_1_ && !p_226342_3_.test(blockpos2 = blockpos1.up())) {
            blockpos1 = blockpos2;
        }
        return blockpos1;
    }
}

