/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks.rawore.modded;

import com.google.common.collect.Lists;
import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.blocks.BaseSubtypesBlock;
import ganymedes01.etfuturum.core.utils.DummyWorld;
import ganymedes01.etfuturum.core.utils.IInitAction;
import ganymedes01.etfuturum.core.utils.Utils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class BlockGeneralModdedRawOre
extends BaseSubtypesBlock
implements IInitAction {
    public final String[] ores;
    private final float[] hardnesses;
    private final float[] resistances;
    public static final List<BlockGeneralModdedRawOre> loaded = Lists.newLinkedList();

    public BlockGeneralModdedRawOre(String ... names) {
        super(Material.field_151576_e, names);
        this.ores = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            this.ores[i] = "block" + StringUtils.capitalize((String)names[i].replaceFirst("^raw_", "").replace("_block", ""));
        }
        this.hardnesses = new float[this.ores.length];
        this.resistances = new float[this.ores.length];
        this.setNames("modded_raw_ore");
        this.func_149711_c(5.0f);
        this.func_149752_b(6.0f);
        this.setHarvestLevel("pickaxe", 1);
    }

    @Override
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        ModItems.MODDED_RAW_ORE.get().func_150895_a(item, tab, list);
    }

    @Override
    public String getTextureDomain() {
        return "etfuturum";
    }

    @Override
    public float func_149712_f(World world, int x, int y, int z) {
        return this.hardnesses[Math.min(world.func_72805_g(x, y, z), this.hardnesses.length - 1)];
    }

    @Override
    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return this.resistances[Math.min(world.func_72805_g(x, y, z), this.resistances.length - 1)];
    }

    @Override
    public void postInitAction() {
        loaded.add(this);
    }

    @Override
    public void onLoadAction() {
        DummyWorld world = DummyWorld.GLOBAL_DUMMY_WORLD;
        for (int i = 0; i < this.ores.length; ++i) {
            ItemStack stack = Utils.getFirstBlockFromTag(this.ores[i], new ItemStack(Blocks.field_150339_S));
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            world.func_147465_d(0, 0, 0, block, stack.func_77960_j(), 0);
            try {
                if (block.getHarvestTool(stack.func_77960_j()) != null) {
                    this.setHarvestLevel("pickaxe", block.getHarvestLevel(stack.func_77960_j()), i);
                }
                this.hardnesses[i] = block.func_149712_f((World)world, 0, 0, 0);
                this.resistances[i] = block.getExplosionResistance(null, (World)world, 0, 0, 0, 0.0, 0.0, 0.0) * 5.0f;
                continue;
            }
            catch (Exception e) {
                this.setHarvestLevel("pickaxe", 1, i);
                this.hardnesses[i] = Blocks.field_150339_S.field_149782_v;
                this.resistances[i] = Blocks.field_150339_S.field_149781_w;
            }
        }
        world.clearBlocksCache();
    }
}

