/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.api;

import cpw.mods.fml.common.registry.GameRegistry;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.api.mappings.RegistryMapping;
import ganymedes01.etfuturum.client.sound.ModSounds;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigModCompat;
import ganymedes01.etfuturum.core.utils.Logger;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.recipes.ModRecipes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.oredict.OreDictionary;

public class DeepslateOreRegistry {
    private static final Map<RegistryMapping<Block>, RegistryMapping<Block>> deepslateOres = new HashMap<RegistryMapping<Block>, RegistryMapping<Block>>();

    public static void addOre(Block from, Block to) {
        DeepslateOreRegistry.addOre(from, 0, to, 0);
    }

    public static void addOre(Block from, int fromMeta, Block to, int toMeta) {
        DeepslateOreRegistry.addOre(from, fromMeta, to, toMeta, false);
    }

    public static void addOre(Block from, int fromMeta, Block to, int toMeta, boolean putIfAbsent) {
        if (from.hasTileEntity(fromMeta) || to.hasTileEntity(toMeta)) {
            throw new IllegalArgumentException("Block Entities are not supported for the deepslate ore registry!");
        }
        if (!Utils.isMetaInBlockBoundsIgnoreWildcard(fromMeta) || !Utils.isMetaInBlockBoundsIgnoreWildcard(toMeta)) {
            throw new IllegalArgumentException("Meta must be between " + Utils.getMinMetadata() + " and " + Utils.getMaxMetadata() + " (inclusive).");
        }
        if (putIfAbsent) {
            deepslateOres.putIfAbsent(new RegistryMapping<Block>(from, fromMeta), new RegistryMapping<Block>(to, toMeta));
        } else {
            deepslateOres.put(new RegistryMapping<Block>(from, fromMeta), new RegistryMapping<Block>(to, toMeta));
        }
    }

    public static void addOreByOreDict(String oreDict, Block to, int toMeta) {
        boolean hasBadEntry = false;
        if (to == ModBlocks.MODDED_DEEPSLATE_ORE.get() && ConfigModCompat.moddedDeepslateOresBlacklist.contains(oreDict)) {
            return;
        }
        for (ItemStack ore : OreDictionary.getOres((String)oreDict)) {
            Block blockToAdd = Block.func_149634_a((Item)ore.func_77973_b());
            if (blockToAdd == to || !ModRecipes.validateItems(blockToAdd, to)) continue;
            try {
                DeepslateOreRegistry.addOre(blockToAdd, ore.func_77960_j(), to, toMeta, true);
            }
            catch (IllegalArgumentException e) {
                hasBadEntry = true;
            }
        }
        if (hasBadEntry) {
            Logger.warn(oreDict + " had one ore more entries which are either block entities or supplying a meta outside of " + Utils.getMinMetadata() + "-" + Utils.getMaxMetadata() + ". Check the contents of the OreDict tag for more info.");
            Logger.warn("Ignoring those entries instead of crashing, since this could be an unintended side effect of adding by OreDict string.");
        }
    }

    public static void addOreByOreDict(String oreDict, Block to) {
        DeepslateOreRegistry.addOreByOreDict(oreDict, to, 0);
    }

    public static boolean hasOre(Block block) {
        return DeepslateOreRegistry.hasOre(block, 0);
    }

    public static boolean hasOre(Block block, int meta) {
        return DeepslateOreRegistry.getOre(block, meta) != null;
    }

    public static RegistryMapping<Block> getOre(Block block) {
        return DeepslateOreRegistry.getOre(block, 0);
    }

    public static RegistryMapping<Block> getOre(Block block, int meta) {
        return deepslateOres.get(RegistryMapping.getKeyFor(block, meta));
    }

    public static Map<RegistryMapping<Block>, RegistryMapping<Block>> getOreMap() {
        return deepslateOres;
    }

    public static void init() {
        if (ConfigBlocksItems.enableDeepslateOres) {
            for (Map.Entry<RegistryMapping<Block>, RegistryMapping<Block>> entry : DeepslateOreRegistry.getOreMap().entrySet()) {
                Block oreNorm = entry.getKey().getObject();
                Block oreDeep = entry.getValue().getObject();
                boolean saltyModOre = oreDeep.getClass().getName().toLowerCase().contains("saltymod");
                if (oreDeep.field_149762_H == Block.field_149769_e || saltyModOre) {
                    Utils.setBlockSound(oreDeep, ModSounds.soundDeepslate);
                }
                ItemStack stackNorm = new ItemStack(oreNorm, 1, entry.getKey().getMeta());
                ItemStack stackDeep = new ItemStack(oreDeep, 1, entry.getValue().getMeta());
                if (FurnaceRecipes.func_77602_a().func_151395_a(stackNorm) == null) continue;
                GameRegistry.addSmelting((ItemStack)stackDeep, (ItemStack)FurnaceRecipes.func_77602_a().func_151395_a(stackNorm), (float)FurnaceRecipes.func_77602_a().func_151398_b(stackNorm));
            }
        }
    }
}

