/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.asm;

import codechicken.lib.asm.InsnListSection;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class InsnComparator {
    public static boolean varInsnEqual(VarInsnNode insn1, VarInsnNode insn2) {
        return insn1.var == -1 || insn2.var == -1 || insn1.var == insn2.var;
    }

    public static boolean methodInsnEqual(MethodInsnNode insn1, MethodInsnNode insn2) {
        return insn1.owner.equals(insn2.owner) && insn1.name.equals(insn2.name) && insn1.desc.equals(insn2.desc);
    }

    public static boolean fieldInsnEqual(FieldInsnNode insn1, FieldInsnNode insn2) {
        return insn1.owner.equals(insn2.owner) && insn1.name.equals(insn2.name) && insn1.desc.equals(insn2.desc);
    }

    public static boolean ldcInsnEqual(LdcInsnNode insn1, LdcInsnNode insn2) {
        return insn1.cst == null || insn2.cst == null || insn1.cst.equals(insn2.cst);
    }

    public static boolean typeInsnEqual(TypeInsnNode insn1, TypeInsnNode insn2) {
        return insn1.desc.equals("*") || insn2.desc.equals("*") || insn1.desc.equals(insn2.desc);
    }

    public static boolean iincInsnEqual(IincInsnNode node1, IincInsnNode node2) {
        return node1.var == node2.var && node1.incr == node2.incr;
    }

    public static boolean intInsnEqual(IntInsnNode node1, IntInsnNode node2) {
        return node1.operand == -1 || node2.operand == -1 || node1.operand == node2.operand;
    }

    public static boolean insnEqual(AbstractInsnNode node1, AbstractInsnNode node2) {
        if (node1.getOpcode() != node2.getOpcode()) {
            return false;
        }
        switch (node2.getType()) {
            case 2: {
                return InsnComparator.varInsnEqual((VarInsnNode)node1, (VarInsnNode)node2);
            }
            case 3: {
                return InsnComparator.typeInsnEqual((TypeInsnNode)node1, (TypeInsnNode)node2);
            }
            case 4: {
                return InsnComparator.fieldInsnEqual((FieldInsnNode)node1, (FieldInsnNode)node2);
            }
            case 5: {
                return InsnComparator.methodInsnEqual((MethodInsnNode)node1, (MethodInsnNode)node2);
            }
            case 9: {
                return InsnComparator.ldcInsnEqual((LdcInsnNode)node1, (LdcInsnNode)node2);
            }
            case 10: {
                return InsnComparator.iincInsnEqual((IincInsnNode)node1, (IincInsnNode)node2);
            }
            case 1: {
                return InsnComparator.intInsnEqual((IntInsnNode)node1, (IntInsnNode)node2);
            }
        }
        return true;
    }

    public static boolean insnImportant(AbstractInsnNode insn, Set<LabelNode> controlFlowLabels) {
        switch (insn.getType()) {
            case 14: 
            case 15: {
                return false;
            }
            case 8: {
                return controlFlowLabels.contains(insn);
            }
        }
        return true;
    }

    public static Set<LabelNode> getControlFlowLabels(InsnListSection list) {
        return InsnComparator.getControlFlowLabels(list.list);
    }

    public static Set<LabelNode> getControlFlowLabels(InsnList list) {
        HashSet<LabelNode> controlFlowLabels = new HashSet<LabelNode>();
        block5: for (AbstractInsnNode insn = list.getFirst(); insn != null; insn = insn.getNext()) {
            switch (insn.getType()) {
                case 7: {
                    JumpInsnNode jinsn = (JumpInsnNode)insn;
                    controlFlowLabels.add(jinsn.label);
                    continue block5;
                }
                case 11: {
                    TableSwitchInsnNode tsinsn = (TableSwitchInsnNode)insn;
                    controlFlowLabels.add(tsinsn.dflt);
                    for (LabelNode label : tsinsn.labels) {
                        controlFlowLabels.add(label);
                    }
                    continue block5;
                }
                case 12: {
                    LookupSwitchInsnNode lsinsn = (LookupSwitchInsnNode)insn;
                    controlFlowLabels.add(lsinsn.dflt);
                    for (LabelNode label : lsinsn.labels) {
                        controlFlowLabels.add(label);
                    }
                    continue block5;
                }
            }
        }
        return controlFlowLabels;
    }

    public static InsnList getImportantList(InsnList list) {
        return InsnComparator.getImportantList((InsnListSection)new InsnListSection((InsnList)list)).list;
    }

    public static InsnListSection getImportantList(InsnListSection list) {
        if (list.size() == 0) {
            return list;
        }
        Set<LabelNode> controlFlowLabels = InsnComparator.getControlFlowLabels(list);
        Map labelMap = Maps.asMap(controlFlowLabels, (Function)new Function<LabelNode, LabelNode>(){

            public LabelNode apply(LabelNode input) {
                return input;
            }
        });
        InsnListSection importantNodeList = new InsnListSection();
        for (AbstractInsnNode insn : list) {
            if (!InsnComparator.insnImportant(insn, controlFlowLabels)) continue;
            importantNodeList.add(insn.clone(labelMap));
        }
        return importantNodeList;
    }

    public static List<InsnListSection> find(InsnListSection haystack, InsnListSection needle) {
        Set<LabelNode> controlFlowLabels = InsnComparator.getControlFlowLabels(haystack);
        LinkedList<InsnListSection> list = new LinkedList<InsnListSection>();
        for (int start = 0; start <= haystack.size() - needle.size(); ++start) {
            InsnListSection section = InsnComparator.matches(haystack.drop(start), needle, controlFlowLabels);
            if (section == null) continue;
            list.add(section);
            start = section.end - 1;
        }
        return list;
    }

    public static List<InsnListSection> find(InsnList haystack, InsnListSection needle) {
        return InsnComparator.find(new InsnListSection(haystack), needle);
    }

    public static InsnListSection matches(InsnListSection haystack, InsnListSection needle, Set<LabelNode> controlFlowLabels) {
        int h;
        int n = 0;
        for (h = 0; h < haystack.size() && n < needle.size(); ++h) {
            AbstractInsnNode insn = haystack.get(h);
            if (!InsnComparator.insnImportant(insn, controlFlowLabels)) continue;
            if (!InsnComparator.insnEqual(haystack.get(h), needle.get(n))) {
                return null;
            }
            ++n;
        }
        if (n != needle.size()) {
            return null;
        }
        return haystack.take(h);
    }

    public static InsnListSection findOnce(InsnListSection haystack, InsnListSection needle) {
        List<InsnListSection> list = InsnComparator.find(haystack, needle);
        if (list.size() != 1) {
            throw new RuntimeException("Needle found " + list.size() + " times in Haystack:\n" + haystack + "\n\n" + needle);
        }
        return list.get(0);
    }

    public static InsnListSection findOnce(InsnList haystack, InsnListSection needle) {
        return InsnComparator.findOnce(new InsnListSection(haystack), needle);
    }

    public static List<InsnListSection> findN(InsnListSection haystack, InsnListSection needle) {
        List<InsnListSection> list = InsnComparator.find(haystack, needle);
        if (list.isEmpty()) {
            throw new RuntimeException("Needle not found in Haystack:\n" + haystack + "\n\n" + needle);
        }
        return list;
    }

    public static List<InsnListSection> findN(InsnList haystack, InsnListSection needle) {
        return InsnComparator.findN(new InsnListSection(haystack), needle);
    }
}

