/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.ItemPanels;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.RecipeHandlerQuery;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.recipe.stackinfo.GTFluidStackStringifyHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;

public class GuiUsageRecipe
extends GuiRecipe<IUsageHandler> {
    public static ArrayList<IUsageHandler> usagehandlers = new ArrayList();
    public static ArrayList<IUsageHandler> serialUsageHandlers = new ArrayList();
    private static Set<String> existingHandlers = new HashSet<String>();

    public static boolean openRecipeGui(String inputId, Object ... ingredients) {
        ArrayList<IUsageHandler> handlers;
        if ("item".equals(inputId)) {
            for (int i = 0; i < ingredients.length; ++i) {
                ingredients[i] = GuiUsageRecipe.normalizeItemStack((ItemStack)ingredients[i]);
            }
        }
        if (!(handlers = GuiUsageRecipe.getUsageHandlers(inputId, ingredients)).isEmpty()) {
            Object object;
            Minecraft mc = NEIClientUtils.mc();
            Recipe.RecipeId recipeId = GuiUsageRecipe.getCurrentRecipeId(mc.field_71462_r);
            GuiUsageRecipe gui = new GuiUsageRecipe(handlers);
            if (NEIClientConfig.showHistoryPanelWidget() && "item".equals(inputId) && (object = ingredients[0]) instanceof ItemStack) {
                ItemStack stack = (ItemStack)object;
                ItemPanels.itemPanel.historyPanel.addItem(stack);
            }
            mc.func_147108_a((GuiScreen)gui);
            gui.openTargetRecipe(recipeId);
            return true;
        }
        return false;
    }

    private GuiUsageRecipe(ArrayList<IUsageHandler> handlers) {
        super(NEIClientUtils.mc().field_71462_r);
        this.currenthandlers = handlers;
    }

    public static ArrayList<IUsageHandler> getUsageHandlers(String inputId, Object ... ingredients) {
        RecipeHandlerQuery<IUsageHandler> recipeQuery = new RecipeHandlerQuery<IUsageHandler>(h -> GuiUsageRecipe.getUsageOrCatalystHandler(h, inputId, ingredients), usagehandlers, serialUsageHandlers, "Error while looking up usage recipe", "inputId: " + inputId, "ingredients: " + Arrays.toString(ingredients));
        return recipeQuery.runWithProfiling(NEIClientUtils.translate("recipe.concurrent.usage", new Object[0]));
    }

    private static ItemStack normalizeItemStack(ItemStack stack) {
        GTFluidStackStringifyHandler.replaceAE2FCFluidDrop = true;
        stack = StackInfo.loadFromNBT(StackInfo.itemStackToNBT(stack));
        GTFluidStackStringifyHandler.replaceAE2FCFluidDrop = false;
        return stack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerUsageHandler(IUsageHandler handler) {
        String handlerId = handler.getHandlerId();
        if (existingHandlers.contains(handlerId)) {
            return;
        }
        Collection<Object> collection = existingHandlers;
        synchronized (collection) {
            existingHandlers.add(handlerId);
        }
        if (NEIClientConfig.serialHandlers.contains(handlerId)) {
            collection = serialUsageHandlers;
            synchronized (collection) {
                serialUsageHandlers.add(handler);
            }
        }
        collection = usagehandlers;
        synchronized (collection) {
            usagehandlers.add(handler);
        }
    }

    private static IUsageHandler getUsageOrCatalystHandler(IUsageHandler handler, String inputId, Object ... ingredients) {
        boolean skipCatalyst = NEIClientUtils.controlKey();
        if (NEIClientConfig.getJEIStyleRecipeCatalysts() != 0 && !skipCatalyst) {
            return handler.getUsageAndCatalystHandler(inputId, ingredients);
        }
        return handler.getUsageHandler(inputId, ingredients);
    }

    @Override
    public ArrayList<IUsageHandler> getCurrentRecipeHandlers() {
        return this.currenthandlers;
    }
}

