/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.Button;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemsGrid;
import codechicken.nei.Label;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIController;
import codechicken.nei.Widget;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.ShortcutInputHandler;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import java.awt.Point;
import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public abstract class PanelWidget<T extends ItemsGrid<? extends ItemsGrid.ItemsGridSlot, ? extends ItemsGrid.MouseContext>>
extends Widget {
    protected static final int PADDING = 2;
    public ItemStack draggedStack;
    public int mouseDownSlot = -1;
    public Button pagePrev;
    public Button pageNext;
    public Label pageLabel;
    protected T grid;

    public ArrayList<ItemStack> getItems() {
        return ((ItemsGrid)this.grid).getItems();
    }

    public T getGrid() {
        return this.grid;
    }

    public void init() {
        this.pageLabel = new Label("0/0", true);
        this.pagePrev = new Button("<"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (rightclick) {
                    ((ItemsGrid)PanelWidget.this.grid).setPage(0);
                } else {
                    ((ItemsGrid)PanelWidget.this.grid).shiftPage(-1);
                }
                return true;
            }

            @Override
            public void draw(int mousex, int mousey) {
                this.state = ((ItemsGrid)PanelWidget.this.grid).getNumPages() <= 1 ? 2 : 0;
                super.draw(mousex, mousey);
            }
        };
        this.pageNext = new Button(">"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (rightclick) {
                    ((ItemsGrid)PanelWidget.this.grid).setPage(((ItemsGrid)PanelWidget.this.grid).getNumPages() - 1);
                } else {
                    ((ItemsGrid)PanelWidget.this.grid).shiftPage(1);
                }
                return true;
            }

            @Override
            public void draw(int mousex, int mousey) {
                this.state = ((ItemsGrid)PanelWidget.this.grid).getNumPages() <= 1 ? 2 : 0;
                super.draw(mousex, mousey);
            }
        };
    }

    public abstract String getLabelText();

    public abstract Rectangle4i calculateBounds();

    public void resize(GuiContainer gui) {
        Rectangle4i bounds = this.calculateBounds();
        this.x = bounds.x;
        this.y = bounds.y;
        this.w = bounds.w;
        this.h = bounds.h;
        int header = this.resizeHeader(gui);
        int footer = this.resizeFooter(gui);
        ((ItemsGrid)this.grid).setGridSize(this.x, this.y + header, this.w, this.h - header - footer);
        ((ItemsGrid)this.grid).refresh(gui);
    }

    protected int resizeHeader(GuiContainer gui) {
        int paddingLeft;
        int BUTTON_SIZE = 16;
        int paddingRight = 0;
        for (paddingLeft = 0; paddingLeft < this.w && GuiInfo.hideItemPanelSlot(gui, new Rectangle4i(this.x + paddingLeft, this.y, ItemsGrid.SLOT_SIZE, ItemsGrid.SLOT_SIZE)); paddingLeft += ItemsGrid.SLOT_SIZE) {
        }
        while (paddingRight < this.w && GuiInfo.hideItemPanelSlot(gui, new Rectangle4i(this.x + this.w - paddingRight - ItemsGrid.SLOT_SIZE, this.y, ItemsGrid.SLOT_SIZE, ItemsGrid.SLOT_SIZE))) {
            paddingRight += ItemsGrid.SLOT_SIZE;
        }
        if (paddingLeft + paddingRight >= this.w) {
            return 0;
        }
        this.pageNext.w = 16;
        this.pagePrev.w = 16;
        this.pageNext.h = 16;
        this.pagePrev.h = 16;
        this.pagePrev.y = this.pageNext.y = this.y;
        this.pagePrev.x = this.x + paddingLeft;
        this.pageNext.x = this.x + this.w - this.pageNext.w - paddingRight;
        this.pageLabel.x = this.x + paddingLeft + (this.w - paddingLeft - paddingRight) / 2;
        this.pageLabel.y = this.y + 5;
        this.pageLabel.text = this.getLabelText();
        return 18;
    }

    protected abstract int resizeFooter(GuiContainer var1);

    public void setVisible() {
        if (((ItemsGrid)this.grid).getPerPage() > 0 && !((ItemsGrid)this.grid).isEmpty()) {
            LayoutManager.addWidget(this.pagePrev);
            LayoutManager.addWidget(this.pageNext);
            LayoutManager.addWidget(this.pageLabel);
        }
    }

    @Override
    public void update() {
        ((ItemsGrid)this.grid).update();
    }

    @Override
    public void draw(int mousex, int mousey) {
        ((ItemsGrid)this.grid).draw(mousex, mousey);
    }

    @Override
    public void postDraw(int mousex, int mousey) {
        if (this.draggedStack != null) {
            GuiContainerManager.drawItems.field_77023_b += 100.0f;
            GuiContainerManager.drawItem(mousex - 8, mousey - 8, this.draggedStack);
            GuiContainerManager.drawItems.field_77023_b -= 100.0f;
        }
    }

    @Override
    public void mouseDragged(int mousex, int mousey, int button, long heldTime) {
        Object mouseOverSlot;
        if (((ItemsGrid)this.grid).getSlotBySlotIndex(this.mouseDownSlot) == null) {
            this.mouseDownSlot = -1;
        }
        if (this.mouseDownSlot >= 0 && this.draggedStack == null && NEIClientUtils.getHeldItem() == null && NEIClientConfig.hasSMPCounterPart() && ((mouseOverSlot = ((ItemsGrid)this.grid).getSlotMouseOver(mousex, mousey)) == null || ((ItemsGrid.ItemsGridSlot)mouseOverSlot).slotIndex != this.mouseDownSlot || heldTime > 500L)) {
            this.draggedStack = this.getDraggedStackWithQuantity(((ItemsGrid.ItemsGridSlot)((ItemsGrid)this.grid).getSlotBySlotIndex(this.mouseDownSlot)).getItemStack());
            this.mouseDownSlot = -1;
        }
    }

    protected abstract ItemStack getDraggedStackWithQuantity(ItemStack var1);

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        if (this.handleClickExt(mousex, mousey, button)) {
            return true;
        }
        Object hoverSlot = ((ItemsGrid)this.grid).getSlotMouseOver(mousex, mousey);
        if (hoverSlot != null) {
            if (button == 2) {
                this.draggedStack = this.getDraggedStackWithQuantity(((ItemsGrid.ItemsGridSlot)hoverSlot).getItemStack());
            } else {
                this.mouseDownSlot = ((ItemsGrid.ItemsGridSlot)hoverSlot).slotIndex;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean handleClickExt(int mouseX, int mouseY, int button) {
        if (ItemPanels.itemPanel.draggedStack != null && ItemPanels.bookmarkPanel.contains(mouseX, mouseY)) {
            ItemPanels.bookmarkPanel.addItem(ItemPanels.itemPanel.draggedStack);
            ItemPanels.itemPanel.draggedStack = null;
            return true;
        }
        if (ItemPanels.itemPanel.draggedStack != null) {
            return ItemPanels.itemPanel.handleDraggedClick(mouseX, mouseY, button);
        }
        if (ItemPanels.bookmarkPanel.draggedStack != null) {
            return ItemPanels.bookmarkPanel.handleDraggedClick(mouseX, mouseY, button);
        }
        if (NEIClientUtils.getHeldItem() != null) {
            ItemStack draggedStack = NEIClientUtils.getHeldItem().func_77946_l();
            return this.handleGUIContainerClick(draggedStack, mouseX, mouseY, button);
        }
        return false;
    }

    protected boolean handleDraggedClick(int mouseX, int mouseY, int button) {
        if (this.draggedStack == null) {
            return false;
        }
        if (this.handleGUIContainerClick(this.draggedStack, mouseX, mouseY, button)) {
            if (this.draggedStack.field_77994_a == 0) {
                this.draggedStack = null;
            }
            return true;
        }
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        if (mouseX < gui.field_147003_i || mouseY < gui.field_147009_r || mouseX >= gui.field_147003_i + gui.field_146999_f || mouseY >= gui.field_147009_r + gui.field_147000_g) {
            this.draggedStack = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleGUIContainerClick(ItemStack draggedStack, int mouseX, int mouseY, int button) {
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        boolean handled = false;
        try {
            GuiInfo.readLock.lock();
            for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
                if (!handler.handleDragNDrop(gui, mouseX, mouseY, draggedStack, button)) continue;
                handled = true;
                break;
            }
        }
        finally {
            GuiInfo.readLock.unlock();
        }
        return handled;
    }

    @Override
    public void mouseUp(int mousex, int mousey, int button) {
        Object hoverSlot = ((ItemsGrid)this.grid).getSlotMouseOver(mousex, mousey);
        if (hoverSlot != null && ((ItemsGrid.ItemsGridSlot)hoverSlot).slotIndex == this.mouseDownSlot && this.draggedStack == null) {
            if (NEIController.manager.window instanceof GuiRecipe || NEIClientUtils.shiftKey() || !NEIClientConfig.canCheatItem(((ItemsGrid.ItemsGridSlot)hoverSlot).getItemStack())) {
                ShortcutInputHandler.handleMouseClick(((ItemsGrid.ItemsGridSlot)hoverSlot).getItemStack());
            } else {
                NEIClientUtils.cheatItem(this.getDraggedStackWithQuantity(((ItemsGrid.ItemsGridSlot)hoverSlot).getItemStack()), button, -1);
            }
        }
        this.mouseDownSlot = -1;
    }

    @Override
    public boolean onMouseWheel(int i, int mousex, int mousey) {
        if (!this.contains(mousex, mousey)) {
            return false;
        }
        ((ItemsGrid)this.grid).shiftPage(-i);
        return true;
    }

    @Override
    public boolean handleKeyPress(int keyID, char keyChar) {
        Point mouse = GuiDraw.getMousePosition();
        if (!this.contains(mouse.x, mouse.y)) {
            return false;
        }
        if (NEIClientConfig.isKeyHashDown("gui.next")) {
            ((ItemsGrid)this.grid).shiftPage(1);
            return true;
        }
        if (NEIClientConfig.isKeyHashDown("gui.prev")) {
            ((ItemsGrid)this.grid).shiftPage(-1);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getStackMouseOver(int mousex, int mousey) {
        Object slot = ((ItemsGrid)this.grid).getSlotMouseOver(mousex, mousey);
        return slot == null ? null : ((ItemsGrid.ItemsGridSlot)slot).getItemStack();
    }

    public ItemStack getStackMouseOverWithQuantity(int mousex, int mousey) {
        ItemStack hoverSlot = this.getStackMouseOver(mousex, mousey);
        return hoverSlot != null ? this.getDraggedStackWithQuantity(hoverSlot) : null;
    }

    abstract ItemsGrid.ItemsGridSlot getSlotMouseOver(int var1, int var2);

    public int getPage() {
        return ((ItemsGrid)this.grid).getPage();
    }

    public int getNumPages() {
        return ((ItemsGrid)this.grid).getNumPages();
    }

    @Override
    public boolean contains(int px, int py) {
        return ((ItemsGrid)this.grid).contains(px, py);
    }
}

