/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.feature;

import com.hbm.dim.WorldProviderCelestial;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;

public class OreLayer3D {
    public static int counter = 0;
    public int id;
    NoiseGeneratorPerlin noiseX;
    NoiseGeneratorPerlin noiseY;
    NoiseGeneratorPerlin noiseZ;
    double scaleH;
    double scaleV;
    double threshold;
    Block block;
    int meta;
    int dim = 0;
    boolean allCelestials = false;

    public OreLayer3D(Block block, int meta) {
        this.block = block;
        this.meta = meta;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.id = counter++;
    }

    public OreLayer3D setDimension(int dim) {
        this.dim = dim;
        return this;
    }

    public OreLayer3D setGlobal(boolean value) {
        this.allCelestials = value;
        return this;
    }

    public OreLayer3D setScaleH(double scale) {
        this.scaleH = scale;
        return this;
    }

    public OreLayer3D setScaleV(double scale) {
        this.scaleV = scale;
        return this;
    }

    public OreLayer3D setThreshold(double threshold) {
        this.threshold = threshold;
        return this;
    }

    @SubscribeEvent
    public void onDecorate(DecorateBiomeEvent.Pre event) {
        World world = event.world;
        if (world.field_73011_w == null) {
            return;
        }
        Block replace = Blocks.field_150348_b;
        if (world.field_73011_w instanceof WorldProviderCelestial) {
            replace = ((WorldProviderCelestial)world.field_73011_w).getStone();
        }
        if (this.allCelestials ? !(world.field_73011_w instanceof WorldProviderCelestial) && world.field_73011_w.field_76574_g != 0 : world.field_73011_w.field_76574_g != this.dim) {
            return;
        }
        if (this.noiseX == null) {
            this.noiseX = new NoiseGeneratorPerlin(new Random(event.world.func_72905_C() + 101L + (long)this.id), 4);
        }
        if (this.noiseY == null) {
            this.noiseY = new NoiseGeneratorPerlin(new Random(event.world.func_72905_C() + 102L + (long)this.id), 4);
        }
        if (this.noiseZ == null) {
            this.noiseZ = new NoiseGeneratorPerlin(new Random(event.world.func_72905_C() + 103L + (long)this.id), 4);
        }
        int cX = event.chunkX;
        int cZ = event.chunkZ;
        for (int x = cX + 8; x < cX + 24; ++x) {
            for (int z = cZ + 8; z < cZ + 24; ++z) {
                for (int y = 64; y > 5; --y) {
                    Block target;
                    double nZ;
                    double nY;
                    double nX = this.noiseX.func_151601_a((double)y * this.scaleV, (double)z * this.scaleH);
                    if (!(nX * (nY = this.noiseY.func_151601_a((double)x * this.scaleH, (double)z * this.scaleH)) * (nZ = this.noiseZ.func_151601_a((double)x * this.scaleH, (double)y * this.scaleV)) > this.threshold) || !(target = world.func_147439_a(x, y, z)).func_149721_r() || !target.isReplaceableOreGen(world, x, y, z, replace)) continue;
                    world.func_147465_d(x, y, z, this.block, this.meta, 2);
                }
            }
        }
    }
}

