/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import com.hbm.entity.item.EntityRequestDrone;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.container.ContainerDroneDock;
import com.hbm.inventory.gui.GUIDroneDock;
import com.hbm.items.ModItems;
import com.hbm.items.tool.ItemDrone;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.network.RequestNetwork;
import com.hbm.tileentity.network.TileEntityRequestNetworkContainer;
import com.hbm.util.HashedSet;
import com.hbm.util.fauxpointtwelve.BlockPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class TileEntityDroneDock
extends TileEntityRequestNetworkContainer
implements IGUIProvider {
    public static final int pathingDepth = 10;

    public TileEntityDroneDock() {
        super(9);
    }

    @Override
    public String getName() {
        return "container.droneDock";
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L && this.hasDrone()) {
            HashedSet<RequestNetwork.PathNode> localNodes = TileEntityDroneDock.getAllLocalNodes(this.field_145850_b, this.field_145851_c, this.field_145849_e, 5);
            ArrayList<RequestNetwork.RequestNode> requests = new ArrayList<RequestNetwork.RequestNode>();
            ArrayList<RequestNetwork.OfferNode> offers = new ArrayList<RequestNetwork.OfferNode>();
            for (RequestNetwork.PathNode local : localNodes) {
                if (local instanceof RequestNetwork.RequestNode) {
                    requests.add((RequestNetwork.RequestNode)local);
                }
                if (!(local instanceof RequestNetwork.OfferNode)) continue;
                offers.add((RequestNetwork.OfferNode)local);
            }
            block1: for (int i = 0; i < 5; ++i) {
                Collections.shuffle(requests);
                Collections.shuffle(offers);
                RequestNetwork.RequestNode firstRequest = null;
                for (RequestNetwork.RequestNode requestNode : requests) {
                    if (!requestNode.active || requestNode.request.isEmpty()) continue;
                    firstRequest = requestNode;
                    break;
                }
                if (firstRequest == null) continue;
                RequestNetwork.PathNode own = localNodes.getMap().get(new BlockPos(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e).hashCode());
                RecipesCommon.AStack aStack = firstRequest.request.get(this.field_145850_b.field_73012_v.nextInt(firstRequest.request.size()));
                for (RequestNetwork.OfferNode offer : offers) {
                    for (ItemStack stack : offer.offer) {
                        if (!offer.active || stack == null || !aStack.matchesRecipe(stack, true)) continue;
                        if (this.tryEmbark(own, firstRequest, offer, aStack, localNodes)) break block1;
                    }
                }
            }
        }
    }

    public boolean tryEmbark(RequestNetwork.PathNode dock, RequestNetwork.RequestNode request, RequestNetwork.OfferNode offer, RecipesCommon.AStack item, HashedSet localNodes) {
        List<RequestNetwork.PathNode> dockToOffer = this.generatePath(dock, offer, localNodes);
        if (dockToOffer == null) {
            return false;
        }
        List<RequestNetwork.PathNode> offerToRequest = this.generatePath(offer, request, localNodes);
        if (offerToRequest == null) {
            return false;
        }
        List<RequestNetwork.PathNode> requestToDock = this.generatePath(request, dock, localNodes);
        if (requestToDock == null) {
            return false;
        }
        for (int i = 0; i < this.slots.length; ++i) {
            ItemStack stack = this.slots[i];
            if (stack == null || stack.func_77973_b() != ModItems.drone || stack.func_77960_j() != ItemDrone.EnumDroneType.REQUEST.ordinal()) continue;
            this.func_70298_a(i, 1);
            break;
        }
        EntityRequestDrone drone = new EntityRequestDrone(this.field_145850_b);
        drone.func_70107_b((double)this.field_145851_c + 0.5, this.field_145848_d + 1, (double)this.field_145849_e + 0.5);
        for (RequestNetwork.PathNode node : dockToOffer) {
            drone.program.add(node.pos);
        }
        drone.program.add(offer.pos);
        drone.program.add(item);
        for (RequestNetwork.PathNode node : offerToRequest) {
            drone.program.add(node.pos);
        }
        drone.program.add(request.pos);
        drone.program.add(EntityRequestDrone.DroneProgram.UNLOAD);
        for (RequestNetwork.PathNode node : requestToDock) {
            drone.program.add(node.pos);
        }
        drone.program.add(dock.pos);
        drone.program.add(EntityRequestDrone.DroneProgram.DOCK);
        this.field_145850_b.func_72838_d((Entity)drone);
        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:block.storageOpen", 2.0f, 1.0f);
        return true;
    }

    public List<RequestNetwork.PathNode> generatePath(RequestNetwork.PathNode start, RequestNetwork.PathNode end, HashedSet<RequestNetwork.PathNode> localNodes) {
        ArrayList paths = new ArrayList();
        ArrayList<RequestNetwork.PathNode> init = new ArrayList<RequestNetwork.PathNode>();
        init.add(start);
        paths.add(init);
        for (int i = 0; i < 10; ++i) {
            ArrayList<ArrayList<RequestNetwork.PathNode>> newPaths = new ArrayList<ArrayList<RequestNetwork.PathNode>>();
            for (List list : paths) {
                for (RequestNetwork.PathNode connectedUnsafe : ((RequestNetwork.PathNode)list.get((int)(list.size() - 1))).reachableNodes) {
                    RequestNetwork.PathNode connectedSafe = localNodes.getMap().get(connectedUnsafe.hashCode());
                    if (connectedSafe == null) continue;
                    ArrayList<RequestNetwork.PathNode> newPath = new ArrayList<RequestNetwork.PathNode>();
                    newPath.addAll(list);
                    if (connectedSafe.hashCode() == end.hashCode()) {
                        newPath.remove(0);
                        return newPath;
                    }
                    newPath.add(connectedSafe);
                    newPaths.add(newPath);
                }
            }
            paths = newPaths;
        }
        return null;
    }

    public boolean hasDrone() {
        for (int i = 0; i < this.slots.length; ++i) {
            ItemStack stack = this.slots[i];
            if (stack == null || stack.func_77973_b() != ModItems.drone || stack.func_77960_j() != ItemDrone.EnumDroneType.REQUEST.ordinal()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerDroneDock(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIDroneDock(player.field_71071_by, this);
    }

    @Override
    public RequestNetwork.PathNode createNode(BlockPos pos) {
        return new RequestNetwork.PathNode(pos, this.reachableNodes);
    }
}

