/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.container.ContainerMachineVacuumDistill;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMachineVacuumDistill;
import com.hbm.inventory.recipes.RefineryRecipes;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IPersistentNBT;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.Tuple;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineVacuumDistill
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardTransceiver,
IPersistentNBT,
IGUIProvider,
IFluidCopiable {
    public long power;
    public static final long maxPower = 1000000L;
    public FluidTank[] tanks = new FluidTank[5];
    private AudioWrapper audio;
    private int audioTime;
    public boolean isOn;
    AxisAlignedBB bb = null;

    public TileEntityMachineVacuumDistill() {
        super(12);
        this.tanks[0] = new FluidTank(Fluids.OIL, 64000).withPressure(2);
        this.tanks[1] = new FluidTank(Fluids.HEAVYOIL_VACUUM, 24000);
        this.tanks[2] = new FluidTank(Fluids.REFORMATE, 24000);
        this.tanks[3] = new FluidTank(Fluids.LIGHTOIL_VACUUM, 24000);
        this.tanks[4] = new FluidTank(Fluids.SOURGAS, 24000);
    }

    @Override
    public String getName() {
        return "container.vacuumDistill";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.isOn = false;
            this.updateConnections();
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 1000000L);
            this.tanks[0].setType(11, this.slots);
            this.tanks[0].loadTank(1, 2, this.slots);
            this.refine();
            this.tanks[1].unloadTank(3, 4, this.slots);
            this.tanks[2].unloadTank(5, 6, this.slots);
            this.tanks[3].unloadTank(7, 8, this.slots);
            this.tanks[4].unloadTank(9, 10, this.slots);
            for (DirPos pos : this.getConPos()) {
                for (int i = 1; i < 5; ++i) {
                    if (this.tanks[i].getFill() <= 0) continue;
                    this.sendFluid(this.tanks[i], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
            }
            this.networkPackNT(150);
        } else {
            if (this.isOn) {
                this.audioTime = 20;
            }
            if (this.audioTime > 0) {
                --this.audioTime;
                if (this.audio == null) {
                    this.audio = this.createAudioLoop();
                    this.audio.startSound();
                } else if (!this.audio.isPlaying()) {
                    this.audio = this.rebootAudio(this.audio);
                }
                this.audio.updateVolume(this.getVolume(1.0f));
                this.audio.keepAlive();
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
        }
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:block.boiler", this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.25f, 15.0f, 1.0f, 20);
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeBoolean(this.isOn);
        for (int i = 0; i < 5; ++i) {
            this.tanks[i].serialize(buf);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.isOn = buf.readBoolean();
        for (int i = 0; i < 5; ++i) {
            this.tanks[i].deserialize(buf);
        }
    }

    private void refine() {
        int i;
        Tuple.Quartet<FluidStack, FluidStack, FluidStack, FluidStack> refinery = RefineryRecipes.getVacuum(this.tanks[0].getTankType());
        if (refinery == null) {
            for (int i2 = 1; i2 < 5; ++i2) {
                this.tanks[i2].setTankType(Fluids.NONE);
            }
            return;
        }
        FluidStack[] stacks = new FluidStack[]{refinery.getW(), refinery.getX(), refinery.getY(), refinery.getZ()};
        for (i = 0; i < stacks.length; ++i) {
            this.tanks[i + 1].setTankType(stacks[i].type);
        }
        if (this.power < 10000L) {
            return;
        }
        if (this.tanks[0].getFill() < 100) {
            return;
        }
        for (i = 0; i < stacks.length; ++i) {
            if (this.tanks[i + 1].getFill() + stacks[i].fill <= this.tanks[i + 1].getMaxFill()) continue;
            return;
        }
        this.isOn = true;
        this.power -= 10000L;
        this.tanks[0].setFill(this.tanks[0].getFill() - 100);
        for (i = 0; i < stacks.length; ++i) {
            this.tanks[i + 1].setFill(this.tanks[i + 1].getFill() + stacks[i].fill);
        }
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 1, Library.POS_X), new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 1, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 1, Library.NEG_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e - 1, Library.NEG_X), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z)};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.tanks[0].readFromNBT(nbt, "input");
        this.tanks[1].readFromNBT(nbt, "heavy");
        this.tanks[2].readFromNBT(nbt, "reformate");
        this.tanks[3].readFromNBT(nbt, "light");
        this.tanks[4].readFromNBT(nbt, "gas");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.tanks[0].writeToNBT(nbt, "input");
        this.tanks[1].writeToNBT(nbt, "heavy");
        this.tanks[2].writeToNBT(nbt, "reformate");
        this.tanks[3].writeToNBT(nbt, "light");
        this.tanks[4].writeToNBT(nbt, "gas");
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 9), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1], this.tanks[2], this.tanks[3], this.tanks[4]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN && dir != ForgeDirection.DOWN;
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN && dir != ForgeDirection.DOWN;
    }

    @Override
    public void writeNBT(NBTTagCompound nbt) {
        if (this.tanks[0].getFill() == 0 && this.tanks[1].getFill() == 0 && this.tanks[2].getFill() == 0 && this.tanks[3].getFill() == 0 && this.tanks[4].getFill() == 0) {
            return;
        }
        NBTTagCompound data = new NBTTagCompound();
        for (int i = 0; i < 5; ++i) {
            this.tanks[i].writeToNBT(data, "" + i);
        }
        nbt.func_74782_a("persistent", (NBTBase)data);
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        NBTTagCompound data = nbt.func_74775_l("persistent");
        for (int i = 0; i < 5; ++i) {
            this.tanks[i].readFromNBT(data, "" + i);
        }
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineVacuumDistill(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineVacuumDistill(player.field_71071_by, this);
    }
}

