/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ModBlocks;
import com.hbm.handler.RocketStruct;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerMachineRocketAssembly;
import com.hbm.inventory.gui.GUIMachineRocketAssembly;
import com.hbm.items.ISatChip;
import com.hbm.items.ItemVOTVdrive;
import com.hbm.items.weapon.ItemCustomRocket;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BobMathUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineRocketAssembly
extends TileEntityMachineBase
implements IGUIProvider,
IControlReceiver {
    public RocketStruct rocket;
    private int previousHeight = 0;
    private List<Integer> platforms = new ArrayList<Integer>();
    private boolean platformFailed = false;
    public int currentStage;
    public boolean isBreaking;

    public TileEntityMachineRocketAssembly() {
        super(27);
    }

    @Override
    public String getName() {
        return "container.machineRocketAssembly";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int height;
            ItemStack fromStack = this.slots[this.slots.length - (5 - this.currentStage) * 2];
            ItemStack toStack = this.slots[this.slots.length - (5 - this.currentStage) * 2 + 1];
            ItemVOTVdrive.getTarget(fromStack, this.field_145850_b);
            ItemVOTVdrive.getTarget(toStack, this.field_145850_b);
            this.rocket = new RocketStruct(this.slots[0]);
            if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ISatChip) {
                this.rocket.satFreq = ISatChip.getFreqS(this.slots[0]);
            }
            for (int i = 1; i < 15; i += 3) {
                if (this.slots[i] == null && this.slots[i + 1] == null && this.slots[i + 2] == null) {
                    if (i + 3 >= 15 || this.slots[i + 3] == null && this.slots[i + 4] == null && this.slots[i + 5] == null) break;
                    this.slots[i] = this.slots[i + 3];
                    this.slots[i + 1] = this.slots[i + 4];
                    this.slots[i + 2] = this.slots[i + 5];
                    this.slots[i + 3] = null;
                    this.slots[i + 4] = null;
                    this.slots[i + 5] = null;
                }
                this.rocket.addStage(this.slots[i], this.slots[i + 1], this.slots[i + 2]);
            }
            if ((height = (int)this.rocket.getHeight()) != this.previousHeight) {
                BlockDummyable.safeRem = true;
                for (int platform : this.platforms) {
                    this.deletePlatform(platform);
                }
                this.platforms = new ArrayList<Integer>();
                int maxHeight = Integer.MAX_VALUE;
                for (int h = 1; h < 256; ++h) {
                    Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + h, this.field_145849_e);
                    if (block.isReplaceable((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d + h, this.field_145849_e) || block == ModBlocks.machine_rocket_assembly) continue;
                    maxHeight = h;
                    break;
                }
                double checkHeight = this.rocket.getHeight();
                if (this.rocket.capsule != null) {
                    checkHeight -= this.rocket.capsule.height;
                }
                if (this.rocket.stages.size() > 0 && this.rocket.stages.get((int)0).thruster != null) {
                    checkHeight -= this.rocket.stages.get((int)0).thruster.height;
                }
                if (checkHeight < (double)maxHeight) {
                    int i;
                    int targetHeight = 0;
                    for (int i2 = 0; i2 < this.rocket.stages.size(); ++i2) {
                        int platform;
                        RocketStruct.RocketStage nextStage;
                        RocketStruct.RocketStage stage = this.rocket.stages.get(i2);
                        RocketStruct.RocketStage rocketStage = nextStage = i2 < this.rocket.stages.size() - 1 ? this.rocket.stages.get(i2 + 1) : null;
                        if (stage.fuselage != null) {
                            targetHeight = (int)((double)targetHeight + stage.fuselage.height * (double)stage.getStack());
                        }
                        if (nextStage != null && nextStage.thruster != null) {
                            targetHeight = (int)((double)targetHeight + nextStage.thruster.height);
                        }
                        if ((platform = Math.round(targetHeight)) <= 0) continue;
                        this.addPlatform(platform);
                        this.platforms.add(platform);
                    }
                    int meta = ForgeDirection.UP.ordinal();
                    for (i = 1; i < targetHeight + 1 && this.field_145848_d + i <= 255; ++i) {
                        this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d + i, this.field_145849_e, ModBlocks.machine_rocket_assembly, meta, 3);
                        this.field_145850_b.func_147465_d(this.field_145851_c - 4, this.field_145848_d + i, this.field_145849_e - 4, ModBlocks.machine_rocket_assembly, meta, 3);
                        this.field_145850_b.func_147465_d(this.field_145851_c + 4, this.field_145848_d + i, this.field_145849_e - 4, ModBlocks.machine_rocket_assembly, meta, 3);
                        this.field_145850_b.func_147465_d(this.field_145851_c - 4, this.field_145848_d + i, this.field_145849_e + 4, ModBlocks.machine_rocket_assembly, meta, 3);
                        this.field_145850_b.func_147465_d(this.field_145851_c + 4, this.field_145848_d + i, this.field_145849_e + 4, ModBlocks.machine_rocket_assembly, meta, 3);
                    }
                    for (i = targetHeight + 1; i < 256 && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + i, this.field_145849_e) == ModBlocks.machine_rocket_assembly; ++i) {
                        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d + i, this.field_145849_e);
                    }
                    for (i = targetHeight + 1; i < 256 && this.field_145850_b.func_147439_a(this.field_145851_c - 4, this.field_145848_d + i, this.field_145849_e - 4) == ModBlocks.machine_rocket_assembly; ++i) {
                        this.field_145850_b.func_147468_f(this.field_145851_c - 4, this.field_145848_d + i, this.field_145849_e - 4);
                    }
                    for (i = targetHeight + 1; i < 256 && this.field_145850_b.func_147439_a(this.field_145851_c + 4, this.field_145848_d + i, this.field_145849_e - 4) == ModBlocks.machine_rocket_assembly; ++i) {
                        this.field_145850_b.func_147468_f(this.field_145851_c + 4, this.field_145848_d + i, this.field_145849_e - 4);
                    }
                    for (i = targetHeight + 1; i < 256 && this.field_145850_b.func_147439_a(this.field_145851_c - 4, this.field_145848_d + i, this.field_145849_e + 4) == ModBlocks.machine_rocket_assembly; ++i) {
                        this.field_145850_b.func_147468_f(this.field_145851_c - 4, this.field_145848_d + i, this.field_145849_e + 4);
                    }
                    for (i = targetHeight + 1; i < 256 && this.field_145850_b.func_147439_a(this.field_145851_c + 4, this.field_145848_d + i, this.field_145849_e + 4) == ModBlocks.machine_rocket_assembly; ++i) {
                        this.field_145850_b.func_147468_f(this.field_145851_c + 4, this.field_145848_d + i, this.field_145849_e + 4);
                    }
                    this.platformFailed = false;
                } else {
                    this.platformFailed = true;
                }
                BlockDummyable.safeRem = false;
                this.previousHeight = height;
            }
            if (this.platformFailed) {
                this.rocket.addIssue(EnumChatFormatting.RED + "VAB ceiling too low ");
            }
            this.networkPackNT(250);
        }
    }

    public void addPlatform(int height) {
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                int meta = 0;
                if ((x == -4 || x == 4) && (z == -4 || z == 4)) continue;
                if (x < 0) {
                    meta = ForgeDirection.WEST.ordinal();
                } else if (x > 0) {
                    meta = ForgeDirection.EAST.ordinal();
                } else if (z < 0) {
                    meta = ForgeDirection.NORTH.ordinal();
                } else {
                    if (z <= 0) continue;
                    meta = ForgeDirection.SOUTH.ordinal();
                }
                this.field_145850_b.func_147465_d(this.field_145851_c + x, this.field_145848_d + height, this.field_145849_e + z, ModBlocks.machine_rocket_assembly, meta, 3);
            }
        }
    }

    public void deletePlatform(int height) {
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                if (x == 0 && z == 0 || (x == -4 || x == 4) && (z == -4 || z == 4)) continue;
                this.field_145850_b.func_147468_f(this.field_145851_c + x, this.field_145848_d + height, this.field_145849_e + z);
            }
        }
    }

    @Override
    public int func_70302_i_() {
        if (this.isBreaking) {
            return super.func_70302_i_() - 10;
        }
        return super.func_70302_i_();
    }

    @Override
    public void serialize(ByteBuf buf) {
        this.rocket.writeToByteBuffer(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.rocket = RocketStruct.readFromByteBuffer(buf);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74783_a("platforms", BobMathUtil.intCollectionToArray(this.platforms));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.platforms = new ArrayList<Integer>();
        for (int i : nbt.func_74759_k("platforms")) {
            this.platforms.add(i);
        }
    }

    public void construct() {
        if (!this.rocket.validate()) {
            return;
        }
        this.slots[this.slots.length - 10 - 1] = ItemCustomRocket.build(this.rocket);
        for (int i = 0; i < this.slots.length - 10 - 1; ++i) {
            this.slots[i] = null;
        }
    }

    public boolean canDeconstruct() {
        RocketStruct rocket = ItemCustomRocket.get(this.slots[this.slots.length - 10 - 1]);
        if (rocket == null) {
            return false;
        }
        for (int i = 0; i < this.slots.length - 10 - 1; ++i) {
            if (this.slots[i] == null) continue;
            return false;
        }
        return true;
    }

    public void deconstruct() {
        if (!this.canDeconstruct()) {
            return;
        }
        int satFreq = ISatChip.getFreqS(this.slots[this.slots.length - 10 - 1]);
        RocketStruct rocket = ItemCustomRocket.get(this.slots[this.slots.length - 10 - 1]);
        this.slots[0] = new ItemStack((Item)rocket.capsule.part);
        if (this.slots[0].func_77973_b() instanceof ISatChip) {
            ISatChip.setFreqS(this.slots[0], satFreq);
        }
        for (int i = 0; i < rocket.stages.size(); ++i) {
            int o = i * 3;
            RocketStruct.RocketStage stage = rocket.stages.get(rocket.stages.size() - 1 - i);
            this.slots[o + 1] = new ItemStack((Item)stage.fuselage.part, stage.fuselageCount);
            if (stage.fins != null) {
                this.slots[o + 2] = new ItemStack((Item)stage.fins.part);
            }
            this.slots[o + 3] = new ItemStack((Item)stage.thruster.part, stage.thrusterCount);
        }
        this.slots[this.slots.length - 10 - 1] = null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineRocketAssembly(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineRocketAssembly(player.field_71071_by, this);
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74767_n("construct")) {
            this.construct();
        }
        if (data.func_74767_n("deconstruct")) {
            this.deconstruct();
        }
    }

    @Override
    public int func_70297_j_() {
        return 8;
    }
}

