/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity;

import com.hbm.util.CompatExternal;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public interface IPersistentNBT {
    public static final String NBT_PERSISTENT_KEY = "persistent";

    public void writeNBT(NBTTagCompound var1);

    public void readNBT(NBTTagCompound var1);

    default public ArrayList<ItemStack> getDrops(Block b) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ItemStack stack = new ItemStack(b);
        NBTTagCompound data = new NBTTagCompound();
        this.writeNBT(data);
        if (!data.func_82582_d()) {
            stack.field_77990_d = data;
        }
        list.add(stack);
        return list;
    }

    public static ArrayList<ItemStack> getDrops(World world, int x, int y, int z, Block b) {
        TileEntity tile = CompatExternal.getCoreFromPos(world, x, y, z);
        if (tile instanceof IPersistentNBT) {
            return ((IPersistentNBT)tile).getDrops(b);
        }
        return new ArrayList<ItemStack>();
    }

    public static void restoreData(World world, int x, int y, int z, ItemStack stack) {
        try {
            if (!stack.func_77942_o()) {
                return;
            }
            IPersistentNBT tile = (IPersistentNBT)world.func_147438_o(x, y, z);
            tile.readNBT(stack.field_77990_d);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

