/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.item.weapon.sedna;

import com.hbm.items.ModItems;
import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.items.weapon.sedna.mods.XWeaponModManager;
import com.hbm.main.ResourceManager;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.item.weapon.sedna.ItemRenderWeaponBase;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRenderAmat
extends ItemRenderWeaponBase {
    public ResourceLocation texture;

    public ItemRenderAmat(ResourceLocation texture) {
        this.texture = texture;
    }

    @Override
    protected float getTurnMagnitude(ItemStack stack) {
        return ItemGunBaseNT.getIsAiming(stack) ? 2.5f : -0.5f;
    }

    @Override
    public float getViewFOV(ItemStack stack, float fov) {
        float aimingProgress = ItemGunBaseNT.prevAimingProgress + (ItemGunBaseNT.aimingProgress - ItemGunBaseNT.prevAimingProgress) * interp;
        return fov * (1.0f - aimingProgress * (this.isScoped(stack) ? 0.8f : 0.33f));
    }

    @Override
    public void setupFirstPerson(ItemStack stack) {
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.875);
        float offset = 0.8f;
        ItemRenderAmat.standardAimingTransform(stack, -1.0f * offset, -1.0f * offset, 3.25f * offset, 0.0, -0.609375, 1.875);
    }

    @Override
    public void renderFirstPerson(ItemStack stack) {
        boolean isScoped = this.isScoped(stack);
        if (isScoped && ItemGunBaseNT.prevAimingProgress == 1.0f && ItemGunBaseNT.aimingProgress == 1.0f) {
            return;
        }
        ItemGunBaseNT gun = (ItemGunBaseNT)stack.func_77973_b();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        double scale = 0.375;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        boolean deployed = HbmAnimations.getRelevantAnim(0) == null || HbmAnimations.getRelevantAnim((int)0).animation.getBus("BIPOD") == null;
        double[] equip = HbmAnimations.getRelevantTransformation("EQUIP");
        double[] bipod = HbmAnimations.getRelevantTransformation("BIPOD");
        double[] lift = HbmAnimations.getRelevantTransformation("LIFT");
        double[] recoil = HbmAnimations.getRelevantTransformation("RECOIL");
        double[] boltTurn = HbmAnimations.getRelevantTransformation("BOLT_TURN");
        double[] boltPull = HbmAnimations.getRelevantTransformation("BOLT_PULL");
        double[] mag = HbmAnimations.getRelevantTransformation("MAG");
        double[] scopeThrow = HbmAnimations.getRelevantTransformation("SCOPE_THROW");
        double[] scopeSpin = HbmAnimations.getRelevantTransformation("SCOPE_SPIN");
        GL11.glTranslated((double)0.0, (double)0.0, (double)recoil[2]);
        GL11.glTranslated((double)0.0, (double)-3.0, (double)-8.0);
        GL11.glRotated((double)equip[0], (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)lift[0], (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)3.0, (double)8.0);
        GL11.glShadeModel((int)7425);
        ResourceManager.amat.renderPart("Gun");
        if (this.isScoped(stack)) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)scopeThrow[0], (double)scopeThrow[1], (double)scopeThrow[2]);
            GL11.glTranslated((double)0.0, (double)1.5, (double)-4.5);
            GL11.glRotated((double)scopeSpin[0], (double)1.0, (double)0.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)-1.5, (double)4.5);
            ResourceManager.amat.renderPart("Scope");
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.625, (double)0.0);
        GL11.glRotated((double)boltTurn[2], (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)0.0, (double)-0.625, (double)0.0);
        GL11.glTranslated((double)0.0, (double)0.0, (double)boltPull[2]);
        ResourceManager.amat.renderPart("Bolt");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)mag[0], (double)mag[1], (double)mag[2]);
        ResourceManager.amat.renderPart("Magazine");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.3125, (double)-0.625, (double)-1.0);
        GL11.glRotated((double)(deployed ? 25.0 : bipod[1]), (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)-0.3125, (double)0.625, (double)1.0);
        ResourceManager.amat.renderPart("BipodHingeLeft");
        GL11.glTranslated((double)0.3125, (double)-0.625, (double)-1.0);
        GL11.glRotated((double)(deployed ? 80.0 : bipod[0]), (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)-0.3125, (double)0.625, (double)1.0);
        ResourceManager.amat.renderPart("BipodLeft");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)-0.3125, (double)-0.625, (double)-1.0);
        GL11.glRotated((double)(deployed ? -25.0 : -bipod[1]), (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)0.3125, (double)0.625, (double)1.0);
        ResourceManager.amat.renderPart("BipodHingeRight");
        GL11.glTranslated((double)-0.3125, (double)-0.625, (double)-1.0);
        GL11.glRotated((double)(deployed ? 80.0 : bipod[0]), (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.3125, (double)0.625, (double)1.0);
        ResourceManager.amat.renderPart("BipodRight");
        GL11.glPopMatrix();
        if (this.isSilenced(stack)) {
            GL11.glTranslated((double)0.0, (double)0.625, (double)-4.3125);
            GL11.glScaled((double)1.25, (double)1.25, (double)1.25);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.g3_attachments);
            ResourceManager.g3.renderPart("Silencer");
            GL11.glShadeModel((int)7424);
        } else {
            ResourceManager.amat.renderPart("MuzzleBrake");
            double smokeScale = 0.5;
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)0.625, (double)12.0);
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glScaled((double)smokeScale, (double)smokeScale, (double)smokeScale);
            ItemRenderAmat.renderSmokeNodes(gun.getConfig((ItemStack)stack, (int)0).smokeNodes, 1.0);
            GL11.glPopMatrix();
            GL11.glShadeModel((int)7424);
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)0.5, (double)11.0);
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
            ItemRenderAmat.renderGapFlash(gun.lastShot[0]);
            GL11.glPopMatrix();
        }
    }

    @Override
    public void setupThirdPerson(ItemStack stack) {
        super.setupThirdPerson(stack);
        double scale = 1.25;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glTranslated((double)0.0, (double)0.5, (double)6.75);
    }

    @Override
    public void setupInv(ItemStack stack) {
        super.setupInv(stack);
        if (this.isSilenced(stack)) {
            double scale = 0.8175;
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            GL11.glRotated((double)25.0, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)45.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)-0.5, (double)0.5, (double)-1.0);
        } else {
            double scale = 0.9375;
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            GL11.glRotated((double)25.0, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)45.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)-0.5, (double)0.5, (double)0.0);
        }
    }

    @Override
    public void setupModTable(ItemStack stack) {
        double scale = -5.75;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-0.25, (double)-1.5);
    }

    @Override
    public void renderOther(ItemStack stack, IItemRenderer.ItemRenderType type) {
        GL11.glEnable((int)2896);
        GL11.glShadeModel((int)7425);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        ResourceManager.amat.renderPart("Gun");
        ResourceManager.amat.renderPart("Bolt");
        ResourceManager.amat.renderPart("Magazine");
        ResourceManager.amat.renderPart("BipodLeft");
        ResourceManager.amat.renderPart("BipodHingeLeft");
        ResourceManager.amat.renderPart("BipodRight");
        ResourceManager.amat.renderPart("BipodHingeRight");
        if (this.isScoped(stack)) {
            ResourceManager.amat.renderPart("Scope");
        }
        if (this.isSilenced(stack)) {
            GL11.glTranslated((double)0.0, (double)0.625, (double)-4.3125);
            GL11.glScaled((double)1.25, (double)1.25, (double)1.25);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.g3_attachments);
            ResourceManager.g3.renderPart("Silencer");
        } else {
            ResourceManager.amat.renderPart("MuzzleBrake");
        }
        GL11.glShadeModel((int)7424);
    }

    public boolean isScoped(ItemStack stack) {
        return true;
    }

    public boolean isSilenced(ItemStack stack) {
        return stack.func_77973_b() == ModItems.gun_amat_penance || XWeaponModManager.hasUpgrade(stack, 0, 201);
    }
}

