/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.potion;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.PotionConfig;
import com.hbm.config.ServerConfig;
import com.hbm.entity.mob.EntityCreeperTainted;
import com.hbm.entity.mob.EntityTaintCrab;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.extprop.HbmLivingProps;
import com.hbm.extprop.HbmPlayerProps;
import com.hbm.items.ModItems;
import com.hbm.lib.ModDamageSource;
import com.hbm.util.ContaminationUtil;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;

public class HbmPotion
extends Potion {
    public static HbmPotion taint;
    public static HbmPotion radiation;
    public static HbmPotion bang;
    public static HbmPotion mutation;
    public static HbmPotion radx;
    public static HbmPotion lead;
    public static HbmPotion radaway;
    public static HbmPotion phosphorus;
    public static HbmPotion stability;
    public static HbmPotion potionsickness;
    public static HbmPotion death;
    public static HbmPotion run;
    public static HbmPotion nitan;
    public static HbmPotion flashbang;
    public static HbmPotion slippery;

    public HbmPotion(int id, boolean isBad, int color) {
        super(id, isBad, color);
    }

    public static void init() {
        taint = HbmPotion.registerPotion(PotionConfig.taintID, true, 0x800080, "potion.hbm_taint", 0, 0);
        radiation = HbmPotion.registerPotion(PotionConfig.radiationID, true, 8700200, "potion.hbm_radiation", 1, 0);
        bang = HbmPotion.registerPotion(PotionConfig.bangID, true, 0x111111, "potion.hbm_bang", 3, 0);
        mutation = HbmPotion.registerPotion(PotionConfig.mutationID, false, 0x800080, "potion.hbm_mutation", 2, 0);
        radx = HbmPotion.registerPotion(PotionConfig.radxID, false, 0xBB4B00, "potion.hbm_radx", 5, 0);
        lead = HbmPotion.registerPotion(PotionConfig.leadID, true, 7763586, "potion.hbm_lead", 6, 0);
        radaway = HbmPotion.registerPotion(PotionConfig.radawayID, false, 0xBB4B00, "potion.hbm_radaway", 7, 0);
        phosphorus = HbmPotion.registerPotion(PotionConfig.phosphorusID, true, 0xFFFF00, "potion.hbm_phosphorus", 1, 1);
        stability = HbmPotion.registerPotion(PotionConfig.stabilityID, false, 0xD0D0D0, "potion.hbm_stability", 2, 1);
        potionsickness = HbmPotion.registerPotion(PotionConfig.potionsicknessID, false, 0xFF8080, "potion.hbm_potionsickness", 3, 1);
        death = HbmPotion.registerPotion(PotionConfig.deathID, false, 0x111111, "potion.hbm_death", 4, 1);
        run = HbmPotion.registerPotion(PotionConfig.runID, true, 0x111111, "potion.hbm_run", 14, 0);
        nitan = HbmPotion.registerPotion(PotionConfig.nitanID, false, 0x800080, "potion.hbm_nitan", 3, 1);
        flashbang = HbmPotion.registerPotion(PotionConfig.flashbangID, false, 0xD0D0D0, "potion.hbm_flashbang", 15, 1);
        slippery = HbmPotion.registerPotion(PotionConfig.slipperyID, false, 0xD0D0D0, "potion.hbm_slippery", 15, 0);
    }

    public static HbmPotion registerPotion(int id, boolean isBad, int color, String name, int x, int y) {
        if (id >= Potion.field_76425_a.length) {
            Potion[] newArray = new Potion[Math.max(256, id)];
            System.arraycopy(Potion.field_76425_a, 0, newArray, 0, Potion.field_76425_a.length);
            Field field = ReflectionHelper.findField(Potion.class, (String[])new String[]{"field_76425_a", "potionTypes"});
            field.setAccessible(true);
            try {
                Field modfield = Field.class.getDeclaredField("modifiers");
                modfield.setAccessible(true);
                modfield.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                field.set(null, newArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        HbmPotion effect = new HbmPotion(id, isBad, color);
        effect.func_76390_b(name);
        effect.func_76399_b(x, y);
        return effect;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76392_e() {
        ResourceLocation loc = new ResourceLocation("hbm", "textures/gui/potions.png");
        Minecraft.func_71410_x().field_71446_o.func_110577_a(loc);
        return super.func_76392_e();
    }

    public void func_76394_a(EntityLivingBase entity, int level) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this == taint) {
            if (!(entity instanceof EntityCreeperTainted) && !(entity instanceof EntityTaintCrab) && entity.field_70170_p.field_73012_v.nextInt(40) == 0) {
                entity.func_70097_a(ModDamageSource.taint, (float)(level + 1));
            }
            if (ServerConfig.TAINT_TRAILS.get().booleanValue() && !entity.field_70170_p.field_72995_K) {
                int x = (int)Math.floor(entity.field_70165_t);
                int y = (int)Math.floor(entity.field_70163_u);
                int z = (int)Math.floor(entity.field_70161_v);
                Block b = entity.field_70170_p.func_147439_a(x, y - 1, z);
                if (y > 1 && b.func_149721_r() && !b.isAir((IBlockAccess)entity.field_70170_p, x, y - 1, z)) {
                    entity.field_70170_p.func_147465_d(x, y - 1, z, ModBlocks.taint, 14, 2);
                }
            }
        }
        if (this == radiation) {
            ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, ((float)level + 1.0f) * 0.05f);
        }
        if (this == radaway) {
            HbmLivingProps.incrementRadiation(entity, -(level + 1));
        }
        if (this == slippery) {
            entity.field_70181_x += 0.026;
        }
        if (this == bang) {
            entity.func_70097_a(ModDamageSource.bang, 1000.0f);
            entity.func_70606_j(0.0f);
            if (!(entity instanceof EntityPlayer)) {
                entity.func_70106_y();
            }
            entity.field_70170_p.func_72908_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, "hbm:weapon.laserBang", 100.0f, 1.0f);
            ExplosionLarge.spawnParticles(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 10);
            if (entity instanceof EntityCow) {
                EntityCow cow = (EntityCow)entity;
                int toDrop = cow.func_70631_g_() ? 10 : 3;
                cow.func_70099_a(new ItemStack(ModItems.cheese, toDrop), 1.0f);
            }
        }
        if (this == run) {
            entity.func_70097_a(ModDamageSource.run, 1000.0f);
            entity.func_70606_j(0.0f);
            new ExplosionVNT(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 12.0f).makeAmat().explode();
            entity.field_70170_p.func_72908_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, "hbm:weapon.mukeExplosion", 100.0f, 1.0f);
            if (!(entity instanceof EntityPlayer)) {
                entity.func_70106_y();
            }
        }
        if (this == lead) {
            entity.func_70097_a(ModDamageSource.lead, (float)(level + 1));
        }
        if (this == phosphorus) {
            entity.func_70015_d(1);
        }
        if (this == nitan && !entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer) {
            HbmPlayerProps props = HbmPlayerProps.getData((EntityPlayer)entity);
            if (props.nitanCount == 3) {
                entity.func_70097_a(ModDamageSource.nitan, 1000.0f);
            }
        }
        if (this == flashbang && !entity.field_70170_p.field_72995_K) {
            if (entity instanceof EntityZombie || entity instanceof EntitySkeleton) {
                entity.func_70015_d(20);
            }
            entity.func_70690_d(new PotionEffect(HbmPotion.field_76421_d.field_76415_H, 5, 10));
        }
    }

    public boolean func_76397_a(int par1, int par2) {
        if (this == taint) {
            return par1 % 2 == 0;
        }
        if (this == radiation || this == radaway || this == phosphorus || this == nitan || this == slippery) {
            return true;
        }
        if (this == bang) {
            return par1 <= 10;
        }
        if (this == run) {
            return par1 <= 10;
        }
        if (this == lead) {
            int k = 60;
            return k > 0 ? par1 % k == 0 : true;
        }
        return false;
    }

    public static boolean getIsBadEffect(Potion potion) {
        try {
            Field isBadEffect = ReflectionHelper.findField(Potion.class, (String[])new String[]{"isBadEffect", "field_76418_K"});
            boolean ret = isBadEffect.getBoolean(potion);
            return ret;
        }
        catch (Exception x) {
            return false;
        }
    }
}

