/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.main.MainRegistry;
import com.hbm.particle.helper.SkeletonCreator;
import com.hbm.render.loader.HFRWavefrontObject;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ParticleSkeleton
extends EntityFX {
    public static final ResourceLocation texture = new ResourceLocation("hbm:textures/particle/skeleton.png");
    public static final ResourceLocation texture_ext = new ResourceLocation("hbm:textures/particle/skoilet.png");
    public static final ResourceLocation texture_blood = new ResourceLocation("hbm:textures/particle/skeleton_blood.png");
    public static final ResourceLocation texture_blood_ext = new ResourceLocation("hbm:textures/particle/skoilet_blood.png");
    public static final IModelCustom skeleton = new HFRWavefrontObject(new ResourceLocation("hbm", "models/effect/skeleton.obj"), false).asVBO();
    protected SkeletonCreator.EnumSkeletonType type;
    public ResourceLocation useTexture;
    public ResourceLocation useTextureExt;
    private float momentumYaw;
    private float momentumPitch;
    private int initialDelay;
    private final TextureManager textureManager;

    public ParticleSkeleton(TextureManager textureManager, World world, double x, double y, double z, float r, float g, float b, SkeletonCreator.EnumSkeletonType type) {
        super(world, x, y, z);
        this.textureManager = textureManager;
        this.type = type;
        this.field_70547_e = 1200 + this.field_70146_Z.nextInt(20);
        this.field_70552_h = r;
        this.field_70553_i = g;
        this.field_70551_j = b;
        this.field_70545_g = 0.02f;
        this.initialDelay = 20;
        this.momentumPitch = this.field_70146_Z.nextFloat() * 5.0f * (float)(this.field_70146_Z.nextBoolean() ? 1 : -1);
        this.momentumYaw = this.field_70146_Z.nextFloat() * 5.0f * (float)(this.field_70146_Z.nextBoolean() ? 1 : -1);
        this.useTexture = texture;
        this.useTextureExt = texture_ext;
    }

    public ParticleSkeleton makeGib() {
        this.initialDelay = -2;
        this.useTexture = texture_blood;
        this.useTextureExt = texture_blood_ext;
        this.field_70545_g = 0.04f;
        this.field_70547_e = 600 + this.field_70146_Z.nextInt(20);
        return this;
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        if (this.initialDelay-- > 0) {
            return;
        }
        if (this.initialDelay == -1) {
            this.field_70159_w = this.field_70146_Z.nextGaussian() * 0.025;
            this.field_70179_y = this.field_70146_Z.nextGaussian() * 0.025;
        }
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_70106_y();
        }
        boolean wasOnGround = this.field_70122_E;
        this.field_70181_x -= (double)this.field_70545_g;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= 0.98;
        this.field_70181_x *= 0.98;
        this.field_70179_y *= 0.98;
        if (!this.field_70122_E) {
            this.field_70125_A += this.momentumPitch;
            this.field_70177_z += this.momentumYaw;
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            if (!wasOnGround) {
                MainRegistry.proxy.playSoundClient(this.field_70165_t, this.field_70163_u, this.field_70161_v, "mob.skeleton.hurt", 0.25f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
            }
        }
    }

    public int func_70537_b() {
        return 3;
    }

    public void func_70539_a(Tessellator tess, float interp, float x, float y, float z, float tx, float tz) {
        GL11.glPushMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74519_b();
        double pX = this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)interp;
        double pY = this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)interp;
        double pZ = this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)interp;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        double dX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)interp;
        double dY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)interp;
        double dZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)interp;
        GL11.glTranslated((double)(pX - dX), (double)(pY - dY), (double)(pZ - dZ));
        GL11.glRotated((double)(this.field_70126_B + (this.field_70177_z - this.field_70126_B) * interp), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)(this.field_70127_C + (this.field_70125_A - this.field_70127_C) * interp), (double)1.0, (double)0.0, (double)0.0);
        float timeLeft = (float)this.field_70547_e - ((float)this.field_70546_d + interp);
        this.field_82339_as = timeLeft < 40.0f ? timeLeft / 40.0f : 1.0f;
        int brightness = this.field_70170_p.func_72802_i(MathHelper.func_76128_c((double)pX), MathHelper.func_76128_c((double)pY), MathHelper.func_76128_c((double)pZ), 0);
        int lX = brightness % 65536;
        int lY = brightness / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)lX / 1.0f), (float)((float)lY / 1.0f));
        GL11.glColor4f((float)this.field_70552_h, (float)this.field_70553_i, (float)this.field_70551_j, (float)this.field_82339_as);
        GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
        switch (this.type) {
            case SKULL: {
                this.textureManager.func_110577_a(this.useTexture);
                skeleton.renderPart("Skull");
                break;
            }
            case TORSO: {
                this.textureManager.func_110577_a(this.useTexture);
                skeleton.renderPart("Torso");
                break;
            }
            case LIMB: {
                this.textureManager.func_110577_a(this.useTexture);
                skeleton.renderPart("Limb");
                break;
            }
            case SKULL_VILLAGER: {
                this.textureManager.func_110577_a(this.useTextureExt);
                skeleton.renderPart("SkullVillager");
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glDisable((int)2884);
        GL11.glPopMatrix();
    }
}

