/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tool;

import com.google.gson.stream.JsonWriter;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ModBlocks;
import com.hbm.main.MainRegistry;
import com.hbm.util.fauxpointtwelve.BlockPos;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemCMStructure
extends Item
implements ILookOverlay {
    private static File file = new File(MainRegistry.configHbmDir, "CMstructureOutput.txt");

    public static BlockPos getAnchor(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        return new BlockPos(stack.field_77990_d.func_74762_e("anchorX"), stack.field_77990_d.func_74762_e("anchorY"), stack.field_77990_d.func_74762_e("anchorZ"));
    }

    public static void setAnchor(ItemStack stack, int x, int y, int z) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a("anchorX", x);
        stack.field_77990_d.func_74768_a("anchorY", y);
        stack.field_77990_d.func_74768_a("anchorZ", z);
    }

    public static void writeToFile(File config, ItemStack stack, World world) {
        int anchorX = stack.field_77990_d.func_74762_e("anchorX");
        int anchorY = stack.field_77990_d.func_74762_e("anchorY");
        int anchorZ = stack.field_77990_d.func_74762_e("anchorZ");
        int x1 = stack.field_77990_d.func_74762_e("x1");
        int y1 = stack.field_77990_d.func_74762_e("y1");
        int z1 = stack.field_77990_d.func_74762_e("z1");
        int x2 = stack.field_77990_d.func_74762_e("x2");
        int y2 = stack.field_77990_d.func_74762_e("y2");
        int z2 = stack.field_77990_d.func_74762_e("z2");
        ForgeDirection dir = ForgeDirection.getOrientation((int)world.func_72805_g(anchorX, anchorY, anchorZ));
        int minX = Math.min(x1, x2);
        int maxX = Math.max(x1, x2);
        int minY = Math.min(y1, y2);
        int maxY = Math.max(y1, y2);
        int minZ = Math.min(z1, z2);
        int maxZ = Math.max(z1, z2);
        try {
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(config));
            writer.setIndent("  ");
            writer.beginObject();
            writer.name("components").beginArray();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        int compY = y - anchorY;
                        int compX = 0;
                        int compZ = 0;
                        if (dir == ForgeDirection.SOUTH) {
                            compX = anchorX - x;
                            compZ = anchorZ - z;
                        }
                        if (dir == ForgeDirection.NORTH) {
                            compX = x - anchorX;
                            compZ = z - anchorZ;
                        }
                        if (dir == ForgeDirection.WEST) {
                            compZ = x - anchorX;
                            compX = anchorZ - z;
                        }
                        if (dir == ForgeDirection.EAST) {
                            compZ = anchorX - x;
                            compX = z - anchorZ;
                        }
                        if (x == anchorX && y == anchorY && z == anchorZ) continue;
                        Block block = world.func_147439_a(x, y, z);
                        int meta = world.func_72805_g(x, y, z);
                        if (block == Blocks.field_150350_a) continue;
                        writer.beginObject().setIndent("");
                        writer.name("block").value(Block.field_149771_c.func_148750_c((Object)block));
                        writer.name("x").value((long)compX);
                        writer.name("y").value((long)compY);
                        writer.name("z").value((long)compZ);
                        writer.name("metas").beginArray().value((long)meta).endArray();
                        writer.endObject().setIndent("  ");
                    }
                }
            }
            writer.endArray();
            writer.endObject();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block b = world.func_147439_a(x, y, z);
        if (b == ModBlocks.cm_anchor) {
            ItemCMStructure.setAnchor(stack, x, y, z);
            return true;
        }
        if (ItemCMStructure.getAnchor(stack) == null) {
            return false;
        }
        if (!stack.field_77990_d.func_74764_b("x1")) {
            stack.field_77990_d.func_74768_a("x1", x);
            stack.field_77990_d.func_74768_a("y1", y);
            stack.field_77990_d.func_74768_a("z1", z);
        } else if (!stack.field_77990_d.func_74764_b("x2")) {
            stack.field_77990_d.func_74768_a("x2", x);
            stack.field_77990_d.func_74768_a("y2", y);
            stack.field_77990_d.func_74768_a("z2", z);
        } else {
            ItemCMStructure.writeToFile(file, stack, world);
            stack.field_77990_d.func_82580_o("x1");
            stack.field_77990_d.func_82580_o("y1");
            stack.field_77990_d.func_82580_o("z1");
            stack.field_77990_d.func_82580_o("x2");
            stack.field_77990_d.func_82580_o("y2");
            stack.field_77990_d.func_82580_o("z2");
        }
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        super.func_77624_a(stack, player, list, ext);
        list.add(EnumChatFormatting.YELLOW + "Click Custom Machine Structure Positioning Anchor to");
        list.add(EnumChatFormatting.YELLOW + "Confirm the location of the custom machine core block.");
        list.add(EnumChatFormatting.YELLOW + "Output all blocks between Position1 and Position2 with");
        list.add(EnumChatFormatting.YELLOW + "metadata to \"CMstructureOutput.txt\" in hbmConfig.");
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
        ArrayList<String> text = new ArrayList<String>();
        BlockPos anchor = ItemCMStructure.getAnchor(stack);
        if (anchor == null) {
            text.add(EnumChatFormatting.RED + "No Anchor");
        } else {
            int anchorX = stack.field_77990_d.func_74762_e("anchorX");
            int anchorY = stack.field_77990_d.func_74762_e("anchorY");
            int anchorZ = stack.field_77990_d.func_74762_e("anchorZ");
            text.add(EnumChatFormatting.GOLD + "Anchor: " + anchorX + " / " + anchorY + " / " + anchorZ);
            if (stack.field_77990_d.func_74764_b("x1")) {
                int x1 = stack.field_77990_d.func_74762_e("x1");
                int y1 = stack.field_77990_d.func_74762_e("y1");
                int z1 = stack.field_77990_d.func_74762_e("z1");
                text.add(EnumChatFormatting.YELLOW + "Position1: " + x1 + " / " + y1 + " / " + z1);
            }
            if (stack.field_77990_d.func_74764_b("x2")) {
                int x2 = stack.field_77990_d.func_74762_e("x2");
                int y2 = stack.field_77990_d.func_74762_e("y2");
                int z2 = stack.field_77990_d.func_74762_e("z2");
                text.add(EnumChatFormatting.YELLOW + "Position2: " + x2 + " / " + y2 + " / " + z2);
            }
        }
        ILookOverlay.printGeneric(event, this.func_77653_i(stack), 0xFFFF00, 0x404000, text);
    }
}

