/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ItemGenericPart;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemArcElectrode;
import com.hbm.items.machine.ItemFluidIcon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;

public class ArcWelderRecipes
extends SerializableRecipe {
    public static List<ArcWelderRecipe> recipes = new ArrayList<ArcWelderRecipe>();

    @Override
    public void registerDefaults() {
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.motor, 2), 100, 200L, new RecipesCommon.OreDictStack(OreDictManager.IRON.plate(), 2), new RecipesCommon.ComparableStack(ModItems.coil_copper), new RecipesCommon.ComparableStack(ModItems.coil_copper_torus)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.motor, 2), 100, 400L, new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 1), new RecipesCommon.ComparableStack(ModItems.coil_copper), new RecipesCommon.ComparableStack(ModItems.coil_copper_torus)));
        recipes.add(new ArcWelderRecipe(OreDictManager.DictFrame.fromOne(ModItems.part_generic, (Enum)ItemGenericPart.EnumPartType.LDE), 200, 5000L, new RecipesCommon.OreDictStack(OreDictManager.AL.plate(), 4), new RecipesCommon.OreDictStack(OreDictManager.FIBER.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.ANY_HARDPLASTIC.ingot())));
        recipes.add(new ArcWelderRecipe(OreDictManager.DictFrame.fromOne(ModItems.part_generic, (Enum)ItemGenericPart.EnumPartType.LDE), 200, 10000L, new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 2), new RecipesCommon.OreDictStack(OreDictManager.FIBER.ingot(), 4), new RecipesCommon.OreDictStack(OreDictManager.ANY_HARDPLASTIC.ingot())));
        recipes.add(new ArcWelderRecipe(OreDictManager.DictFrame.fromOne(ModItems.part_generic, (Enum)ItemGenericPart.EnumPartType.HDE), 600, 25000000L, new FluidStack(Fluids.STELLAR_FLUX, 4000), new RecipesCommon.OreDictStack(OreDictManager.ANY_BISMOIDBRONZE.plateCast(), 2), new RecipesCommon.OreDictStack(OreDictManager.CMB.plateWelded(), 1), new RecipesCommon.ComparableStack(ModItems.ingot_cft)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.wire_dense, 1, Mats.MAT_COPPER.id), 100, 10000L, new RecipesCommon.OreDictStack(OreDictManager.CU.wireFine(), 8)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.wire_dense, 1, Mats.MAT_ALLOY.id), 100, 10000L, new RecipesCommon.OreDictStack(OreDictManager.ALLOY.wireFine(), 8)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.wire_dense, 1, Mats.MAT_GOLD.id), 100, 10000L, new RecipesCommon.OreDictStack(OreDictManager.GOLD.wireFine(), 8)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.plate_welded, 1, Mats.MAT_IRON.id), 100, 100L, new RecipesCommon.OreDictStack(OreDictManager.IRON.plateCast(), 2)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.plate_welded, 1, Mats.MAT_STEEL.id), 100, 500L, new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateCast(), 2)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.plate_welded, 1, Mats.MAT_COPPER.id), 200, 1000L, new RecipesCommon.OreDictStack(OreDictManager.CU.plateCast(), 2)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.plate_welded, 1, Mats.MAT_TITANIUM.id), 600, 50000L, new RecipesCommon.OreDictStack(OreDictManager.TI.plateCast(), 2)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.plate_welded, 1, Mats.MAT_ZIRCONIUM.id), 600, 10000L, new RecipesCommon.OreDictStack(OreDictManager.ZR.plateCast(), 2)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.plate_welded, 1, Mats.MAT_ALUMINIUM.id), 300, 10000L, new RecipesCommon.OreDictStack(OreDictManager.AL.plateCast(), 2)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.plate_welded, 1, Mats.MAT_STAINLESS.id), 250, 20000L, new RecipesCommon.OreDictStack(OreDictManager.STAINLESS.plateCast(), 2)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.plate_welded, 1, Mats.MAT_TCALLOY.id), 1200, 1000000L, new FluidStack(Fluids.OXYGEN, 1000), new RecipesCommon.OreDictStack(OreDictManager.TCALLOY.plateCast(), 2)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.plate_welded, 1, Mats.MAT_CDALLOY.id), 1200, 1000000L, new FluidStack(Fluids.OXYGEN, 1000), new RecipesCommon.OreDictStack(OreDictManager.CDALLOY.plateCast(), 2)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.plate_welded, 1, Mats.MAT_TUNGSTEN.id), 1200, 250000L, new FluidStack(Fluids.OXYGEN, 1000), new RecipesCommon.OreDictStack(OreDictManager.W.plateCast(), 2)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.plate_welded, 1, Mats.MAT_CMB.id), 1200, 10000000L, new FluidStack(Fluids.REFORMGAS, 1000), new RecipesCommon.OreDictStack(OreDictManager.CMB.plateCast(), 2)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.plate_welded, 1, Mats.MAT_OSMIRIDIUM.id), 6000, 20000000L, new FluidStack(Fluids.REFORMGAS, 16000), new RecipesCommon.OreDictStack(OreDictManager.OSMIRIDIUM.plateCast(), 2)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.thruster_small), 60, 1000L, new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 4), new RecipesCommon.OreDictStack(OreDictManager.AL.wireFine(), 4), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 4)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.thruster_medium), 100, 2000L, new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 8), new RecipesCommon.ComparableStack(ModItems.motor, 1), new RecipesCommon.OreDictStack(OreDictManager.GRAPHITE.ingot(), 8)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.thruster_large), 200, 5000L, new RecipesCommon.OreDictStack(OreDictManager.DURA.ingot(), 10), new RecipesCommon.ComparableStack(ModItems.motor, 1), new RecipesCommon.OreDictStack(OreDictManager.getReflector(), 12)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.fuel_tank_small), 60, 1000L, new RecipesCommon.OreDictStack(OreDictManager.AL.plate(), 6), new RecipesCommon.OreDictStack(OreDictManager.CU.plate(), 4), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 4)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.fuel_tank_medium), 100, 2000L, new RecipesCommon.OreDictStack(OreDictManager.AL.plateCast(), 4), new RecipesCommon.OreDictStack(OreDictManager.TI.plate(), 8), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 12)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.fuel_tank_large), 200, 5000L, new RecipesCommon.OreDictStack(OreDictManager.AL.plateWelded(), 8), new RecipesCommon.OreDictStack(OreDictManager.BIGMT.plate(), 12), new RecipesCommon.ComparableStack(ModBlocks.steel_scaffold, 16)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.missile_anti_ballistic), 100, 5000L, new RecipesCommon.OreDictStack(OreDictManager.ANY_HIGHEXPLOSIVE.ingot(), 3), new RecipesCommon.ComparableStack(ModItems.missile_assembly), new RecipesCommon.ComparableStack(ModItems.thruster_small, 4)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.missile_generic), 100, 5000L, new RecipesCommon.ComparableStack(ModItems.warhead_generic_small), new RecipesCommon.ComparableStack(ModItems.fuel_tank_small), new RecipesCommon.ComparableStack(ModItems.thruster_small)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.missile_incendiary), 100, 5000L, new RecipesCommon.ComparableStack(ModItems.warhead_incendiary_small), new RecipesCommon.ComparableStack(ModItems.fuel_tank_small), new RecipesCommon.ComparableStack(ModItems.thruster_small)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.missile_cluster), 100, 5000L, new RecipesCommon.ComparableStack(ModItems.warhead_cluster_small), new RecipesCommon.ComparableStack(ModItems.fuel_tank_small), new RecipesCommon.ComparableStack(ModItems.thruster_small)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.missile_buster), 100, 5000L, new RecipesCommon.ComparableStack(ModItems.warhead_buster_small), new RecipesCommon.ComparableStack(ModItems.fuel_tank_small), new RecipesCommon.ComparableStack(ModItems.thruster_small)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.missile_decoy), 60, 2500L, new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot()), new RecipesCommon.ComparableStack(ModItems.fuel_tank_small), new RecipesCommon.ComparableStack(ModItems.thruster_small)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.missile_strong), 200, 10000L, new RecipesCommon.ComparableStack(ModItems.warhead_generic_medium), new RecipesCommon.ComparableStack(ModItems.fuel_tank_medium), new RecipesCommon.ComparableStack(ModItems.thruster_medium)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.missile_incendiary_strong), 200, 10000L, new RecipesCommon.ComparableStack(ModItems.warhead_incendiary_medium), new RecipesCommon.ComparableStack(ModItems.fuel_tank_medium), new RecipesCommon.ComparableStack(ModItems.thruster_medium)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.missile_cluster_strong), 200, 10000L, new RecipesCommon.ComparableStack(ModItems.warhead_cluster_medium), new RecipesCommon.ComparableStack(ModItems.fuel_tank_medium), new RecipesCommon.ComparableStack(ModItems.thruster_medium)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.missile_buster_strong), 200, 10000L, new RecipesCommon.ComparableStack(ModItems.warhead_buster_medium), new RecipesCommon.ComparableStack(ModItems.fuel_tank_medium), new RecipesCommon.ComparableStack(ModItems.thruster_medium)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.missile_emp_strong), 200, 10000L, new RecipesCommon.ComparableStack(ModBlocks.emp_bomb, 3), new RecipesCommon.ComparableStack(ModItems.fuel_tank_medium), new RecipesCommon.ComparableStack(ModItems.thruster_medium)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.missile_burst), 300, 25000L, new RecipesCommon.ComparableStack(ModItems.warhead_generic_large), new RecipesCommon.ComparableStack(ModItems.fuel_tank_medium, 2), new RecipesCommon.ComparableStack(ModItems.thruster_medium, 4)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.missile_inferno), 300, 25000L, new RecipesCommon.ComparableStack(ModItems.warhead_incendiary_large), new RecipesCommon.ComparableStack(ModItems.fuel_tank_medium, 2), new RecipesCommon.ComparableStack(ModItems.thruster_medium, 4)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.missile_rain), 300, 25000L, new RecipesCommon.ComparableStack(ModItems.warhead_cluster_large), new RecipesCommon.ComparableStack(ModItems.fuel_tank_medium, 2), new RecipesCommon.ComparableStack(ModItems.thruster_medium, 4)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.missile_drill), 300, 25000L, new RecipesCommon.ComparableStack(ModItems.warhead_buster_large), new RecipesCommon.ComparableStack(ModItems.fuel_tank_medium, 2), new RecipesCommon.ComparableStack(ModItems.thruster_medium, 4)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.missile_nuclear), 600, 50000L, new RecipesCommon.ComparableStack(ModItems.warhead_nuclear), new RecipesCommon.ComparableStack(ModItems.fuel_tank_large), new RecipesCommon.ComparableStack(ModItems.thruster_large, 3)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.missile_nuclear_cluster), 600, 50000L, new RecipesCommon.ComparableStack(ModItems.warhead_mirv), new RecipesCommon.ComparableStack(ModItems.fuel_tank_large), new RecipesCommon.ComparableStack(ModItems.thruster_large, 3)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.missile_volcano), 600, 50000L, new RecipesCommon.ComparableStack(ModItems.warhead_volcano), new RecipesCommon.ComparableStack(ModItems.fuel_tank_large), new RecipesCommon.ComparableStack(ModItems.thruster_large, 3)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.insert_cmb), 600, 50000L, new FluidStack(Fluids.NEON, 2000), new RecipesCommon.OreDictStack(OreDictManager.CMB.plate(), 2), new RecipesCommon.OreDictStack(OreDictManager.U238.ingot())));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.sat_mapper), 600, 10000L, new RecipesCommon.ComparableStack(ModItems.sat_base), new RecipesCommon.ComparableStack(ModItems.sat_head_mapper)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.sat_scanner), 600, 10000L, new RecipesCommon.ComparableStack(ModItems.sat_base), new RecipesCommon.ComparableStack(ModItems.sat_head_scanner)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.sat_radar), 600, 10000L, new RecipesCommon.ComparableStack(ModItems.sat_base), new RecipesCommon.ComparableStack(ModItems.sat_head_radar)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.sat_laser), 600, 50000L, new RecipesCommon.ComparableStack(ModItems.sat_base), new RecipesCommon.ComparableStack(ModItems.sat_head_laser)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.sat_resonator), 600, 50000L, new RecipesCommon.ComparableStack(ModItems.sat_base), new RecipesCommon.ComparableStack(ModItems.sat_head_resonator)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModBlocks.machine_xenon_thruster), 200, 50000L, new FluidStack(Fluids.ARGON, 1000), new RecipesCommon.OreDictStack(OreDictManager.W.plateWelded(), 2), new RecipesCommon.ComparableStack(ModItems.plate_stainless, 6), new RecipesCommon.ComparableStack(ModItems.arc_electrode, 1, ItemArcElectrode.EnumElectrodeType.GRAPHITE)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.rp_fuselage_20_1), 100, 20000L, new RecipesCommon.OreDictStack(OreDictManager.STAINLESS.plateWelded(), 1), new RecipesCommon.ComparableStack(ModItems.seg_20, 2), new RecipesCommon.OreDictStack(OreDictManager.TI.shell(), 1)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.rp_fuselage_20_3), 150, 30000L, new RecipesCommon.OreDictStack(OreDictManager.STAINLESS.plateWelded(), 1), new RecipesCommon.ComparableStack(ModItems.rp_fuselage_20_1), new RecipesCommon.OreDictStack(OreDictManager.TI.shell(), 2)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.rp_fuselage_20_6), 200, 50000L, new RecipesCommon.OreDictStack(OreDictManager.STAINLESS.plateWelded(), 2), new RecipesCommon.ComparableStack(ModItems.rp_fuselage_20_3), new RecipesCommon.OreDictStack(OreDictManager.TI.shell(), 3)));
        recipes.add(new ArcWelderRecipe(new ItemStack(ModItems.rp_fuselage_20_12), 250, 60000L, new FluidStack(Fluids.OXYGEN, 500), new RecipesCommon.OreDictStack(OreDictManager.STAINLESS.plateWelded(), 4), new RecipesCommon.ComparableStack(ModItems.rp_fuselage_20_6), new RecipesCommon.OreDictStack(OreDictManager.TI.shell(), 6)));
    }

    public static HashMap getRecipes() {
        HashMap<Object[], ItemStack> recipes = new HashMap<Object[], ItemStack>();
        for (ArcWelderRecipe recipe : ArcWelderRecipes.recipes) {
            int size = recipe.ingredients.length + (recipe.fluid != null ? 1 : 0);
            Object[] array = new Object[size];
            for (int i = 0; i < recipe.ingredients.length; ++i) {
                array[i] = recipe.ingredients[i];
            }
            if (recipe.fluid != null) {
                array[size - 1] = ItemFluidIcon.make(recipe.fluid);
            }
            recipes.put(array, recipe.output);
        }
        return recipes;
    }

    public static ArcWelderRecipe getRecipe(ItemStack ... inputs) {
        block0: for (ArcWelderRecipe recipe : recipes) {
            ArrayList<RecipesCommon.AStack> recipeList = new ArrayList<RecipesCommon.AStack>();
            for (RecipesCommon.AStack ingredient : recipe.ingredients) {
                recipeList.add(ingredient);
            }
            for (int i = 0; i < inputs.length; ++i) {
                ItemStack inputStack = inputs[i];
                if (inputStack == null) continue;
                boolean hasMatch = false;
                for (RecipesCommon.AStack recipeStack : recipeList) {
                    if (!recipeStack.matchesRecipe(inputStack, true) || inputStack.field_77994_a < recipeStack.stacksize) continue;
                    hasMatch = true;
                    recipeList.remove(recipeStack);
                    break;
                }
                if (!hasMatch) continue block0;
            }
            if (!recipeList.isEmpty()) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public String getFileName() {
        return "hbmArcWelder.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = (JsonObject)recipe;
        RecipesCommon.AStack[] inputs = ArcWelderRecipes.readAStackArray(obj.get("inputs").getAsJsonArray());
        FluidStack fluid = obj.has("fluid") ? ArcWelderRecipes.readFluidStack(obj.get("fluid").getAsJsonArray()) : null;
        ItemStack output = ArcWelderRecipes.readItemStack(obj.get("output").getAsJsonArray());
        int duration = obj.get("duration").getAsInt();
        long consumption = obj.get("consumption").getAsLong();
        recipes.add(new ArcWelderRecipe(output, duration, consumption, fluid, inputs));
    }

    @Override
    public void writeRecipe(Object obj, JsonWriter writer) throws IOException {
        ArcWelderRecipe recipe = (ArcWelderRecipe)obj;
        writer.name("inputs").beginArray();
        for (RecipesCommon.AStack aStack : recipe.ingredients) {
            ArcWelderRecipes.writeAStack(aStack, writer);
        }
        writer.endArray();
        if (recipe.fluid != null) {
            writer.name("fluid");
            ArcWelderRecipes.writeFluidStack(recipe.fluid, writer);
        }
        writer.name("output");
        ArcWelderRecipes.writeItemStack(recipe.output, writer);
        writer.name("duration").value((long)recipe.duration);
        writer.name("consumption").value(recipe.consumption);
    }

    public static class ArcWelderRecipe {
        public RecipesCommon.AStack[] ingredients;
        public FluidStack fluid;
        public ItemStack output;
        public int duration;
        public long consumption;

        public ArcWelderRecipe(ItemStack output, int duration, long consumption, FluidStack fluid, RecipesCommon.AStack ... ingredients) {
            this.ingredients = ingredients;
            this.fluid = fluid;
            this.output = output;
            this.duration = duration;
            this.consumption = consumption;
        }

        public ArcWelderRecipe(ItemStack output, int duration, long consumption, RecipesCommon.AStack ... ingredients) {
            this(output, duration, consumption, (FluidStack)null, ingredients);
        }
    }
}

