/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion.vanillant.standard;

import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.interfaces.IBlockMutator;
import com.hbm.explosion.vanillant.interfaces.IBlockProcessor;
import com.hbm.explosion.vanillant.interfaces.IDropChanceMutator;
import com.hbm.explosion.vanillant.interfaces.IFortuneMutator;
import com.hbm.explosion.vanillant.standard.DropChanceMutatorStandard;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;

public class BlockProcessorStandard
implements IBlockProcessor {
    protected IDropChanceMutator chance;
    protected IFortuneMutator fortune;
    protected IBlockMutator convert;

    public BlockProcessorStandard withChance(IDropChanceMutator chance) {
        this.chance = chance;
        return this;
    }

    public BlockProcessorStandard withFortune(IFortuneMutator fortune) {
        this.fortune = fortune;
        return this;
    }

    public BlockProcessorStandard withBlockEffect(IBlockMutator convert) {
        this.convert = convert;
        return this;
    }

    @Override
    public void process(ExplosionVNT explosion, World world, double x, double y, double z, HashSet<ChunkPosition> affectedBlocks) {
        Block block;
        int blockZ;
        int blockY;
        int blockX;
        Iterator<ChunkPosition> iterator = affectedBlocks.iterator();
        float dropChance = 1.0f / explosion.size;
        while (iterator.hasNext()) {
            ChunkPosition chunkposition = iterator.next();
            blockX = chunkposition.field_151329_a;
            blockY = chunkposition.field_151327_b;
            blockZ = chunkposition.field_151328_c;
            block = world.func_147439_a(blockX, blockY, blockZ);
            if (block.func_149688_o() != Material.field_151579_a) {
                if (block.func_149659_a(null)) {
                    if (this.chance != null) {
                        dropChance = this.chance.mutateDropChance(explosion, block, blockX, blockY, blockZ, dropChance);
                    }
                    int dropFortune = this.fortune == null ? 0 : this.fortune.mutateFortune(explosion, block, blockX, blockY, blockZ);
                    block.func_149690_a(world, blockX, blockY, blockZ, world.func_72805_g(blockX, blockY, blockZ), dropChance, dropFortune);
                }
                block.onBlockExploded(world, blockX, blockY, blockZ, explosion.compat);
                if (this.convert == null) continue;
                this.convert.mutatePre(explosion, block, world.func_72805_g(blockX, blockY, blockZ), blockX, blockY, blockZ);
                continue;
            }
            iterator.remove();
        }
        if (this.convert != null) {
            for (ChunkPosition chunkposition : affectedBlocks) {
                blockX = chunkposition.field_151329_a;
                blockY = chunkposition.field_151327_b;
                blockZ = chunkposition.field_151328_c;
                block = world.func_147439_a(blockX, blockY, blockZ);
                if (block.func_149688_o() != Material.field_151579_a) continue;
                this.convert.mutatePost(explosion, blockX, blockY, blockZ);
            }
        }
    }

    public BlockProcessorStandard setNoDrop() {
        this.chance = new DropChanceMutatorStandard(0.0f);
        return this;
    }

    public BlockProcessorStandard setAllDrop() {
        this.chance = new DropChanceMutatorStandard(1.0f);
        return this;
    }

    public BlockProcessorStandard setFortune(final int fortune) {
        this.fortune = new IFortuneMutator(){

            @Override
            public int mutateFortune(ExplosionVNT explosion, Block block, int x, int y, int z) {
                return fortune;
            }
        };
        return this;
    }
}

