/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.logic;

import com.google.common.collect.ImmutableSet;
import com.hbm.entity.logic.IChunkLoader;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.MainRegistry;
import com.hbm.particle.helper.ExplosionCreator;
import com.hbm.particle.helper.ExplosionSmallCreator;
import com.hbm.util.ParticleUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public abstract class EntityPlaneBase
extends Entity
implements IChunkLoader {
    protected int turnProgress;
    protected double syncPosX;
    protected double syncPosY;
    protected double syncPosZ;
    protected double syncYaw;
    protected double syncPitch;
    @SideOnly(value=Side.CLIENT)
    protected double velocityX;
    @SideOnly(value=Side.CLIENT)
    protected double velocityY;
    @SideOnly(value=Side.CLIENT)
    protected double velocityZ;
    private ForgeChunkManager.Ticket loaderTicket;
    private List<ChunkCoordIntPair> loadedChunks = new ArrayList<ChunkCoordIntPair>();
    public float health = this.getMaxHealth();
    public int timer = this.getLifetime();

    public EntityPlaneBase(World world) {
        super(world);
    }

    public float getMaxHealth() {
        return 50.0f;
    }

    public int getLifetime() {
        return 200;
    }

    public boolean func_70067_L() {
        return this.health > 0.0f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == ModDamageSource.nuclearBlast) {
            return false;
        }
        if (this.func_85032_ar()) {
            return false;
        }
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K && this.health > 0.0f) {
            this.health -= amount;
            if (this.health <= 0.0f) {
                this.killPlane();
            }
        }
        return true;
    }

    protected void killPlane() {
        ExplosionSmallCreator.composeEffect(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 25, 3.5f, 2.0f);
        this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "hbm:entity.planeShotDown", 25.0f, 1.0f);
    }

    protected void func_70088_a() {
        this.init(ForgeChunkManager.requestTicket((Object)MainRegistry.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY));
        this.field_70180_af.func_75682_a(17, (Object)new Float(50.0f));
    }

    @Override
    public void init(ForgeChunkManager.Ticket ticket) {
        if (!this.field_70170_p.field_72995_K && ticket != null) {
            if (this.loaderTicket == null) {
                this.loaderTicket = ticket;
                this.loaderTicket.bindEntity((Entity)this);
                this.loaderTicket.getModData();
            }
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.field_70176_ah, this.field_70164_aj));
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(17, (Object)Float.valueOf(this.health));
        } else {
            this.health = this.field_70180_af.func_111145_d(17);
        }
        if (this.field_70170_p.field_72995_K) {
            this.field_70142_S = this.field_70165_t;
            this.field_70137_T = this.field_70163_u;
            this.field_70136_U = this.field_70161_v;
            if (this.turnProgress > 0) {
                double interpX = this.field_70165_t + (this.syncPosX - this.field_70165_t) / (double)this.turnProgress;
                double interpY = this.field_70163_u + (this.syncPosY - this.field_70163_u) / (double)this.turnProgress;
                double interpZ = this.field_70161_v + (this.syncPosZ - this.field_70161_v) / (double)this.turnProgress;
                double d = MathHelper.func_76138_g((double)(this.syncYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + d / (double)this.turnProgress);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.syncPitch - (double)this.field_70125_A) / (double)this.turnProgress);
                --this.turnProgress;
                this.func_70107_b(interpX, interpY, interpZ);
            } else {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
        } else {
            this.field_70142_S = this.field_70169_q = this.field_70165_t;
            this.field_70137_T = this.field_70167_r = this.field_70163_u;
            this.field_70136_U = this.field_70166_s = this.field_70161_v;
            this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            this.rotation();
            if (this.health <= 0.0f) {
                this.field_70181_x -= 0.025;
                for (int i = 0; i < 10; ++i) {
                    ParticleUtil.spawnGasFlame(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian() * 0.5 - this.field_70159_w * 2.0, this.field_70163_u + this.field_70146_Z.nextGaussian() * 0.5 - this.field_70181_x * 2.0, this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.5 - this.field_70179_y * 2.0, 0.0, 0.1, 0.0);
                }
                if (!this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v).isAir((IBlockAccess)this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) || this.field_70163_u < 0.0) {
                    this.func_70106_y();
                    ExplosionCreator.composeEffectLarge(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    new ExplosionVNT(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 15.0f).makeStandard().explode();
                    this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "hbm:entity.planeCrash", 25.0f, 1.0f);
                    return;
                }
            } else {
                this.field_70181_x = 0.0;
            }
            if (this.field_70173_aa > this.timer) {
                this.func_70106_y();
            }
            this.loadNeighboringChunks((int)Math.floor(this.field_70165_t / 16.0), (int)Math.floor(this.field_70161_v / 16.0));
        }
    }

    protected void rotation() {
        float motionHorizontal = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, motionHorizontal) * 180.0 / Math.PI) - 90.0f;
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double velX, double velY, double velZ) {
        this.velocityX = this.field_70159_w = velX;
        this.velocityY = this.field_70181_x = velY;
        this.velocityZ = this.field_70179_y = velZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int theNumberThree) {
        this.syncPosX = x;
        this.syncPosY = y;
        this.syncPosZ = z;
        this.syncYaw = yaw;
        this.syncPitch = pitch;
        this.turnProgress = theNumberThree;
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.clearChunkLoader();
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.field_70173_aa = nbt.func_74762_e("ticksExisted");
        this.func_70096_w().func_75692_b(17, (Object)Float.valueOf(nbt.func_74760_g("health")));
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("ticksExisted", this.field_70173_aa);
        nbt.func_74776_a("health", this.func_70096_w().func_111145_d(17));
    }

    public void clearChunkLoader() {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.loaderTicket);
            this.loaderTicket = null;
        }
    }

    public void loadNeighboringChunks(int newChunkX, int newChunkZ) {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            for (ChunkCoordIntPair chunk : ImmutableSet.copyOf((Collection)this.loaderTicket.getChunkList())) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)chunk);
            }
            this.loadedChunks.clear();
            this.loadedChunks.add(new ChunkCoordIntPair(newChunkX, newChunkZ));
            for (ChunkCoordIntPair chunk : this.loadedChunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)chunk);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }
}

