/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.item;

import com.hbm.items.ModItems;
import com.hbm.util.TrackerUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityBoatRubber
extends Entity {
    private boolean isBoatEmpty = true;
    private double speedMultiplier = 0.07;
    private int boatPosRotationIncrements;
    private double boatX;
    private double boatY;
    private double boatZ;
    private double boatYaw;
    private double boatPitch;
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double velocityZ;
    public float prevRenderYaw;

    public EntityBoatRubber(World world) {
        super(world);
        this.field_70156_m = true;
        this.func_70105_a(1.5f, 0.6f);
        this.field_70129_M = this.field_70131_O / 2.0f;
    }

    public EntityBoatRubber(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y + (double)this.field_70129_M, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(17, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(18, (Object)new Integer(1));
        this.field_70180_af.func_75682_a(19, (Object)new Float(0.0f));
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity.field_70121_D;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.0 - 0.3;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean hitByCreative;
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = hitByCreative = source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (hitByCreative || this.getDamageTaken() > 40.0f) {
                if (this.field_70153_n != null) {
                    this.field_70153_n.func_70078_a((Entity)this);
                }
                if (!hitByCreative) {
                    this.dropBoat();
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int interp) {
        if (this.isBoatEmpty) {
            this.boatPosRotationIncrements = interp;
        } else {
            double d3 = x - this.field_70165_t;
            double d4 = y - this.field_70163_u;
            double d5 = z - this.field_70161_v;
            double d6 = d3 * d3 + d4 * d4 + d5 * d5;
            if (d6 <= 1.0) {
                return;
            }
            this.boatPosRotationIncrements = 3;
        }
        this.boatX = x;
        this.boatY = y;
        this.boatZ = z;
        this.boatYaw = yaw;
        this.boatPitch = pitch;
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.velocityX = this.field_70159_w = x;
        this.velocityY = this.field_70181_x = y;
        this.velocityZ = this.field_70179_y = z;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        int b0 = 5;
        double d0 = 0.0;
        for (int i = 0; i < b0; ++i) {
            double d1 = this.field_70121_D.field_72338_b + (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) * (double)(i + 0) / (double)b0 - 0.125;
            double d3 = this.field_70121_D.field_72338_b + (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) * (double)(i + 1) / (double)b0 - 0.125;
            AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)this.field_70121_D.field_72340_a, (double)d1, (double)this.field_70121_D.field_72339_c, (double)this.field_70121_D.field_72336_d, (double)d3, (double)this.field_70121_D.field_72334_f);
            if (!this.field_70170_p.func_72830_b(axisalignedbb, Material.field_151586_h)) continue;
            d0 += 1.0 / (double)b0;
        }
        if (this.field_70170_p.field_72995_K && this.isBoatEmpty) {
            double y;
            double x;
            if (this.boatPosRotationIncrements > 0) {
                x = this.field_70165_t + (this.boatX - this.field_70165_t) / (double)this.boatPosRotationIncrements;
                y = this.field_70163_u + (this.boatY - this.field_70163_u) / (double)this.boatPosRotationIncrements;
                double z = this.field_70161_v + (this.boatZ - this.field_70161_v) / (double)this.boatPosRotationIncrements;
                double yaw = MathHelper.func_76138_g((double)(this.boatYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + yaw / (double)this.boatPosRotationIncrements);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.boatPitch - (double)this.field_70125_A) / (double)this.boatPosRotationIncrements);
                --this.boatPosRotationIncrements;
                this.func_70107_b(x, y, z);
            } else {
                x = this.field_70165_t + this.field_70159_w;
                y = this.field_70163_u + this.field_70181_x;
                double z = this.field_70161_v + this.field_70179_y;
                this.func_70107_b(x, y, z);
                if (this.field_70122_E) {
                    this.field_70159_w *= 0.5;
                    this.field_70181_x *= 0.5;
                    this.field_70179_y *= 0.5;
                }
                this.passiveDeccelerate();
            }
        } else {
            if (d0 < 1.0) {
                double d2 = d0 * 2.0 - 1.0;
                this.field_70181_x += 0.04 * d2;
            } else {
                if (this.field_70181_x < 0.0) {
                    this.field_70181_x /= 2.0;
                }
                this.field_70181_x += (double)0.007f;
            }
            double prevSpeedSq = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            this.field_70160_al = false;
            if (this.field_70153_n != null && this.field_70153_n instanceof EntityLivingBase) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)this.field_70153_n;
                if (entitylivingbase.field_70701_bs != 0.0f || entitylivingbase.field_70702_br != 0.0f) {
                    Vec3 dir = Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0);
                    dir.func_72442_b((float)(-((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0)));
                    this.field_70159_w += dir.field_72450_a * this.speedMultiplier * (double)entitylivingbase.field_70701_bs * 0.05;
                    this.field_70179_y += dir.field_72449_c * this.speedMultiplier * (double)entitylivingbase.field_70701_bs * 0.05;
                    float prevYaw = this.field_70177_z;
                    this.field_70177_z -= entitylivingbase.field_70702_br * 3.0f;
                    Vec3 newMotion = Vec3.func_72443_a((double)this.field_70159_w, (double)0.0, (double)this.field_70179_y);
                    newMotion.func_72442_b((float)((double)(-(this.field_70177_z - prevYaw)) * Math.PI / 180.0));
                    this.field_70159_w = newMotion.field_72450_a;
                    this.field_70179_y = newMotion.field_72449_c;
                    EntityTrackerEntry entry = TrackerUtil.getTrackerEntry((WorldServer)this.field_70170_p, this.func_145782_y());
                    entry.field_73127_g = MathHelper.func_76141_d((float)(this.field_70177_z * 256.0f / 360.0f)) + 10;
                }
            } else {
                this.field_70159_w *= 0.95;
                this.field_70181_x *= 0.95;
                this.field_70179_y *= 0.95;
            }
            double speedSq = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            if (speedSq > 0.5) {
                double d4 = 0.5 / speedSq;
                this.field_70159_w *= d4;
                this.field_70179_y *= d4;
                speedSq = 0.5;
            }
            if (speedSq > prevSpeedSq && this.speedMultiplier < 0.5) {
                this.speedMultiplier += (0.5 - this.speedMultiplier) / 50.0;
                if (this.speedMultiplier > 0.5) {
                    this.speedMultiplier = 0.5;
                }
            } else {
                this.speedMultiplier -= (this.speedMultiplier - 0.07) / 35.0;
                if (this.speedMultiplier < 0.07) {
                    this.speedMultiplier = 0.07;
                }
            }
            for (int index = 0; index < 4; ++index) {
                int x = MathHelper.func_76128_c((double)(this.field_70165_t + ((double)(index % 2) - 0.5) * 0.8));
                int z = MathHelper.func_76128_c((double)(this.field_70161_v + ((double)(index / 2) - 0.5) * 0.8));
                for (int yOff = 0; yOff < 2; ++yOff) {
                    int y = MathHelper.func_76128_c((double)this.field_70163_u) + yOff;
                    Block block = this.field_70170_p.func_147439_a(x, y, z);
                    if (block == Blocks.field_150431_aC) {
                        this.field_70170_p.func_147468_f(x, y, z);
                        this.field_70123_F = false;
                        continue;
                    }
                    if (block != Blocks.field_150392_bi) continue;
                    this.field_70170_p.func_147480_a(x, y, z, true);
                    this.field_70123_F = false;
                }
            }
            if (this.field_70122_E) {
                this.field_70159_w *= 0.5;
                this.field_70181_x *= 0.5;
                this.field_70179_y *= 0.5;
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (this.field_70123_F && prevSpeedSq > 0.2) {
                this.field_70159_w *= 0.25;
                this.field_70181_x *= 0.25;
                this.field_70179_y *= 0.25;
            } else {
                this.passiveDeccelerate();
            }
            this.field_70125_A = 0.0f;
            if (!(this.field_70153_n instanceof EntityLivingBase)) {
                double rotationSpeed;
                double yaw = this.field_70177_z;
                double deltaX = this.field_70169_q - this.field_70165_t;
                double deltaZ = this.field_70166_s - this.field_70161_v;
                if (deltaX * deltaX + deltaZ * deltaZ > 0.001) {
                    yaw = (float)(Math.atan2(deltaZ, deltaX) * 180.0 / Math.PI);
                }
                if ((rotationSpeed = MathHelper.func_76138_g((double)(yaw - (double)this.field_70177_z))) > 20.0) {
                    rotationSpeed = 20.0;
                }
                if (rotationSpeed < -20.0) {
                    rotationSpeed = -20.0;
                }
                this.field_70177_z = (float)((double)this.field_70177_z + rotationSpeed);
            }
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            if (!this.field_70170_p.field_72995_K) {
                List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(0.2, 0.0, 0.2));
                if (list != null && !list.isEmpty()) {
                    for (int k1 = 0; k1 < list.size(); ++k1) {
                        Entity entity = (Entity)list.get(k1);
                        if (entity == this.field_70153_n || !entity.func_70104_M() || !(entity instanceof EntityBoatRubber) && !(entity instanceof EntityBoat)) continue;
                        entity.func_70108_f((Entity)this);
                    }
                }
                if (this.field_70153_n != null && this.field_70153_n.field_70128_L) {
                    this.field_70153_n = null;
                }
            }
        }
        double moX = this.field_70169_q - this.field_70165_t;
        double moZ = this.field_70166_s - this.field_70161_v;
        double prevSpeedSq = Math.sqrt(moX * moX + moZ * moZ);
        if (prevSpeedSq > 0.2625) {
            double cosYaw = Math.cos((double)this.field_70177_z * Math.PI / 180.0);
            double sinYaw = Math.sin((double)this.field_70177_z * Math.PI / 180.0);
            for (double j = 0.0; j < 1.0 + prevSpeedSq * 60.0; j += 1.0) {
                double magZ;
                double magX;
                double offset = this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
                double side = (double)(this.field_70146_Z.nextInt(2) * 2 - 1) * 0.7;
                if (this.field_70146_Z.nextBoolean()) {
                    magX = this.field_70165_t - cosYaw * offset * 0.8 + sinYaw * side;
                    magZ = this.field_70161_v - sinYaw * offset * 0.8 - cosYaw * side;
                    this.field_70170_p.func_72869_a("splash", magX, this.field_70163_u - 0.125, magZ, moX, 0.1, moZ);
                    continue;
                }
                magX = this.field_70165_t + cosYaw + sinYaw * offset * 0.7;
                magZ = this.field_70161_v + sinYaw - cosYaw * offset * 0.7;
                this.field_70170_p.func_72869_a("splash", magX, this.field_70163_u - 0.125, magZ, moX, 0.1, moZ);
            }
        }
    }

    protected void passiveDeccelerate() {
        this.field_70159_w *= 0.99;
        this.field_70181_x *= 0.95;
        this.field_70179_y *= 0.99;
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            double offX = Math.cos((double)this.field_70177_z * Math.PI / 180.0) * 0.4;
            double offZ = Math.sin((double)this.field_70177_z * Math.PI / 180.0) * 0.4;
            this.field_70153_n.func_70107_b(this.field_70165_t + offX, this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W(), this.field_70161_v + offZ);
            if (this.field_70153_n instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)this.field_70153_n;
                player.field_70761_aq = MathHelper.func_76142_g((float)(this.field_70177_z + 90.0f));
            }
        }
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public boolean func_130002_c(EntityPlayer player) {
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && this.field_70153_n != player) {
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            player.func_70078_a((Entity)this);
        }
        return true;
    }

    protected void func_70064_a(double fall, boolean onGround) {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70163_u);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        if (onGround) {
            if (this.field_70143_R > 5.0f) {
                this.func_70069_a(this.field_70143_R);
                if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                    this.func_70106_y();
                    this.dropBoat();
                }
                this.field_70143_R = 0.0f;
            }
        } else if (this.field_70170_p.func_147439_a(x, y - 1, z).func_149688_o() != Material.field_151586_h && fall < 0.0) {
            this.field_70143_R = (float)((double)this.field_70143_R - fall);
        }
    }

    public void dropBoat() {
        this.func_145778_a(ModItems.boat_rubber, 1, 0.0f);
    }

    public void setDamageTaken(float amount) {
        this.field_70180_af.func_75692_b(19, (Object)Float.valueOf(amount));
    }

    public float getDamageTaken() {
        return this.field_70180_af.func_111145_d(19);
    }

    public void setTimeSinceHit(int time) {
        this.field_70180_af.func_75692_b(17, (Object)time);
    }

    public int getTimeSinceHit() {
        return this.field_70180_af.func_75679_c(17);
    }

    public void setForwardDirection(int dir) {
        this.field_70180_af.func_75692_b(18, (Object)dir);
    }

    public int getForwardDirection() {
        return this.field_70180_af.func_75679_c(18);
    }

    @SideOnly(value=Side.CLIENT)
    public void setIsBoatEmpty(boolean empty) {
        this.isBoatEmpty = empty;
    }
}

