/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.orbit;

import com.hbm.dim.CelestialBody;
import com.hbm.dim.SolarSystem;
import com.hbm.dim.WorldProviderCelestial;
import com.hbm.dim.orbit.BiomeGenOrbit;
import com.hbm.dim.orbit.ChunkProviderOrbit;
import com.hbm.dim.orbit.OrbitalStation;
import com.hbm.dim.orbit.SkyProviderOrbit;
import com.hbm.dim.trait.CBT_Atmosphere;
import com.hbm.dim.trait.CBT_Destroyed;
import com.hbm.handler.atmosphere.ChunkAtmosphereManager;
import com.hbm.lib.Library;
import com.hbm.util.BobMathUtil;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.WorldChunkManagerHell;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.IRenderHandler;

public class WorldProviderOrbit
extends WorldProvider {
    private static final float ORBITAL_PERIOD = 7200.0f;
    public List<SolarSystem.AstroMetric> metrics;
    private double eclipseAmount;
    private float celestialAngle;

    protected float getOrbitalAltitude(CelestialBody body) {
        return this.getAltitudeForPeriod(body.massKg, 7200.0f);
    }

    private float getAltitudeForPeriod(float massKg, float period) {
        return (float)Math.cbrt((double)(6.6743014E-11f * massKg * (period * period)) / 39.47841760435743);
    }

    public float getSunPower() {
        double progress = OrbitalStation.clientStation.getTransferProgress(0.0f);
        float sunPower = OrbitalStation.clientStation.orbiting.getSunPower();
        if (progress > 0.0) {
            return (float)BobMathUtil.lerp(progress, sunPower, OrbitalStation.clientStation.target.getSunPower());
        }
        return sunPower;
    }

    public void func_76572_b() {
        this.field_76578_c = new WorldChunkManagerHell(BiomeGenOrbit.biome, 0.0f);
    }

    public String func_80007_l() {
        return "Orbit";
    }

    public IChunkProvider func_76555_c() {
        return new ChunkProviderOrbit(this.field_76579_a);
    }

    public void updateWeather() {
        this.field_76575_d = !this.field_76579_a.field_72995_K && !Loader.isModLoaded((String)"CoFHCore");
        this.field_76579_a.func_72912_H().func_76080_g(0);
        this.field_76579_a.func_72912_H().func_76084_b(false);
        this.field_76579_a.func_72912_H().func_76090_f(0);
        this.field_76579_a.func_72912_H().func_76069_a(false);
        this.field_76579_a.field_73004_o = 0.0f;
        this.field_76579_a.field_73017_q = 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateSky(float partialTicks) {
        CelestialBody body = CelestialBody.getBody(this.field_76579_a);
        OrbitalStation station = OrbitalStation.clientStation;
        double sunSize = SolarSystem.calculateSunSize(body);
        double progress = station.getTransferProgress(partialTicks);
        if (station.state == OrbitalStation.StationState.ORBIT) {
            double altitude = this.getOrbitalAltitude(station.orbiting);
            this.metrics = SolarSystem.calculateMetricsFromSatellite(this.field_76579_a, partialTicks, station.orbiting, altitude);
        } else {
            double fromAlt = this.getOrbitalAltitude(station.orbiting);
            double toAlt = this.getOrbitalAltitude(station.target);
            this.metrics = SolarSystem.calculateMetricsBetweenSatelliteOrbits(this.field_76579_a, partialTicks, station.orbiting, station.target, fromAlt, toAlt, progress);
        }
        CelestialBody orbiting = station.orbiting;
        CelestialBody target = station.target;
        float angle = (float)SolarSystem.calculateSingleAngle(this.field_76579_a, partialTicks, this.metrics, orbiting, this.getOrbitalAltitude(orbiting));
        if (progress > 0.0) {
            angle = (float)BobMathUtil.lerp(progress, angle, (float)SolarSystem.calculateSingleAngle(this.field_76579_a, partialTicks, this.metrics, target, this.getOrbitalAltitude(target)));
        }
        this.celestialAngle = 0.5f - angle / 360.0f;
        this.eclipseAmount = WorldProviderCelestial.getEclipseFactor(this.metrics, sunSize);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_76562_b(float x, float y) {
        return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 getSkyColor(Entity camera, float partialTicks) {
        this.updateSky(partialTicks);
        return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    }

    @SideOnly(value=Side.CLIENT)
    public float[] func_76560_a(float solarAngle, float partialTicks) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float distanceStart = 9000000.0f;
        float distanceEnd = 3.0E7f;
        double progress = OrbitalStation.clientStation.getTransferProgress(par1);
        float semiMajorAxisKm = OrbitalStation.clientStation.orbiting.getPlanet().semiMajorAxisKm;
        if (progress > 0.0) {
            semiMajorAxisKm = (float)BobMathUtil.lerp(progress, semiMajorAxisKm, OrbitalStation.clientStation.target.getPlanet().semiMajorAxisKm);
        }
        float distanceFactor = MathHelper.func_76131_a((float)((semiMajorAxisKm - distanceStart) / (distanceEnd - distanceStart)), (float)0.0f, (float)1.0f);
        float solarAngle = this.field_76579_a.func_72826_c(par1);
        float celestialPhase = (1.0f - (solarAngle + 0.5f) % 1.0f) * 2.0f - 1.0f;
        float starBrightness = (float)Library.smoothstep((double)Math.abs(celestialPhase), 0.6, 0.75);
        return MathHelper.func_76131_a((float)starBrightness, (float)distanceFactor, (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float par1) {
        if (SolarSystem.kerbol.hasTrait(CBT_Destroyed.class)) {
            return 0.0f;
        }
        float solarAngle = this.field_76579_a.func_72826_c(par1);
        float celestialPhase = (1.0f - (solarAngle + 0.5f) % 1.0f) * 2.0f - 1.0f;
        float sunBrightness = 1.0f - (float)Library.smoothstep((double)Math.abs(celestialPhase), 0.6, 0.8);
        sunBrightness = (float)((double)sunBrightness * (1.0 - this.eclipseAmount * 0.6));
        return sunBrightness;
    }

    public boolean canDoLightning(Chunk chunk) {
        return false;
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76571_f() {
        return -99999.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        return new SkyProviderOrbit();
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        return this.celestialAngle;
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        ChunkCoordinates coords = player.getBedLocation(this.field_76574_g);
        if (coords == null) {
            return 0;
        }
        CBT_Atmosphere atmosphere = ChunkAtmosphereManager.proxy.getAtmosphere(this.field_76579_a, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
        if (!ChunkAtmosphereManager.proxy.canBreathe(atmosphere)) {
            return 0;
        }
        return this.field_76574_g;
    }

    public boolean func_76567_e() {
        if (WorldProviderCelestial.attemptingSleep) {
            WorldProviderCelestial.attemptingSleep = false;
            return true;
        }
        return false;
    }
}

