/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.network;

import api.hbm.block.IToolable;
import com.hbm.blocks.IBlockMultiPass;
import com.hbm.interfaces.ICopiable;
import com.hbm.main.MainRegistry;
import com.hbm.render.block.RenderBlockMultipass;
import com.hbm.tileentity.network.TileEntityPneumoTube;
import com.hbm.util.Compat;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class PneumoTubePaintableBlock
extends BlockContainer
implements IToolable,
IBlockMultiPass {
    @SideOnly(value=Side.CLIENT)
    public IIcon overlay;
    @SideOnly(value=Side.CLIENT)
    public IIcon overlayIn;
    @SideOnly(value=Side.CLIENT)
    public IIcon overlayOut;

    public PneumoTubePaintableBlock() {
        super(Material.field_151573_f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityPneumoTubePaintable();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a("hbm:pneumatic_tube_paintable");
        this.overlay = reg.func_94245_a("hbm:pneumatic_tube_paintable_overlay");
        this.overlayIn = reg.func_94245_a("hbm:pneumatic_tube_paintable_overlay_in");
        this.overlayOut = reg.func_94245_a("hbm:pneumatic_tube_paintable_overlay_out");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityPneumoTubePaintable) {
            TileEntityPneumoTubePaintable tube = (TileEntityPneumoTubePaintable)tile;
            if (RenderBlockMultipass.currentPass == 0) {
                if (tube.block != null) {
                    return tube.block.func_149691_a(side, tube.meta);
                }
                return this.field_149761_L;
            }
            if (tube.ejectionDir.ordinal() == side) {
                return this.overlayIn;
            }
            if (tube.insertionDir.ordinal() == side) {
                return this.overlayOut;
            }
            return this.overlay;
        }
        return this.field_149761_L;
    }

    @Override
    public int getPasses() {
        return 2;
    }

    public int func_149645_b() {
        return IBlockMultiPass.getRenderType();
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, int side, float fX, float fY, float fZ, IToolable.ToolType tool) {
        if (tool == IToolable.ToolType.HAND_DRILL) {
            TileEntityPneumoTubePaintable tube;
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof TileEntityPneumoTubePaintable && (tube = (TileEntityPneumoTubePaintable)tile).block != null) {
                tube.block = null;
                world.func_147471_g(x, y, z);
                tube.func_70296_d();
            }
        } else if (tool == IToolable.ToolType.SCREWDRIVER) {
            TileEntity tile;
            if (world.field_72995_K) {
                return true;
            }
            TileEntityPneumoTube tube = (TileEntityPneumoTube)world.func_147438_o(x, y, z);
            ForgeDirection rot = player.func_70093_af() ? tube.ejectionDir : tube.insertionDir;
            ForgeDirection oth = player.func_70093_af() ? tube.insertionDir : tube.ejectionDir;
            for (int i = 0; i < 7 && (rot = ForgeDirection.getOrientation((int)((rot.ordinal() + 1) % 7))) != ForgeDirection.UNKNOWN && (rot == oth || (tile = Compat.getTileStandard(world, x + rot.offsetX, y + rot.offsetY, z + rot.offsetZ)) instanceof TileEntityPneumoTube || !(tile instanceof IInventory)); ++i) {
            }
            if (player.func_70093_af()) {
                tube.ejectionDir = rot;
            } else {
                tube.insertionDir = rot;
            }
            tube.func_70296_d();
            if (world instanceof WorldServer) {
                ((WorldServer)world).func_73040_p().func_151250_a(x, y, z);
            }
            return true;
        }
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float fX, float fY, float fZ) {
        TileEntity tile;
        ItemStack stack = player.func_70694_bm();
        if (stack != null && stack.func_77973_b() instanceof ItemBlock) {
            TileEntityPneumoTubePaintable tube;
            TileEntity tile2;
            ItemBlock ib = (ItemBlock)stack.func_77973_b();
            Block block = ib.field_150939_a;
            if (block.func_149686_d() && block != this && (tile2 = world.func_147438_o(x, y, z)) instanceof TileEntityPneumoTubePaintable && (tube = (TileEntityPneumoTubePaintable)tile2).block == null) {
                tube.block = block;
                tube.meta = stack.func_77960_j() & 0xF;
                world.func_147471_g(x, y, z);
                tube.func_70296_d();
                return true;
            }
        } else if (IToolable.ToolType.getType(stack) == IToolable.ToolType.SCREWDRIVER || IToolable.ToolType.getType(stack) == IToolable.ToolType.HAND_DRILL) {
            return false;
        }
        if (!player.func_70093_af() && (tile = world.func_147438_o(x, y, z)) instanceof TileEntityPneumoTube) {
            TileEntityPneumoTube tube = (TileEntityPneumoTube)tile;
            if (tube.isCompressor()) {
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MainRegistry.instance, (int)0, (World)world, (int)x, (int)y, (int)z);
                return true;
            }
            if (tube.isEndpoint()) {
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MainRegistry.instance, (int)1, (World)world, (int)x, (int)y, (int)z);
                return true;
            }
        }
        return false;
    }

    public static class TileEntityPneumoTubePaintable
    extends TileEntityPneumoTube
    implements ICopiable {
        private Block block;
        private int meta;
        private Block lastBlock;
        private int lastMeta;

        @Override
        public void func_145845_h() {
            super.func_145845_h();
            if (this.field_145850_b.field_72995_K && (this.lastMeta != this.meta || this.lastBlock != this.block)) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.lastBlock = this.block;
                this.lastMeta = this.meta;
            }
        }

        @Override
        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            int id = nbt.func_74762_e("block");
            this.block = id == 0 ? null : Block.func_149729_e((int)id);
            this.meta = nbt.func_74762_e("meta");
        }

        @Override
        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            if (this.block != null) {
                nbt.func_74768_a("block", Block.func_149682_b((Block)this.block));
            }
            nbt.func_74768_a("meta", this.meta);
        }

        @Override
        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
            NBTTagCompound nbt = pkt.func_148857_g();
            int id = nbt.func_74762_e("block");
            this.block = id == 0 ? null : Block.func_149729_e((int)id);
            this.meta = nbt.func_74762_e("meta");
            super.onDataPacket(net, pkt);
        }

        @Override
        public Packet func_145844_m() {
            NBTTagCompound nbt = new NBTTagCompound();
            if (this.block != null) {
                nbt.func_74768_a("block", Block.func_149682_b((Block)this.block));
            }
            nbt.func_74768_a("meta", this.meta);
            nbt.func_74774_a("insertionDir", (byte)this.insertionDir.ordinal());
            nbt.func_74774_a("ejectionDir", (byte)this.ejectionDir.ordinal());
            return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
        }

        @Override
        public NBTTagCompound getSettings(World world, int x, int y, int z) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (this.block != null) {
                nbt.func_74768_a("paintblock", Block.func_149682_b((Block)this.block));
                nbt.func_74768_a("paintmeta", this.meta);
            }
            return nbt;
        }

        @Override
        public void pasteSettings(NBTTagCompound nbt, int index, World world, EntityPlayer player, int x, int y, int z) {
            if (nbt.func_74764_b("paintblock")) {
                this.block = Block.func_149729_e((int)nbt.func_74762_e("paintblock"));
                this.meta = nbt.func_74762_e("paintmeta");
            }
        }
    }
}

