/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine.pile;

import api.hbm.block.IToolable;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.pile.BlockGraphiteDrilledTE;
import com.hbm.items.ModItems;
import com.hbm.tileentity.machine.pile.TileEntityPileNeutronDetector;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockGraphiteNeutronDetector
extends BlockGraphiteDrilledTE {
    @SideOnly(value=Side.CLIENT)
    protected IIcon outIcon;
    @SideOnly(value=Side.CLIENT)
    protected IIcon outIconAluminum;

    public TileEntity func_149915_a(World world, int p_149915_2_) {
        return new TileEntityPileNeutronDetector();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.blockIconAluminum = iconRegister.func_94245_a("hbm:block_graphite_detector_aluminum");
        this.outIconAluminum = iconRegister.func_94245_a("hbm:block_graphite_detector_out_aluminum");
        this.outIcon = iconRegister.func_94245_a("hbm:block_graphite_detector_out");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        int cfg = metadata & 3;
        if (side == cfg * 2 || side == cfg * 2 + 1) {
            if ((metadata & 4) == 4) {
                return (metadata & 8) > 0 ? this.outIconAluminum : this.blockIconAluminum;
            }
            return (metadata & 8) > 0 ? this.outIcon : this.field_149761_L;
        }
        return this.sideIcon;
    }

    public void triggerRods(World world, int x, int y, int z) {
        int oldMeta = world.func_72805_g(x, y, z);
        int newMeta = oldMeta ^ 8;
        int pureMeta = oldMeta & 3;
        world.func_72921_c(x, y, z, newMeta, 3);
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "hbm:item.techBleep", 0.02f, 1.0f);
        ForgeDirection dir = ForgeDirection.getOrientation((int)(pureMeta * 2));
        if (dir == ForgeDirection.UNKNOWN) {
            return;
        }
        for (int i = -1; i <= 1; ++i) {
            int ix = x + dir.offsetX * i;
            int iy = y + dir.offsetY * i;
            int iz = z + dir.offsetZ * i;
            while (world.func_147439_a(ix, iy, iz) == ModBlocks.block_graphite_rod && world.func_72805_g(ix, iy, iz) == oldMeta) {
                world.func_72921_c(ix, iy, iz, newMeta, 3);
                ix += dir.offsetX * i;
                iy += dir.offsetY * i;
                iz += dir.offsetZ * i;
            }
        }
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, int side, float fX, float fY, float fZ, IToolable.ToolType tool) {
        if (!world.field_72995_K) {
            if (tool == IToolable.ToolType.SCREWDRIVER) {
                int meta = world.func_72805_g(x, y, z);
                int cfg = meta & 3;
                if (!player.func_70093_af()) {
                    if (side == cfg * 2 || side == cfg * 2 + 1) {
                        world.func_147465_d(x, y, z, ModBlocks.block_graphite_drilled, meta & 7, 3);
                        BlockGraphiteNeutronDetector.ejectItem(world, x, y, z, ForgeDirection.getOrientation((int)side), new ItemStack(this.getInsertedItem()));
                    }
                } else {
                    TileEntityPileNeutronDetector pile = (TileEntityPileNeutronDetector)world.func_147438_o(x, y, z);
                    player.func_146105_b(new ChatComponentText("CP1 FUEL ASSEMBLY " + x + " " + y + " " + z).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GOLD)));
                    player.func_146105_b(new ChatComponentText("FLUX: " + pile.lastNeutrons + "/" + pile.maxNeutrons).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)));
                }
            }
            if (tool == IToolable.ToolType.DEFUSER) {
                TileEntityPileNeutronDetector pile = (TileEntityPileNeutronDetector)world.func_147438_o(x, y, z);
                if (player.func_70093_af()) {
                    if (pile.maxNeutrons > 1) {
                        --pile.maxNeutrons;
                    }
                } else {
                    ++pile.maxNeutrons;
                }
            }
        }
        return true;
    }

    @Override
    protected Item getInsertedItem() {
        return ModItems.pile_rod_detector;
    }
}

