/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import api.hbm.block.IToolable;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.tileentity.TileEntityLoadedBase;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockEmitter
extends BlockContainer
implements IToolable,
ITooltipProvider {
    public BlockEmitter() {
        super(Material.field_151573_f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityEmitter();
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int l = BlockPistonBase.func_150071_a((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)player);
        world.func_72921_c(x, y, z, l, 2);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int i, float fx, float fy, float fz) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityEmitter te = (TileEntityEmitter)world.func_147438_o(x, y, z);
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemDye) {
            te.color = ItemDye.field_150922_c[player.func_70694_bm().func_77960_j()];
            te.func_70296_d();
            world.func_147471_g(x, y, z);
            --player.func_70694_bm().field_77994_a;
            return true;
        }
        return false;
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, int side, float fX, float fY, float fZ, IToolable.ToolType tool) {
        TileEntityEmitter te = (TileEntityEmitter)world.func_147438_o(x, y, z);
        if (tool == IToolable.ToolType.SCREWDRIVER) {
            te.girth += 0.125f;
            te.func_70296_d();
            return true;
        }
        if (tool == IToolable.ToolType.DEFUSER) {
            te.girth -= 0.125f;
            if (te.girth < 0.125f) {
                te.girth = 0.125f;
            }
            te.func_70296_d();
            return true;
        }
        if (tool == IToolable.ToolType.HAND_DRILL) {
            te.effect = (te.effect + 1) % 5;
            te.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        list.add(EnumChatFormatting.GOLD + "Use screwdriver to widen beam");
        list.add(EnumChatFormatting.GOLD + "Use defuser to narrow beam");
        list.add(EnumChatFormatting.GOLD + "Use hand drill to cycle special effects");
        list.add(EnumChatFormatting.GOLD + "Use dye to change color");
    }

    public static class TileEntityEmitter
    extends TileEntityLoadedBase {
        public static final int range = 100;
        public int color;
        public int beam;
        public float girth = 0.5f;
        public int effect = 0;
        public static final int effectCount = 5;

        public void func_145845_h() {
            if (!this.field_145850_b.field_72995_K) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p());
                if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                    for (int i = 1; i <= 100; ++i) {
                        this.beam = i;
                        int x = this.field_145851_c + dir.offsetX * i;
                        int y = this.field_145848_d + dir.offsetY * i;
                        int z = this.field_145849_e + dir.offsetZ * i;
                        Block b = this.field_145850_b.func_147439_a(x, y, z);
                        if (b.func_149747_d((IBlockAccess)this.field_145850_b, x, y, z, dir.ordinal())) break;
                    }
                }
                if (this.effect == 4 && this.beam > 0 && this.field_145850_b.func_82737_E() % 5L == 0L) {
                    double x = (double)((int)((long)this.field_145851_c + (long)dir.offsetX * (this.field_145850_b.func_82737_E() / 5L) % (long)this.beam)) + 0.5;
                    double y = (double)((int)((long)this.field_145848_d + (long)dir.offsetY * (this.field_145850_b.func_82737_E() / 5L) % (long)this.beam)) + 0.5;
                    double z = (double)((int)((long)this.field_145849_e + (long)dir.offsetZ * (this.field_145850_b.func_82737_E() / 5L) % (long)this.beam)) + 0.5;
                    int prevColor = this.color;
                    if (this.color == 0) {
                        this.color = Color.HSBtoRGB((float)this.field_145850_b.func_82737_E() / 50.0f, 0.5f, 0.25f) & 0xFFFFFF;
                    }
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "plasmablast");
                    data.func_74776_a("r", (float)((this.color & 0xFF0000) >> 16) / 256.0f);
                    data.func_74776_a("g", (float)((this.color & 0xFF00) >> 8) / 256.0f);
                    data.func_74776_a("b", (float)(this.color & 0xFF) / 256.0f);
                    data.func_74776_a("scale", this.girth * 5.0f);
                    if (this.func_145832_p() == 2) {
                        data.func_74776_a("pitch", 90.0f);
                    }
                    if (this.func_145832_p() == 3) {
                        data.func_74776_a("pitch", -90.0f);
                    }
                    if (this.func_145832_p() == 4) {
                        data.func_74776_a("pitch", 90.0f);
                        data.func_74776_a("yaw", 90.0f);
                    }
                    if (this.func_145832_p() == 5) {
                        data.func_74776_a("pitch", -90.0f);
                        data.func_74776_a("yaw", 90.0f);
                    }
                    PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(data, x, y, z), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, x, y, z, 100.0));
                    this.color = prevColor;
                }
                this.networkPackNT(150);
            }
        }

        public Packet func_145844_m() {
            NBTTagCompound nbt = new NBTTagCompound();
            this.func_145841_b(nbt);
            return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
            this.func_145839_a(pkt.func_148857_g());
        }

        @Override
        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.color = nbt.func_74762_e("color");
            this.girth = nbt.func_74760_g("girth");
            this.effect = nbt.func_74762_e("effect");
        }

        @Override
        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            nbt.func_74768_a("color", this.color);
            nbt.func_74776_a("girth", this.girth);
            nbt.func_74768_a("effect", this.effect);
        }

        public AxisAlignedBB getRenderBoundingBox() {
            return TileEntity.INFINITE_EXTENT_AABB;
        }

        @SideOnly(value=Side.CLIENT)
        public double func_145833_n() {
            return 65536.0;
        }

        @Override
        public void serialize(ByteBuf buf) {
            buf.writeInt(this.beam);
            buf.writeInt(this.color);
            buf.writeFloat(this.girth);
            buf.writeInt(this.effect);
        }

        @Override
        public void deserialize(ByteBuf buf) {
            this.beam = buf.readInt();
            this.color = buf.readInt();
            this.girth = buf.readFloat();
            this.effect = buf.readInt();
        }
    }
}

